/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.netty.handler.codec.http2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.DefaultHttp2Headers;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.Http2Headers;
import org.glowroot.agent.shaded.io.netty.util.AsciiString;

public final class ReadOnlyHttp2Headers
implements Http2Headers {
    private final AsciiString[] pseudoHeaders;
    private final AsciiString[] otherHeaders;

    public static ReadOnlyHttp2Headers serverHeaders(boolean validateHeaders, AsciiString status, AsciiString ... otherHeaders) {
        return new ReadOnlyHttp2Headers(validateHeaders, new AsciiString[]{Http2Headers.PseudoHeaderName.STATUS.value(), status}, otherHeaders);
    }

    private ReadOnlyHttp2Headers(boolean validateHeaders, AsciiString[] pseudoHeaders, AsciiString ... otherHeaders) {
        assert ((pseudoHeaders.length & 1) == 0);
        if ((otherHeaders.length & 1) != 0) {
            throw ReadOnlyHttp2Headers.newInvalidArraySizeException();
        }
        if (validateHeaders) {
            ReadOnlyHttp2Headers.validateHeaders(pseudoHeaders, otherHeaders);
        }
        this.pseudoHeaders = pseudoHeaders;
        this.otherHeaders = otherHeaders;
    }

    private static IllegalArgumentException newInvalidArraySizeException() {
        return new IllegalArgumentException("pseudoHeaders and otherHeaders must be arrays of [name, value] pairs");
    }

    private static void validateHeaders(AsciiString[] pseudoHeaders, AsciiString ... otherHeaders) {
        for (int i = 1; i < pseudoHeaders.length; i += 2) {
            if (pseudoHeaders[i] != null) continue;
            throw new IllegalArgumentException("pseudoHeaders value at index " + i + " is null");
        }
        boolean seenNonPseudoHeader = false;
        int otherHeadersEnd = otherHeaders.length - 1;
        for (int i = 0; i < otherHeadersEnd; i += 2) {
            AsciiString name = otherHeaders[i];
            DefaultHttp2Headers.HTTP2_NAME_VALIDATOR.validateName(name);
            if (!seenNonPseudoHeader && !name.isEmpty() && name.byteAt(0) != 58) {
                seenNonPseudoHeader = true;
            } else if (seenNonPseudoHeader && !name.isEmpty() && name.byteAt(0) == 58) {
                throw new IllegalArgumentException("otherHeaders name at index " + i + " is a pseudo header that appears after non-pseudo headers.");
            }
            if (otherHeaders[i + 1] != null) continue;
            throw new IllegalArgumentException("otherHeaders value at index " + (i + 1) + " is null");
        }
    }

    private AsciiString get0(CharSequence name) {
        int nameHash = AsciiString.hashCode(name);
        int pseudoHeadersEnd = this.pseudoHeaders.length - 1;
        for (int i = 0; i < pseudoHeadersEnd; i += 2) {
            AsciiString roName = this.pseudoHeaders[i];
            if (roName.hashCode() != nameHash || !roName.contentEqualsIgnoreCase(name)) continue;
            return this.pseudoHeaders[i + 1];
        }
        int otherHeadersEnd = this.otherHeaders.length - 1;
        for (int i = 0; i < otherHeadersEnd; i += 2) {
            AsciiString roName = this.otherHeaders[i];
            if (roName.hashCode() != nameHash || !roName.contentEqualsIgnoreCase(name)) continue;
            return this.otherHeaders[i + 1];
        }
        return null;
    }

    @Override
    public CharSequence get(CharSequence name) {
        return this.get0(name);
    }

    @Override
    public List<CharSequence> getAll(CharSequence name) {
        int nameHash = AsciiString.hashCode(name);
        ArrayList<CharSequence> values = new ArrayList<CharSequence>();
        int pseudoHeadersEnd = this.pseudoHeaders.length - 1;
        for (int i = 0; i < pseudoHeadersEnd; i += 2) {
            AsciiString roName = this.pseudoHeaders[i];
            if (roName.hashCode() != nameHash || !roName.contentEqualsIgnoreCase(name)) continue;
            values.add(this.pseudoHeaders[i + 1]);
        }
        int otherHeadersEnd = this.otherHeaders.length - 1;
        for (int i = 0; i < otherHeadersEnd; i += 2) {
            AsciiString roName = this.otherHeaders[i];
            if (roName.hashCode() != nameHash || !roName.contentEqualsIgnoreCase(name)) continue;
            values.add(this.otherHeaders[i + 1]);
        }
        return values;
    }

    @Override
    public int size() {
        return this.pseudoHeaders.length + this.otherHeaders.length >>> 1;
    }

    @Override
    public Http2Headers add(CharSequence name, CharSequence value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iterator() {
        return new ReadOnlyIterator();
    }

    @Override
    public CharSequence status() {
        return this.get(Http2Headers.PseudoHeaderName.STATUS.value());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName()).append('[');
        String separator = "";
        for (Map.Entry<CharSequence, CharSequence> entry : this) {
            builder.append(separator);
            builder.append(entry.getKey()).append(": ").append(entry.getValue());
            separator = ", ";
        }
        return builder.append(']').toString();
    }

    private final class ReadOnlyIterator
    implements Iterator<Map.Entry<CharSequence, CharSequence>>,
    Map.Entry<CharSequence, CharSequence> {
        private int i;
        private AsciiString[] current;
        private AsciiString key;
        private AsciiString value;

        private ReadOnlyIterator() {
            this.current = ReadOnlyHttp2Headers.this.pseudoHeaders.length != 0 ? ReadOnlyHttp2Headers.this.pseudoHeaders : ReadOnlyHttp2Headers.this.otherHeaders;
        }

        @Override
        public boolean hasNext() {
            return this.i != this.current.length;
        }

        @Override
        public Map.Entry<CharSequence, CharSequence> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.key = this.current[this.i];
            this.value = this.current[this.i + 1];
            this.i += 2;
            if (this.i == this.current.length && this.current == ReadOnlyHttp2Headers.this.pseudoHeaders) {
                this.current = ReadOnlyHttp2Headers.this.otherHeaders;
                this.i = 0;
            }
            return this;
        }

        @Override
        public CharSequence getKey() {
            return this.key;
        }

        @Override
        public CharSequence getValue() {
            return this.value;
        }

        @Override
        public CharSequence setValue(CharSequence value) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("read only");
        }

        public String toString() {
            return this.key.toString() + '=' + this.value.toString();
        }
    }
}

