/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.opencensus.common;

import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.io.opencensus.common.AutoValue_Timestamp;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;

@Immutable
public abstract class Timestamp
implements Comparable<Timestamp> {
    private static final Timestamp EPOCH = new AutoValue_Timestamp(0L, 0);

    Timestamp() {
    }

    public static Timestamp create(long seconds, int nanos) {
        if (seconds < -315576000000L || seconds > 315576000000L) {
            return EPOCH;
        }
        if (nanos < 0 || nanos > 999999999) {
            return EPOCH;
        }
        return new AutoValue_Timestamp(seconds, nanos);
    }

    public abstract long getSeconds();

    public abstract int getNanos();

    @Override
    public int compareTo(Timestamp otherTimestamp) {
        int cmp = Longs.compare(this.getSeconds(), otherTimestamp.getSeconds());
        if (cmp != 0) {
            return cmp;
        }
        return Longs.compare(this.getNanos(), otherTimestamp.getNanos());
    }
}

