/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.opencensus.stats;

import java.util.Map;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.io.opencensus.common.Timestamp;
import org.glowroot.agent.shaded.io.opencensus.stats.Measure;
import org.glowroot.agent.shaded.io.opencensus.stats.MeasureMap;
import org.glowroot.agent.shaded.io.opencensus.stats.StatsComponent;
import org.glowroot.agent.shaded.io.opencensus.stats.StatsRecorder;
import org.glowroot.agent.shaded.io.opencensus.stats.ViewManager;
import org.glowroot.agent.shaded.io.opencensus.tags.TagContext;
import org.glowroot.agent.shaded.javax.annotation.concurrent.GuardedBy;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.ThreadSafe;

final class NoopStats {
    static StatsComponent newNoopStatsComponent() {
        return new NoopStatsComponent();
    }

    static StatsRecorder getNoopStatsRecorder() {
        return NoopStatsRecorder.INSTANCE;
    }

    static MeasureMap getNoopMeasureMap() {
        return NoopMeasureMap.INSTANCE;
    }

    static ViewManager newNoopViewManager() {
        return new NoopViewManager();
    }

    @ThreadSafe
    private static final class NoopViewManager
    extends ViewManager {
        private static final Timestamp ZERO_TIMESTAMP = Timestamp.create(0L, 0);
        @GuardedBy(value="registeredViews")
        private final Map<Object, Object> registeredViews = Maps.newHashMap();

        private NoopViewManager() {
        }
    }

    @Immutable
    private static final class NoopMeasureMap
    extends MeasureMap {
        static final MeasureMap INSTANCE = new NoopMeasureMap();

        private NoopMeasureMap() {
        }

        @Override
        public MeasureMap put(Measure.MeasureDouble measure, double value) {
            return this;
        }

        @Override
        public MeasureMap put(Measure.MeasureLong measure, long value) {
            return this;
        }

        @Override
        public void record(TagContext tags) {
            Preconditions.checkNotNull(tags, "tags");
        }
    }

    @Immutable
    private static final class NoopStatsRecorder
    extends StatsRecorder {
        static final StatsRecorder INSTANCE = new NoopStatsRecorder();

        private NoopStatsRecorder() {
        }

        @Override
        public MeasureMap newMeasureMap() {
            return NoopStats.getNoopMeasureMap();
        }
    }

    @ThreadSafe
    private static final class NoopStatsComponent
    extends StatsComponent {
        private final ViewManager viewManager = NoopStats.newNoopViewManager();

        private NoopStatsComponent() {
        }

        @Override
        public StatsRecorder getStatsRecorder() {
            return NoopStats.getNoopStatsRecorder();
        }
    }
}

