/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.opencensus.tags;

import org.glowroot.agent.jul.Level;
import org.glowroot.agent.jul.Logger;
import org.glowroot.agent.shaded.io.opencensus.internal.Provider;
import org.glowroot.agent.shaded.io.opencensus.tags.NoopTags;
import org.glowroot.agent.shaded.io.opencensus.tags.Tagger;
import org.glowroot.agent.shaded.io.opencensus.tags.TagsComponent;
import org.glowroot.agent.shaded.io.opencensus.tags.propagation.TagPropagationComponent;
import org.glowroot.agent.shaded.javax.annotation.Nullable;

public final class Tags {
    private static final Logger logger = Logger.getLogger(Tags.class.getName());
    private static final TagsComponent tagsComponent = Tags.loadTagsComponent(TagsComponent.class.getClassLoader());

    private Tags() {
    }

    public static Tagger getTagger() {
        return tagsComponent.getTagger();
    }

    public static TagPropagationComponent getTagPropagationComponent() {
        return tagsComponent.getTagPropagationComponent();
    }

    static TagsComponent loadTagsComponent(@Nullable ClassLoader classLoader) {
        try {
            return Provider.createInstance(Class.forName("org.glowroot.agent.shaded.io.opencensus.impl.tags.TagsComponentImpl", true, classLoader), TagsComponent.class);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Couldn't load full implementation for TagsComponent, now trying to load lite implementation.", e);
            try {
                return Provider.createInstance(Class.forName("org.glowroot.agent.shaded.io.opencensus.impllite.tags.TagsComponentImplLite", true, classLoader), TagsComponent.class);
            }
            catch (ClassNotFoundException e2) {
                logger.log(Level.FINE, "Couldn't load lite implementation for TagsComponent, now using default implementation for TagsComponent.", e2);
                return NoopTags.newNoopTagsComponent();
            }
        }
    }
}

