/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.opencensus.trace;

import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Objects;
import org.glowroot.agent.shaded.io.opencensus.trace.SpanId;
import org.glowroot.agent.shaded.io.opencensus.trace.TraceId;
import org.glowroot.agent.shaded.io.opencensus.trace.TraceOptions;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;

@Immutable
public final class SpanContext {
    private final TraceId traceId;
    private final SpanId spanId;
    private final TraceOptions traceOptions;
    public static final SpanContext INVALID = new SpanContext(TraceId.INVALID, SpanId.INVALID, TraceOptions.DEFAULT);

    public SpanId getSpanId() {
        return this.spanId;
    }

    public TraceOptions getTraceOptions() {
        return this.traceOptions;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SpanContext)) {
            return false;
        }
        SpanContext that = (SpanContext)obj;
        return this.traceId.equals(that.traceId) && this.spanId.equals(that.spanId) && this.traceOptions.equals(that.traceOptions);
    }

    public int hashCode() {
        return Objects.hashCode(this.traceId, this.spanId, this.traceOptions);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("traceId", this.traceId).add("spanId", this.spanId).add("traceOptions", this.traceOptions).toString();
    }

    private SpanContext(TraceId traceId, SpanId spanId, TraceOptions traceOptions) {
        this.traceId = traceId;
        this.spanId = spanId;
        this.traceOptions = traceOptions;
    }
}

