/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.opencensus.trace.export;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.io.opencensus.trace.Status;
import org.glowroot.agent.shaded.io.opencensus.trace.export.AutoValue_SampledSpanStore_PerSpanNameSummary;
import org.glowroot.agent.shaded.javax.annotation.concurrent.GuardedBy;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class SampledSpanStore {
    protected SampledSpanStore() {
    }

    static SampledSpanStore newNoopSampledSpanStore() {
        return new NoopSampledSpanStore();
    }

    @ThreadSafe
    private static final class NoopSampledSpanStore
    extends SampledSpanStore {
        private static final PerSpanNameSummary EMPTY_PER_SPAN_NAME_SUMMARY = PerSpanNameSummary.create(Collections.<Object, Integer>emptyMap(), Collections.<Status.CanonicalCode, Integer>emptyMap());
        @GuardedBy(value="registeredSpanNames")
        private final Set<String> registeredSpanNames = Sets.newHashSet();

        private NoopSampledSpanStore() {
        }
    }

    @Immutable
    public static abstract class PerSpanNameSummary {
        PerSpanNameSummary() {
        }

        public static PerSpanNameSummary create(Map<Object, Integer> numbersOfLatencySampledSpans, Map<Status.CanonicalCode, Integer> numbersOfErrorSampledSpans) {
            return new AutoValue_SampledSpanStore_PerSpanNameSummary(Collections.unmodifiableMap(new HashMap<Object, Integer>(Preconditions.checkNotNull(numbersOfLatencySampledSpans, "numbersOfLatencySampledSpans"))), Collections.unmodifiableMap(new HashMap<Status.CanonicalCode, Integer>(Preconditions.checkNotNull(numbersOfErrorSampledSpans, "numbersOfErrorSampledSpans"))));
        }

        public abstract Map<Object, Integer> getNumbersOfLatencySampledSpans();

        public abstract Map<Status.CanonicalCode, Integer> getNumbersOfErrorSampledSpans();
    }
}

