/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.live;

import java.util.ArrayList;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveAggregateRepository;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="LiveAggregateRepository.PercentileAggregate", generator="Immutables")
@Immutable
public final class ImmutablePercentileAggregate
implements LiveAggregateRepository.PercentileAggregate {
    private final long captureTime;
    private final double totalDurationNanos;
    private final long transactionCount;
    private final AggregateOuterClass.Aggregate.Histogram durationNanosHistogram;

    private ImmutablePercentileAggregate(long captureTime, double totalDurationNanos, long transactionCount, AggregateOuterClass.Aggregate.Histogram durationNanosHistogram) {
        this.captureTime = captureTime;
        this.totalDurationNanos = totalDurationNanos;
        this.transactionCount = transactionCount;
        this.durationNanosHistogram = durationNanosHistogram;
    }

    @Override
    @JsonProperty(value="captureTime")
    public long captureTime() {
        return this.captureTime;
    }

    @Override
    @JsonProperty(value="totalDurationNanos")
    public double totalDurationNanos() {
        return this.totalDurationNanos;
    }

    @Override
    @JsonProperty(value="transactionCount")
    public long transactionCount() {
        return this.transactionCount;
    }

    @Override
    @JsonProperty(value="durationNanosHistogram")
    public AggregateOuterClass.Aggregate.Histogram durationNanosHistogram() {
        return this.durationNanosHistogram;
    }

    public final ImmutablePercentileAggregate withCaptureTime(long value) {
        if (this.captureTime == value) {
            return this;
        }
        return new ImmutablePercentileAggregate(value, this.totalDurationNanos, this.transactionCount, this.durationNanosHistogram);
    }

    public final ImmutablePercentileAggregate withTotalDurationNanos(double value) {
        if (Double.doubleToLongBits(this.totalDurationNanos) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutablePercentileAggregate(this.captureTime, value, this.transactionCount, this.durationNanosHistogram);
    }

    public final ImmutablePercentileAggregate withTransactionCount(long value) {
        if (this.transactionCount == value) {
            return this;
        }
        return new ImmutablePercentileAggregate(this.captureTime, this.totalDurationNanos, value, this.durationNanosHistogram);
    }

    public final ImmutablePercentileAggregate withDurationNanosHistogram(AggregateOuterClass.Aggregate.Histogram value) {
        if (this.durationNanosHistogram == value) {
            return this;
        }
        AggregateOuterClass.Aggregate.Histogram newValue = Preconditions.checkNotNull(value, "durationNanosHistogram");
        return new ImmutablePercentileAggregate(this.captureTime, this.totalDurationNanos, this.transactionCount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePercentileAggregate && this.equalTo((ImmutablePercentileAggregate)another);
    }

    private boolean equalTo(ImmutablePercentileAggregate another) {
        return this.captureTime == another.captureTime && Double.doubleToLongBits(this.totalDurationNanos) == Double.doubleToLongBits(another.totalDurationNanos) && this.transactionCount == another.transactionCount && this.durationNanosHistogram.equals(another.durationNanosHistogram);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode(this.captureTime);
        h += (h << 5) + Doubles.hashCode(this.totalDurationNanos);
        h += (h << 5) + Longs.hashCode(this.transactionCount);
        h += (h << 5) + this.durationNanosHistogram.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PercentileAggregate").omitNullValues().add("captureTime", this.captureTime).add("totalDurationNanos", this.totalDurationNanos).add("transactionCount", this.transactionCount).add("durationNanosHistogram", this.durationNanosHistogram).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePercentileAggregate fromJson(Json json) {
        Builder builder = ImmutablePercentileAggregate.builder();
        if (json.captureTimeIsSet) {
            builder.captureTime(json.captureTime);
        }
        if (json.totalDurationNanosIsSet) {
            builder.totalDurationNanos(json.totalDurationNanos);
        }
        if (json.transactionCountIsSet) {
            builder.transactionCount(json.transactionCount);
        }
        if (json.durationNanosHistogram != null) {
            builder.durationNanosHistogram(json.durationNanosHistogram);
        }
        return builder.build();
    }

    public static ImmutablePercentileAggregate copyOf(LiveAggregateRepository.PercentileAggregate instance) {
        if (instance instanceof ImmutablePercentileAggregate) {
            return (ImmutablePercentileAggregate)instance;
        }
        return ImmutablePercentileAggregate.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LiveAggregateRepository.PercentileAggregate", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CAPTURE_TIME = 1L;
        private static final long INIT_BIT_TOTAL_DURATION_NANOS = 2L;
        private static final long INIT_BIT_TRANSACTION_COUNT = 4L;
        private static final long INIT_BIT_DURATION_NANOS_HISTOGRAM = 8L;
        private long initBits = 15L;
        private long captureTime;
        private double totalDurationNanos;
        private long transactionCount;
        @Nullable
        private AggregateOuterClass.Aggregate.Histogram durationNanosHistogram;

        private Builder() {
        }

        public final Builder copyFrom(LiveAggregateRepository.PercentileAggregate instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.captureTime(instance.captureTime());
            this.totalDurationNanos(instance.totalDurationNanos());
            this.transactionCount(instance.transactionCount());
            this.durationNanosHistogram(instance.durationNanosHistogram());
            return this;
        }

        public final Builder captureTime(long captureTime) {
            this.captureTime = captureTime;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder totalDurationNanos(double totalDurationNanos) {
            this.totalDurationNanos = totalDurationNanos;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder transactionCount(long transactionCount) {
            this.transactionCount = transactionCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder durationNanosHistogram(AggregateOuterClass.Aggregate.Histogram durationNanosHistogram) {
            this.durationNanosHistogram = Preconditions.checkNotNull(durationNanosHistogram, "durationNanosHistogram");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutablePercentileAggregate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePercentileAggregate(this.captureTime, this.totalDurationNanos, this.transactionCount, this.durationNanosHistogram);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("captureTime");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("totalDurationNanos");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("transactionCount");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("durationNanosHistogram");
            }
            return "Cannot build PercentileAggregate, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LiveAggregateRepository.PercentileAggregate", generator="Immutables")
    static final class Json
    implements LiveAggregateRepository.PercentileAggregate {
        long captureTime;
        boolean captureTimeIsSet;
        double totalDurationNanos;
        boolean totalDurationNanosIsSet;
        long transactionCount;
        boolean transactionCountIsSet;
        @Nullable
        AggregateOuterClass.Aggregate.Histogram durationNanosHistogram;

        Json() {
        }

        @JsonProperty(value="captureTime")
        public void setCaptureTime(long captureTime) {
            this.captureTime = captureTime;
            this.captureTimeIsSet = true;
        }

        @JsonProperty(value="totalDurationNanos")
        public void setTotalDurationNanos(double totalDurationNanos) {
            this.totalDurationNanos = totalDurationNanos;
            this.totalDurationNanosIsSet = true;
        }

        @JsonProperty(value="transactionCount")
        public void setTransactionCount(long transactionCount) {
            this.transactionCount = transactionCount;
            this.transactionCountIsSet = true;
        }

        @JsonProperty(value="durationNanosHistogram")
        public void setDurationNanosHistogram(AggregateOuterClass.Aggregate.Histogram durationNanosHistogram) {
            this.durationNanosHistogram = durationNanosHistogram;
        }

        @Override
        public long captureTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double totalDurationNanos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long transactionCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggregateOuterClass.Aggregate.Histogram durationNanosHistogram() {
            throw new UnsupportedOperationException();
        }
    }
}

