/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.live;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.live.StringComparator;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.ProfileOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.TraceOuterClass;
import org.immutables.value.Value;

public interface LiveTraceRepository {
    public TraceOuterClass.Trace.Header getHeader(String var1, String var2) throws Exception;

    @Nullable
    public Entries getEntries(String var1, String var2) throws Exception;

    @Nullable
    public Queries getQueries(String var1, String var2) throws Exception;

    @Nullable
    public ProfileOuterClass.Profile getMainThreadProfile(String var1, String var2) throws Exception;

    @Nullable
    public ProfileOuterClass.Profile getAuxThreadProfile(String var1, String var2) throws Exception;

    @Nullable
    public TraceOuterClass.Trace getFullTrace(String var1, String var2) throws Exception;

    public int getMatchingTraceCount(String var1, @Nullable String var2);

    public List<TracePoint> getMatchingActiveTracePoints(TraceKind var1, String var2, @Nullable String var3, TracePointFilter var4, int var5, long var6, long var8);

    public List<TracePoint> getMatchingPendingPoints(TraceKind var1, String var2, @Nullable String var3, TracePointFilter var4, long var5);

    public Set<String> getTransactionTypes(String var1);

    public static class LiveTraceRepositoryNop
    implements LiveTraceRepository {
        @Override
        public Set<String> getTransactionTypes(String agentId) {
            return ImmutableSet.of();
        }

        @Override
        public TraceOuterClass.Trace.Header getHeader(String agentId, String traceId) {
            return null;
        }

        @Override
        @Nullable
        public Entries getEntries(String agentId, String traceId) {
            return null;
        }

        @Override
        @Nullable
        public Queries getQueries(String agentId, String traceId) {
            return null;
        }

        @Override
        @Nullable
        public ProfileOuterClass.Profile getMainThreadProfile(String agentId, String traceId) {
            return null;
        }

        @Override
        @Nullable
        public ProfileOuterClass.Profile getAuxThreadProfile(String agentId, String traceId) {
            return null;
        }

        @Override
        @Nullable
        public TraceOuterClass.Trace getFullTrace(String agentId, String traceId) {
            return null;
        }

        @Override
        public int getMatchingTraceCount(String transactionType, @Nullable String transactionName) {
            return 0;
        }

        @Override
        public List<TracePoint> getMatchingActiveTracePoints(TraceKind traceKind, String transactionType, @Nullable String transactionName, TracePointFilter filter, int limit, long captureTime, long captureTick) {
            return ImmutableList.of();
        }

        @Override
        public List<TracePoint> getMatchingPendingPoints(TraceKind traceKind, String transactionType, @Nullable String transactionName, TracePointFilter filter, long captureTime) {
            return ImmutableList.of();
        }
    }

    public static enum Existence {
        YES,
        NO,
        EXPIRED;

    }

    public static enum TraceKind {
        SLOW,
        ERROR;

    }

    @Value.Immutable
    public static interface TracePoint {
        public String agentId();

        public String traceId();

        public long captureTime();

        public long durationNanos();

        public boolean partial();

        public boolean error();

        public boolean checkLiveTraces();
    }

    @Value.Immutable
    public static abstract class TracePointFilter {
        public abstract long durationNanosLow();

        @Nullable
        public abstract Long durationNanosHigh();

        @Nullable
        public abstract StringComparator headlineComparator();

        @Nullable
        public abstract String headline();

        @Nullable
        public abstract StringComparator errorMessageComparator();

        @Nullable
        public abstract String errorMessage();

        @Nullable
        public abstract StringComparator userComparator();

        @Nullable
        public abstract String user();

        @Nullable
        public abstract String attributeName();

        @Nullable
        public abstract StringComparator attributeValueComparator();

        @Nullable
        public abstract String attributeValue();

        public boolean matchesDuration(long durationNanos) {
            if (durationNanos < this.durationNanosLow()) {
                return false;
            }
            Long durationNanosHigh = this.durationNanosHigh();
            return durationNanosHigh == null || durationNanos <= durationNanosHigh;
        }

        public boolean matchesHeadline(String headline) {
            return TracePointFilter.matchesUsingStringComparator(headline, this.headline(), this.headlineComparator());
        }

        public boolean matchesError(String errorMessage) {
            return TracePointFilter.matchesUsingStringComparator(errorMessage, this.errorMessage(), this.errorMessageComparator());
        }

        public boolean matchesUser(String user) {
            return TracePointFilter.matchesUsingStringComparator(user, this.user(), this.userComparator());
        }

        public boolean matchesAttributes(Map<String, ? extends Collection<String>> attributes) {
            if (Strings.isNullOrEmpty(this.attributeName()) && (this.attributeValueComparator() == null || Strings.isNullOrEmpty(this.attributeValue()))) {
                return true;
            }
            for (Map.Entry<String, ? extends Collection<String>> entry : attributes.entrySet()) {
                String attributeName = entry.getKey();
                if (!TracePointFilter.matchesUsingStringComparator(attributeName, this.attributeName(), StringComparator.EQUALS)) continue;
                for (String attributeValue : entry.getValue()) {
                    if (!TracePointFilter.matchesUsingStringComparator(attributeValue, this.attributeValue(), this.attributeValueComparator())) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean matchesUsingStringComparator(String text, @Nullable String filterText, @Nullable StringComparator filterComparator) throws AssertionError {
            if (filterComparator == null || Strings.isNullOrEmpty(filterText)) {
                return true;
            }
            return filterComparator.matches(text, filterText);
        }
    }

    @Value.Immutable
    public static interface EntriesAndQueries {
        public List<TraceOuterClass.Trace.Entry> entries();

        public List<AggregateOuterClass.Aggregate.Query> queries();

        public List<TraceOuterClass.Trace.SharedQueryText> sharedQueryTexts();
    }

    @Value.Immutable
    public static interface Queries {
        public List<AggregateOuterClass.Aggregate.Query> queries();

        public List<TraceOuterClass.Trace.SharedQueryText> sharedQueryTexts();
    }

    @Value.Immutable
    public static interface Entries {
        public List<TraceOuterClass.Trace.Entry> entries();

        public List<TraceOuterClass.Trace.SharedQueryText> sharedQueryTexts();
    }
}

