/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.model;

import java.util.ArrayList;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.glowroot.common.model.OverallSummaryCollector;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="OverallSummaryCollector.OverallSummary", generator="Immutables")
@Immutable
public final class ImmutableOverallSummary
implements OverallSummaryCollector.OverallSummary {
    private final double totalDurationNanos;
    private final long transactionCount;

    private ImmutableOverallSummary(double totalDurationNanos, long transactionCount) {
        this.totalDurationNanos = totalDurationNanos;
        this.transactionCount = transactionCount;
    }

    @Override
    @JsonProperty(value="totalDurationNanos")
    public double totalDurationNanos() {
        return this.totalDurationNanos;
    }

    @Override
    @JsonProperty(value="transactionCount")
    public long transactionCount() {
        return this.transactionCount;
    }

    public final ImmutableOverallSummary withTotalDurationNanos(double value) {
        if (Double.doubleToLongBits(this.totalDurationNanos) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableOverallSummary(value, this.transactionCount);
    }

    public final ImmutableOverallSummary withTransactionCount(long value) {
        if (this.transactionCount == value) {
            return this;
        }
        return new ImmutableOverallSummary(this.totalDurationNanos, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOverallSummary && this.equalTo((ImmutableOverallSummary)another);
    }

    private boolean equalTo(ImmutableOverallSummary another) {
        return Double.doubleToLongBits(this.totalDurationNanos) == Double.doubleToLongBits(another.totalDurationNanos) && this.transactionCount == another.transactionCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Doubles.hashCode(this.totalDurationNanos);
        h += (h << 5) + Longs.hashCode(this.transactionCount);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("OverallSummary").omitNullValues().add("totalDurationNanos", this.totalDurationNanos).add("transactionCount", this.transactionCount).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOverallSummary fromJson(Json json) {
        Builder builder = ImmutableOverallSummary.builder();
        if (json.totalDurationNanosIsSet) {
            builder.totalDurationNanos(json.totalDurationNanos);
        }
        if (json.transactionCountIsSet) {
            builder.transactionCount(json.transactionCount);
        }
        return builder.build();
    }

    public static ImmutableOverallSummary copyOf(OverallSummaryCollector.OverallSummary instance) {
        if (instance instanceof ImmutableOverallSummary) {
            return (ImmutableOverallSummary)instance;
        }
        return ImmutableOverallSummary.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OverallSummaryCollector.OverallSummary", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOTAL_DURATION_NANOS = 1L;
        private static final long INIT_BIT_TRANSACTION_COUNT = 2L;
        private long initBits = 3L;
        private double totalDurationNanos;
        private long transactionCount;

        private Builder() {
        }

        public final Builder copyFrom(OverallSummaryCollector.OverallSummary instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.totalDurationNanos(instance.totalDurationNanos());
            this.transactionCount(instance.transactionCount());
            return this;
        }

        public final Builder totalDurationNanos(double totalDurationNanos) {
            this.totalDurationNanos = totalDurationNanos;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder transactionCount(long transactionCount) {
            this.transactionCount = transactionCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableOverallSummary build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOverallSummary(this.totalDurationNanos, this.transactionCount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("totalDurationNanos");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("transactionCount");
            }
            return "Cannot build OverallSummary, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="OverallSummaryCollector.OverallSummary", generator="Immutables")
    static final class Json
    implements OverallSummaryCollector.OverallSummary {
        double totalDurationNanos;
        boolean totalDurationNanosIsSet;
        long transactionCount;
        boolean transactionCountIsSet;

        Json() {
        }

        @JsonProperty(value="totalDurationNanos")
        public void setTotalDurationNanos(double totalDurationNanos) {
            this.totalDurationNanos = totalDurationNanos;
            this.totalDurationNanosIsSet = true;
        }

        @JsonProperty(value="transactionCount")
        public void setTransactionCount(long transactionCount) {
            this.transactionCount = transactionCount;
            this.transactionCountIsSet = true;
        }

        @Override
        public double totalDurationNanos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long transactionCount() {
            throw new UnsupportedOperationException();
        }
    }
}

