/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.model;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.glowroot.agent.shaded.com.google.protobuf.ByteString;
import org.glowroot.agent.shaded.org.HdrHistogram.Histogram;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;

public class LazyHistogram {
    private static final int HISTOGRAM_SIGNIFICANT_DIGITS = 5;
    private static final int MAX_VALUES = 1024;
    private long[] values = new long[8];
    private int size;
    private boolean sorted;
    @MonotonicNonNull
    private Histogram histogram;

    public LazyHistogram() {
    }

    public LazyHistogram(AggregateOuterClass.Aggregate.Histogram hist) {
        ByteString encodedBytes = hist.getEncodedBytes();
        if (encodedBytes.isEmpty()) {
            List<Long> orderedRawValues = hist.getOrderedRawValueList();
            this.values = new long[orderedRawValues.size()];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = orderedRawValues.get(i);
            }
            this.size = this.values.length;
        } else {
            this.histogram = Histogram.decodeFromByteBuffer(encodedBytes.asReadOnlyByteBuffer(), 0L);
        }
    }

    public AggregateOuterClass.Aggregate.Histogram toProto(ScratchBuffer scratchBuffer) {
        final AggregateOuterClass.Aggregate.Histogram.Builder builder = AggregateOuterClass.Aggregate.Histogram.newBuilder();
        if (this.histogram == null) {
            if (!this.sorted) {
                this.sortValues();
            }
            for (int i = 0; i < this.size; ++i) {
                builder.addOrderedRawValue(this.values[i]);
            }
        } else {
            scratchBuffer.execute(this.histogram.getNeededByteBufferCapacity(), new DoWithByteBuffer(){

                @Override
                public void call(ByteBuffer buffer) {
                    ((Buffer)buffer).clear();
                    LazyHistogram.this.histogram.encodeIntoByteBuffer(buffer);
                    int size = buffer.position();
                    ((Buffer)buffer).flip();
                    builder.setEncodedBytes(ByteString.copyFrom(buffer, size));
                }
            });
        }
        return builder.build();
    }

    public void merge(AggregateOuterClass.Aggregate.Histogram toBeMergedHistogram) {
        ByteString encodedBytes = toBeMergedHistogram.getEncodedBytes();
        if (encodedBytes.isEmpty()) {
            for (long rawValue : toBeMergedHistogram.getOrderedRawValueList()) {
                this.add(rawValue);
            }
        } else {
            if (this.histogram == null) {
                this.convertValuesToHistogram();
            }
            this.histogram.add(Histogram.decodeFromByteBuffer(encodedBytes.asReadOnlyByteBuffer(), 0L));
        }
    }

    public void merge(LazyHistogram toBeMergedHistogram) {
        if (toBeMergedHistogram.histogram == null) {
            for (int i = 0; i < toBeMergedHistogram.size; ++i) {
                this.add(toBeMergedHistogram.values[i]);
            }
        } else {
            if (this.histogram == null) {
                this.convertValuesToHistogram();
            }
            this.histogram.add(toBeMergedHistogram.histogram);
        }
    }

    public long getValueAtPercentile(double percentile) {
        if (this.histogram == null) {
            if (this.size == 0) {
                return 0L;
            }
            if (!this.sorted) {
                this.sortValues();
            }
            if (percentile == 0.0) {
                return this.values[0];
            }
            return this.values[(int)Math.ceil((double)this.size * percentile / 100.0) - 1];
        }
        return this.histogram.getValueAtPercentile(percentile);
    }

    public void add(long value) {
        this.ensureCapacity(this.size + 1);
        if (this.histogram != null) {
            this.histogram.recordValue(value);
        } else {
            this.values[this.size++] = value;
            this.sorted = false;
        }
    }

    private void ensureCapacity(int capacity) {
        if (this.histogram != null) {
            return;
        }
        if (capacity > 1024) {
            this.convertValuesToHistogram();
            return;
        }
        if (capacity > this.values.length) {
            long[] temp = new long[Math.max(this.size * 2, capacity)];
            System.arraycopy(this.values, 0, temp, 0, this.size);
            this.values = temp;
        }
    }

    @EnsuresNonNull(value={"histogram"})
    private void convertValuesToHistogram() {
        this.histogram = new Histogram(1000L, 2000L, 5);
        this.histogram.setAutoResize(true);
        for (int i = 0; i < this.size; ++i) {
            this.histogram.recordValue(this.values[i]);
        }
        this.values = new long[0];
    }

    private void sortValues() {
        Arrays.sort(this.values, 0, this.size);
        this.sorted = true;
    }

    static interface DoWithByteBuffer {
        public void call(ByteBuffer var1);
    }

    public static class ScratchBuffer {
        @MonotonicNonNull
        private ByteBuffer buffer;
        private final Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void execute(int requiredCapacity, DoWithByteBuffer doWithBuffer) {
            Object object = this.lock;
            synchronized (object) {
                if (this.buffer == null || this.buffer.capacity() < requiredCapacity) {
                    this.buffer = ByteBuffer.allocate(requiredCapacity);
                }
                doWithBuffer.call(this.buffer);
            }
        }
    }
}

