/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.shaded.org.objectweb.asm.ModuleVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.tree.ModuleExportNode;
import org.glowroot.agent.shaded.org.objectweb.asm.tree.ModuleOpenNode;
import org.glowroot.agent.shaded.org.objectweb.asm.tree.ModuleProvideNode;
import org.glowroot.agent.shaded.org.objectweb.asm.tree.ModuleRequireNode;
import org.glowroot.agent.shaded.org.objectweb.asm.tree.Util;

public class ModuleNode
extends ModuleVisitor {
    public String name;
    public int access;
    public String version;
    public String mainClass;
    public List<String> packages;
    public List<ModuleRequireNode> requires;
    public List<ModuleExportNode> exports;
    public List<ModuleOpenNode> opens;
    public List<String> uses;
    public List<ModuleProvideNode> provides;

    public ModuleNode(String name, int access, String version) {
        super(458752);
        if (this.getClass() != ModuleNode.class) {
            throw new IllegalStateException();
        }
        this.name = name;
        this.access = access;
        this.version = version;
    }

    public void visitMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void visitPackage(String packaze) {
        if (this.packages == null) {
            this.packages = new ArrayList<String>(5);
        }
        this.packages.add(packaze);
    }

    public void visitRequire(String module, int access, String version) {
        if (this.requires == null) {
            this.requires = new ArrayList<ModuleRequireNode>(5);
        }
        this.requires.add(new ModuleRequireNode(module, access, version));
    }

    public void visitExport(String packaze, int access, String ... modules) {
        if (this.exports == null) {
            this.exports = new ArrayList<ModuleExportNode>(5);
        }
        this.exports.add(new ModuleExportNode(packaze, access, Util.asArrayList(modules)));
    }

    public void visitOpen(String packaze, int access, String ... modules) {
        if (this.opens == null) {
            this.opens = new ArrayList<ModuleOpenNode>(5);
        }
        this.opens.add(new ModuleOpenNode(packaze, access, Util.asArrayList(modules)));
    }

    public void visitUse(String service) {
        if (this.uses == null) {
            this.uses = new ArrayList<String>(5);
        }
        this.uses.add(service);
    }

    public void visitProvide(String service, String ... providers) {
        if (this.provides == null) {
            this.provides = new ArrayList<ModuleProvideNode>(5);
        }
        this.provides.add(new ModuleProvideNode(service, Util.asArrayList(providers)));
    }

    public void visitEnd() {
    }
}

