/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.util;

import java.util.ArrayList;
import javax.management.ObjectName;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.util.LazyPlatformMBeanServer;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LazyPlatformMBeanServer.ObjectNamePair", generator="Immutables")
@Immutable
final class ImmutableObjectNamePair
implements LazyPlatformMBeanServer.ObjectNamePair {
    private final Object object;
    private final ObjectName name;

    private ImmutableObjectNamePair(Object object, ObjectName name) {
        this.object = Preconditions.checkNotNull(object, "object");
        this.name = Preconditions.checkNotNull(name, "name");
    }

    private ImmutableObjectNamePair(ImmutableObjectNamePair original, Object object, ObjectName name) {
        this.object = object;
        this.name = name;
    }

    @Override
    @JsonProperty(value="object")
    public Object object() {
        return this.object;
    }

    @Override
    @JsonProperty(value="name")
    public ObjectName name() {
        return this.name;
    }

    public final ImmutableObjectNamePair withObject(Object value) {
        if (this.object == value) {
            return this;
        }
        Object newValue = Preconditions.checkNotNull(value, "object");
        return new ImmutableObjectNamePair(this, newValue, this.name);
    }

    public final ImmutableObjectNamePair withName(ObjectName value) {
        if (this.name == value) {
            return this;
        }
        ObjectName newValue = Preconditions.checkNotNull(value, "name");
        return new ImmutableObjectNamePair(this, this.object, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableObjectNamePair && this.equalTo((ImmutableObjectNamePair)another);
    }

    private boolean equalTo(ImmutableObjectNamePair another) {
        return this.object.equals(another.object) && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.object.hashCode();
        h += (h << 5) + this.name.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ObjectNamePair").omitNullValues().add("object", this.object).add("name", this.name).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableObjectNamePair fromJson(Json json) {
        Builder builder = ImmutableObjectNamePair.builder();
        if (json.object != null) {
            builder.object(json.object);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        return builder.build();
    }

    public static ImmutableObjectNamePair of(Object object, ObjectName name) {
        return new ImmutableObjectNamePair(object, name);
    }

    public static ImmutableObjectNamePair copyOf(LazyPlatformMBeanServer.ObjectNamePair instance) {
        if (instance instanceof ImmutableObjectNamePair) {
            return (ImmutableObjectNamePair)instance;
        }
        return ImmutableObjectNamePair.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LazyPlatformMBeanServer.ObjectNamePair", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OBJECT = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private Object object;
        @Nullable
        private ObjectName name;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(LazyPlatformMBeanServer.ObjectNamePair instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.object(instance.object());
            this.name(instance.name());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder object(Object object) {
            this.object = Preconditions.checkNotNull(object, "object");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(ObjectName name) {
            this.name = Preconditions.checkNotNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableObjectNamePair build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableObjectNamePair(null, this.object, this.name);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("object");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build ObjectNamePair, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LazyPlatformMBeanServer.ObjectNamePair", generator="Immutables")
    static final class Json
    implements LazyPlatformMBeanServer.ObjectNamePair {
        @Nullable
        Object object;
        @Nullable
        ObjectName name;

        Json() {
        }

        @JsonProperty(value="object")
        public void setObject(Object object) {
            this.object = object;
        }

        @JsonProperty(value="name")
        public void setName(ObjectName name) {
            this.name = name;
        }

        @Override
        public Object object() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectName name() {
            throw new UnsupportedOperationException();
        }
    }
}

