/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.util;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Stopwatch;
import org.glowroot.agent.shaded.com.google.common.cache.CacheBuilder;
import org.glowroot.agent.shaded.com.google.common.cache.CacheLoader;
import org.glowroot.agent.shaded.com.google.common.cache.LoadingCache;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.javax.annotation.concurrent.GuardedBy;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.ImmutableObjectNamePair;
import org.immutables.value.Value;

public class LazyPlatformMBeanServer {
    private static final Logger logger = LoggerFactory.getLogger(LazyPlatformMBeanServer.class);
    @GuardedBy(value="initListeners")
    private final List<InitListener> initListeners = Lists.newArrayList();
    private final boolean waitForContainerToCreatePlatformMBeanServer;
    private final boolean needsManualPatternMatching;
    private final List<ObjectNamePair> toBeRegistered = Lists.newCopyOnWriteArrayList();
    private final List<ObjectName> toBeUnregistered = Lists.newCopyOnWriteArrayList();
    @MonotonicNonNull
    private volatile MBeanServer platformMBeanServer;
    private final Object platformMBeanServerAvailability = new Object();
    @GuardedBy(value="platformMBeanServerAvailability")
    private boolean platformMBeanServerAvailable;
    private final LoadingCache<MBeanServer, MBeanServer> webSphereUnwrappedMBeanServers = CacheBuilder.newBuilder().weakKeys().weakValues().build(new CacheLoader<MBeanServer, MBeanServer>(){

        @Override
        public MBeanServer load(MBeanServer mbeanServer) {
            try {
                return (MBeanServer)Preconditions.checkNotNull(mbeanServer.getClass().getMethod("getDefaultMBeanServer", new Class[0]).invoke((Object)mbeanServer, new Object[0]));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
                return mbeanServer;
            }
        }
    });

    public static LazyPlatformMBeanServer create(@Nullable String mainClass) throws Exception {
        LazyPlatformMBeanServer lazyPlatformMBeanServer = new LazyPlatformMBeanServer(mainClass);
        if (!lazyPlatformMBeanServer.waitForContainerToCreatePlatformMBeanServer) {
            lazyPlatformMBeanServer.ensureInit();
        }
        return lazyPlatformMBeanServer;
    }

    private LazyPlatformMBeanServer(@Nullable String mainClass) {
        boolean jbossModules = "org.jboss.modules.Main".equals(mainClass);
        boolean wildflySwarm = "org.wildfly.swarm.bootstrap.Main".equals(mainClass);
        boolean oldJBoss = "org.jboss.Main".equals(mainClass);
        boolean glassfish = "com.sun.enterprise.glassfish.bootstrap.ASMain".equals(mainClass) || "com.sun.enterprise.server.PELaunch".equals(mainClass);
        boolean weblogic = "weblogic.Server".equals(mainClass);
        boolean websphere = "com.ibm.wsspi.bootstrap.WSPreLauncher".equals(mainClass);
        this.waitForContainerToCreatePlatformMBeanServer = jbossModules || wildflySwarm || oldJBoss || glassfish || weblogic || websphere;
        this.needsManualPatternMatching = oldJBoss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lazyRegisterMBean(Object object, String name) {
        ObjectName objectName;
        try {
            objectName = ObjectName.getInstance(name);
        }
        catch (MalformedObjectNameException e) {
            logger.warn(e.getMessage(), e);
            return;
        }
        List<InitListener> list = this.initListeners;
        synchronized (list) {
            if (this.platformMBeanServer == null) {
                this.toBeRegistered.add(ImmutableObjectNamePair.of(object, objectName));
                this.toBeUnregistered.add(objectName);
            } else {
                try {
                    LazyPlatformMBeanServer.safeRegisterMBean(this.platformMBeanServer, object, objectName);
                    this.toBeUnregistered.add(objectName);
                }
                catch (Throwable t) {
                    logger.warn(t.getMessage(), t);
                }
            }
        }
    }

    public Object invoke(ObjectName name, String operationName, @Nullable Object[] params, String[] signature) throws Exception {
        this.ensureInit();
        return this.platformMBeanServer.invoke(name, operationName, params, signature);
    }

    public Set<ObjectName> queryNames(@Nullable ObjectName name, @Nullable QueryExp query, List<MBeanServer> mbeanServers) throws Exception {
        this.ensureInit();
        if (this.needsManualPatternMatching && name != null && name.isPattern()) {
            return LazyPlatformMBeanServer.queryNamesAcrossAll(null, new ObjectNamePatternQueryExp(name), mbeanServers);
        }
        return LazyPlatformMBeanServer.queryNamesAcrossAll(name, query, mbeanServers);
    }

    public MBeanInfo getMBeanInfo(ObjectName name, List<MBeanServer> mbeanServers) throws Exception {
        this.ensureInit();
        return LazyPlatformMBeanServer.getMBeanInfoAcrossAll(name, mbeanServers);
    }

    public Object getAttribute(ObjectName name, String attribute, List<MBeanServer> mbeanServers) throws Exception {
        this.ensureInit();
        return LazyPlatformMBeanServer.getAttributeAcrossAll(name, attribute, mbeanServers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInitListener(InitListener initListener) {
        List<InitListener> list = this.initListeners;
        synchronized (list) {
            if (this.platformMBeanServer == null) {
                this.initListeners.add(initListener);
            } else {
                try {
                    initListener.postInit(this.platformMBeanServer);
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlatformMBeanServerAvailable() {
        Object object = this.platformMBeanServerAvailability;
        synchronized (object) {
            this.platformMBeanServerAvailable = true;
            this.platformMBeanServerAvailability.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnsuresNonNull(value={"platformMBeanServer"})
    private void ensureInit() throws Exception {
        if (this.platformMBeanServer != null) {
            return;
        }
        if (this.waitForContainerToCreatePlatformMBeanServer) {
            this.waitForContainerToCreatePlatformMBeanServer();
        }
        List<InitListener> list = this.initListeners;
        synchronized (list) {
            if (this.platformMBeanServer != null) {
                return;
            }
            this.platformMBeanServer = this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForContainerToCreatePlatformMBeanServer() throws Exception {
        Object object = this.platformMBeanServerAvailability;
        synchronized (object) {
            long remaining;
            if (this.platformMBeanServerAvailable) {
                return;
            }
            Stopwatch stopwatch = Stopwatch.createStarted();
            while (!this.platformMBeanServerAvailable && (remaining = TimeUnit.SECONDS.toMillis(60L) - stopwatch.elapsed(TimeUnit.MILLISECONDS)) >= 1000L) {
                this.platformMBeanServerAvailability.wait(remaining);
            }
            if (!this.platformMBeanServerAvailable) {
                logger.error("platform mbean server was never created by container");
            }
        }
    }

    private MBeanServer init() {
        MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        for (InitListener initListener : this.initListeners) {
            try {
                initListener.postInit(platformMBeanServer);
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
        }
        this.initListeners.clear();
        for (ObjectNamePair objectNamePair : this.toBeRegistered) {
            LazyPlatformMBeanServer.safeRegisterMBean(platformMBeanServer, objectNamePair.object(), objectNamePair.name());
        }
        this.toBeRegistered.clear();
        return platformMBeanServer;
    }

    @OnlyUsedByTests
    public void close() throws Exception {
        this.ensureInit();
        for (ObjectName name : this.toBeUnregistered) {
            this.platformMBeanServer.unregisterMBean(name);
        }
    }

    public List<MBeanServer> findAllMBeanServers() throws Exception {
        this.ensureInit();
        ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(null);
        ListIterator<MBeanServer> i = mbeanServers.listIterator();
        while (i.hasNext()) {
            MBeanServer mbeanServer = (MBeanServer)i.next();
            if (!mbeanServer.getClass().getName().equals("com.ibm.ws.management.PlatformMBeanServer")) continue;
            i.set(this.webSphereUnwrappedMBeanServers.get(mbeanServer));
        }
        return mbeanServers;
    }

    private static void safeRegisterMBean(MBeanServer mbeanServer, Object object, ObjectName name) {
        try {
            mbeanServer.registerMBean(object, name);
        }
        catch (InstanceAlreadyExistsException e) {
            logger.debug(e.getMessage(), e);
        }
        catch (NotCompliantMBeanException e) {
            StackTraceElement[] stackTraceElements = e.getStackTrace();
            if (stackTraceElements != null && stackTraceElements.length > 0 && stackTraceElements[0].getClassName().equals("org.jboss.mx.metadata.MBeanCapability")) {
                logger.debug(e.getMessage(), e);
            } else {
                logger.warn(e.getMessage(), e);
            }
        }
        catch (Throwable t) {
            logger.warn(t.getMessage(), t);
        }
    }

    private static Set<ObjectName> queryNamesAcrossAll(@Nullable ObjectName name, @Nullable QueryExp query, List<MBeanServer> mbeanServers) {
        HashSet<ObjectName> objects = Sets.newHashSet();
        for (MBeanServer mbeanServer : mbeanServers) {
            objects.addAll(mbeanServer.queryNames(name, query));
        }
        return objects;
    }

    private static MBeanInfo getMBeanInfoAcrossAll(ObjectName name, List<MBeanServer> mbeanServers) throws Exception {
        InstanceNotFoundException firstException = null;
        for (MBeanServer mbeanServer : mbeanServers) {
            try {
                return mbeanServer.getMBeanInfo(name);
            }
            catch (InstanceNotFoundException e) {
                logger.debug(e.getMessage(), e);
                if (firstException != null) continue;
                firstException = e;
            }
        }
        throw (InstanceNotFoundException)Preconditions.checkNotNull(firstException);
    }

    private static Object getAttributeAcrossAll(ObjectName name, String attribute, List<MBeanServer> mbeanServers) throws Exception {
        InstanceNotFoundException firstException = null;
        for (MBeanServer mbeanServer : mbeanServers) {
            try {
                return mbeanServer.getAttribute(name, attribute);
            }
            catch (InstanceNotFoundException e) {
                logger.debug(e.getMessage(), e);
                if (firstException != null) continue;
                firstException = e;
            }
        }
        throw (InstanceNotFoundException)Preconditions.checkNotNull(firstException);
    }

    private static class ObjectNamePatternQueryExp
    implements QueryExp {
        private final ObjectName pattern;

        private ObjectNamePatternQueryExp(ObjectName pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean apply(ObjectName name) {
            return this.pattern.apply(name);
        }

        @Override
        public void setMBeanServer(MBeanServer s) {
        }
    }

    @Value.Immutable
    @Styles.AllParameters
    static interface ObjectNamePair {
        public Object object();

        public ObjectName name();
    }

    public static interface InitListener {
        public void postInit(MBeanServer var1) throws Exception;
    }
}

