/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.glowroot.agent.impl.PreloadSomeSuperTypesCache;
import org.glowroot.agent.shaded.com.google.common.base.Charsets;
import org.glowroot.agent.shaded.com.google.common.base.Supplier;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.io.Resources;
import org.glowroot.agent.shaded.com.google.common.primitives.Bytes;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.config.InstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassReader;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.weaving.Advice;
import org.glowroot.agent.weaving.AdviceGenerator;
import org.glowroot.agent.weaving.AdviceMatcher;
import org.glowroot.agent.weaving.AnalyzedClass;
import org.glowroot.agent.weaving.AnalyzedMethod;
import org.glowroot.agent.weaving.ClassAnalyzer;
import org.glowroot.agent.weaving.ClassLoaders;
import org.glowroot.agent.weaving.ClassNames;
import org.glowroot.agent.weaving.ImmutableAnalyzedClass;
import org.glowroot.agent.weaving.ImmutableAnalyzedClassAndLoader;
import org.glowroot.agent.weaving.ImmutableAnalyzedMethod;
import org.glowroot.agent.weaving.ImmutablePublicFinalMethod;
import org.glowroot.agent.weaving.InstrumentationSeekerClassVisitor;
import org.glowroot.agent.weaving.MixinType;
import org.glowroot.agent.weaving.PublicFinalMethod;
import org.glowroot.agent.weaving.ShimType;
import org.glowroot.agent.weaving.ThinClassVisitor;
import org.immutables.value.Value;

public class AnalyzedWorld {
    private static final Logger logger = LoggerFactory.getLogger(AnalyzedWorld.class);
    private static final Method findLoadedClassMethod;
    private final Map<ClassLoader, ConcurrentMap<String, AnalyzedClass>> world = Collections.synchronizedMap(new WeakHashMap());
    private final ConcurrentMap<String, AnalyzedClass> bootstrapLoaderWorld = new ConcurrentHashMap<String, AnalyzedClass>();
    private final Supplier<List<Advice>> advisors;
    private final ImmutableList<ShimType> shimTypes;
    private final ImmutableList<MixinType> mixinTypes;
    @Nullable
    private final PreloadSomeSuperTypesCache preloadSomeSuperTypesCache;

    public AnalyzedWorld(Supplier<List<Advice>> advisors, List<ShimType> shimTypes, List<MixinType> mixinTypes, @Nullable PreloadSomeSuperTypesCache preloadSomeSuperTypesCache) {
        this.advisors = advisors;
        this.shimTypes = ImmutableList.copyOf(shimTypes);
        this.mixinTypes = ImmutableList.copyOf(mixinTypes);
        this.preloadSomeSuperTypesCache = preloadSomeSuperTypesCache;
    }

    public List<Class<?>> getClassesWithReweavableAdvice(boolean remove) {
        ArrayList<Class<?>> classes = Lists.newArrayList();
        for (ClassLoader loader : this.getClassLoaders()) {
            classes.addAll(this.getClassesWithReweavableAdvice(loader, remove));
        }
        classes.addAll(this.getClassesWithReweavableAdvice(null, remove));
        return classes;
    }

    public void removeClasses(Iterable<Class<?>> classes) {
        for (Map map : this.getWorldValues()) {
            for (Class<?> clazz : classes) {
                map.remove(clazz.getName());
            }
        }
        for (Class<?> clazz : classes) {
            this.bootstrapLoaderWorld.remove(clazz.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<ClassLoader> getClassLoaders() {
        Map<ClassLoader, ConcurrentMap<String, AnalyzedClass>> map = this.world;
        synchronized (map) {
            return ImmutableList.copyOf(this.world.keySet());
        }
    }

    void add(AnalyzedClass analyzedClass, @Nullable ClassLoader loader) {
        ConcurrentMap<String, AnalyzedClass> loaderAnalyzedClasses = this.getAnalyzedClasses(loader);
        loaderAnalyzedClasses.put(analyzedClass.name(), analyzedClass);
    }

    List<AnalyzedClass> getAnalyzedHierarchy(@Nullable String className, @Nullable ClassLoader loader, String subClassName, ParseContext parseContext) {
        if (className == null || className.equals("java.lang.Object")) {
            return ImmutableList.of();
        }
        return this.getSuperClasses(className, loader, subClassName, parseContext);
    }

    static List<Advice> mergeInstrumentationAnnotations(List<Advice> advisors, byte[] classBytes, @Nullable ClassLoader loader, String className) {
        byte[] marker = "Lorg/glowroot/agent/api/Instrumentation$".getBytes(Charsets.UTF_8);
        if (Bytes.indexOf(classBytes, marker) == -1) {
            return advisors;
        }
        InstrumentationSeekerClassVisitor cv = new InstrumentationSeekerClassVisitor();
        ClassReader cr = new ClassReader(classBytes);
        cr.accept(cv, 1);
        List<InstrumentationConfig> instrumentationConfigs = cv.getInstrumentationConfigs();
        if (instrumentationConfigs.isEmpty()) {
            return advisors;
        }
        if (loader == null) {
            logger.warn("@Instrumentation annotations not currently supported in bootstrap class loader: {}", (Object)className);
            return advisors;
        }
        for (InstrumentationConfig instrumentationConfig : instrumentationConfigs) {
            instrumentationConfig.logValidationErrorsIfAny();
        }
        ImmutableMap<Advice, ClassLoaders.LazyDefinedClass> newAdvisors = AdviceGenerator.createAdvisors(instrumentationConfigs, null, false, false);
        try {
            ClassLoaders.defineClasses(newAdvisors.values(), loader);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        ArrayList<Advice> mergedAdvisors = Lists.newArrayList(advisors);
        mergedAdvisors.addAll(newAdvisors.keySet());
        return mergedAdvisors;
    }

    private List<AnalyzedClass> getSuperClasses(String className, @Nullable ClassLoader loader, String subClassName, ParseContext parseContext) {
        AnalyzedClassAndLoader analyzedClassAndLoader;
        try {
            analyzedClassAndLoader = this.getOrCreateAnalyzedClass(className, loader, subClassName);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
            return ImmutableList.of();
        }
        catch (ClassNotFoundException e) {
            logger.debug("type {} not found while parsing type {}", className, parseContext, e);
            return ImmutableList.of();
        }
        ArrayList<AnalyzedClass> superTypes = Lists.newArrayList();
        AnalyzedClass analyzedClass = analyzedClassAndLoader.analyzedClass();
        ClassLoader analyzedClassLoader = analyzedClassAndLoader.analyzedClassLoader();
        superTypes.add(analyzedClass);
        String superName = analyzedClass.superName();
        if (superName != null && !superName.equals("java.lang.Object")) {
            superTypes.addAll(this.getSuperClasses(superName, analyzedClassLoader, className, parseContext));
        }
        for (String interfaceName : analyzedClass.interfaceNames()) {
            superTypes.addAll(this.getSuperClasses(interfaceName, analyzedClassLoader, className, parseContext));
        }
        return superTypes;
    }

    private AnalyzedClassAndLoader getOrCreateAnalyzedClass(String className, @Nullable ClassLoader loader, String subClassName) throws ClassNotFoundException, IOException {
        ConcurrentMap<String, AnalyzedClass> loaderAnalyzedClasses = this.getAnalyzedClasses(loader);
        AnalyzedClass analyzedClass = (AnalyzedClass)loaderAnalyzedClasses.get(className);
        if (analyzedClass != null) {
            return ImmutableAnalyzedClassAndLoader.of(analyzedClass, loader);
        }
        ClassLoader analyzedClassLoader = this.getAnalyzedLoader(className, loader, subClassName);
        loaderAnalyzedClasses = this.getAnalyzedClasses(analyzedClassLoader);
        analyzedClass = (AnalyzedClass)loaderAnalyzedClasses.get(className);
        if (analyzedClass == null) {
            if (analyzedClassLoader != null) {
                logger.debug("super class {} of {} not already analyzed, loader={}@{}", className, subClassName, analyzedClassLoader.getClass().getName(), analyzedClassLoader.hashCode());
            }
            analyzedClass = this.createAnalyzedClass(className, analyzedClassLoader);
            analyzedClass = AnalyzedWorld.putAnalyzedClass(loaderAnalyzedClasses, analyzedClass);
        }
        return ImmutableAnalyzedClassAndLoader.of(analyzedClass, analyzedClassLoader);
    }

    private List<Class<?>> getClassesWithReweavableAdvice(@Nullable ClassLoader loader, boolean remove) {
        ArrayList<Class<?>> classes = Lists.newArrayList();
        ConcurrentMap<String, AnalyzedClass> loaderAnalyzedClasses = this.getAnalyzedClasses(loader);
        for (Map.Entry entry : loaderAnalyzedClasses.entrySet()) {
            if (!((AnalyzedClass)entry.getValue()).hasReweavableAdvice()) continue;
            try {
                classes.add(Class.forName((String)entry.getKey(), false, loader));
            }
            catch (ClassNotFoundException e) {
                logger.warn(e.getMessage(), e);
            }
        }
        if (remove) {
            for (Class clazz : classes) {
                loaderAnalyzedClasses.remove(clazz.getName());
            }
        }
        return classes;
    }

    private AnalyzedClass createAnalyzedClass(String className, @Nullable ClassLoader loader) throws ClassNotFoundException, IOException {
        URL url;
        String path = ClassNames.toInternalName(className) + ".class";
        if (loader == null) {
            url = ClassLoader.getSystemResource(path);
        } else {
            AnalyzedClass parentLoaderAnalyzedClass;
            url = loader.getResource(path);
            if (url != null && (parentLoaderAnalyzedClass = this.tryToReuseFromParentLoader(className, loader, path, url)) != null) {
                return parentLoaderAnalyzedClass;
            }
        }
        if (url == null) {
            return this.createAnalyzedClassPlanB(className, loader);
        }
        byte[] bytes = Resources.toByteArray(url);
        List<Advice> advisors = AnalyzedWorld.mergeInstrumentationAnnotations(this.advisors.get(), bytes, loader, className);
        ThinClassVisitor accv = new ThinClassVisitor();
        new ClassReader(bytes).accept(accv, 5);
        ClassAnalyzer classAnalyzer = new ClassAnalyzer(accv.getThinClass(), advisors, this.shimTypes, this.mixinTypes, loader, this, null, bytes, null, true);
        classAnalyzer.analyzeMethods();
        return classAnalyzer.getAnalyzedClass();
    }

    @Nullable
    private AnalyzedClass tryToReuseFromParentLoader(String className, ClassLoader originalLoader, String path, URL url) {
        ClassLoader loader = originalLoader;
        while (loader != null) {
            AnalyzedClass parentLoaderAnalyzedClass;
            ClassLoader parentLoader = loader.getParent();
            URL parentLoaderUrl = parentLoader == null ? ClassLoader.getSystemResource(path) : parentLoader.getResource(path);
            if (parentLoaderUrl != null && parentLoaderUrl.toExternalForm().equals(url.toExternalForm()) && (parentLoaderAnalyzedClass = (AnalyzedClass)this.getAnalyzedClasses(parentLoader).get(className)) != null) {
                return parentLoaderAnalyzedClass;
            }
            loader = parentLoader;
        }
        return null;
    }

    private AnalyzedClass createAnalyzedClassPlanB(String className, @Nullable ClassLoader loader) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(className, false, loader);
        AnalyzedClass analyzedClass = (AnalyzedClass)this.getAnalyzedClasses(clazz.getClassLoader()).get(className);
        if (analyzedClass != null) {
            return analyzedClass;
        }
        analyzedClass = AnalyzedWorld.createAnalyzedClassPlanC(clazz, this.advisors.get());
        if (analyzedClass.isInterface()) {
            return analyzedClass;
        }
        if (!analyzedClass.analyzedMethods().isEmpty()) {
            logger.warn("{} was not woven with requested advice (it was first encountered during the weaving of one of its {} and the resource {}.class could not be found in class loader {}, so {} had to be explicitly loaded using Class.forName() in the middle of weaving the {}, which means it was not woven itself since weaving is not re-entrant)", clazz.getName(), analyzedClass.isInterface() ? "implementations" : "subclasses", ClassNames.toInternalName(clazz.getName()), loader, clazz.getName(), analyzedClass.isInterface() ? "implementation" : "subclass");
        }
        return analyzedClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<String, AnalyzedClass> getAnalyzedClasses(@Nullable ClassLoader loader) {
        if (loader == null) {
            return this.bootstrapLoaderWorld;
        }
        Map<ClassLoader, ConcurrentMap<String, AnalyzedClass>> map = this.world;
        synchronized (map) {
            ConcurrentMap<String, AnalyzedClass> map2 = this.world.get(loader);
            if (map2 == null) {
                map2 = new ConcurrentHashMap<String, AnalyzedClass>();
                this.world.put(loader, map2);
            }
            return map2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImmutableList<ConcurrentMap<String, AnalyzedClass>> getWorldValues() {
        Map<ClassLoader, ConcurrentMap<String, AnalyzedClass>> map = this.world;
        synchronized (map) {
            return ImmutableList.copyOf(this.world.values());
        }
    }

    private static AnalyzedClass putAnalyzedClass(ConcurrentMap<String, AnalyzedClass> loaderAnalyzedClasses, AnalyzedClass analyzedClass) {
        AnalyzedClass existingAnalyzedClass = loaderAnalyzedClasses.putIfAbsent(analyzedClass.name(), analyzedClass);
        if (existingAnalyzedClass != null) {
            return existingAnalyzedClass;
        }
        return analyzedClass;
    }

    @Nullable
    private ClassLoader getAnalyzedLoader(String className, @Nullable ClassLoader loader, String subClassName) {
        if (loader == null) {
            return null;
        }
        Class clazz = null;
        try {
            clazz = (Class)findLoadedClassMethod.invoke((Object)loader, className);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        if (clazz == null) {
            logger.debug("super class {} of {} not found in loader {}@{}", className, subClassName, loader.getClass().getName(), loader.hashCode());
            if (this.preloadSomeSuperTypesCache != null) {
                this.preloadSomeSuperTypesCache.put(subClassName, className);
            }
            return loader;
        }
        return clazz.getClassLoader();
    }

    private static AnalyzedClass createAnalyzedClassPlanC(Class<?> clazz, List<Advice> advisors) {
        ImmutableAnalyzedClass.Builder classBuilder = ImmutableAnalyzedClass.builder();
        classBuilder.modifiers(clazz.getModifiers());
        classBuilder.name(clazz.getName());
        Class<?> superClass = clazz.getSuperclass();
        String superName = superClass == null ? null : superClass.getName();
        classBuilder.superName(superName);
        ArrayList<String> superClassNames = Lists.newArrayList();
        if (superName != null) {
            superClassNames.add(superName);
        }
        for (Class<?> interfaceClass : clazz.getInterfaces()) {
            String interfaceClassName = interfaceClass.getName();
            classBuilder.addInterfaceNames(interfaceClassName);
            superClassNames.add(interfaceClassName);
        }
        ArrayList<String> classAnnotations = Lists.newArrayList();
        for (Annotation annotation : clazz.getAnnotations()) {
            classAnnotations.add(annotation.annotationType().getName());
        }
        ImmutableList<AdviceMatcher> adviceMatchers = AdviceMatcher.getAdviceMatchers(clazz.getName(), classAnnotations, superClassNames, advisors);
        HashMap<Method, Object> bridgeTargetAdvisors = Maps.newHashMap();
        for (Method method : clazz.getDeclaredMethods()) {
            Method targetMethod;
            if (!method.isBridge()) continue;
            ArrayList<String> methodAnnotations = Lists.newArrayList();
            for (Annotation annotation : method.getAnnotations()) {
                methodAnnotations.add(annotation.annotationType().getName());
            }
            ArrayList<Type> parameterTypes = Lists.newArrayList();
            for (Class<?> parameterType : method.getParameterTypes()) {
                parameterTypes.add(Type.getType(parameterType));
            }
            Type returnType = Type.getType(method.getReturnType());
            List<Advice> matchingAdvisors = AnalyzedWorld.getMatchingAdvisors(method.getModifiers(), method.getName(), methodAnnotations, parameterTypes, returnType, adviceMatchers);
            if (matchingAdvisors.isEmpty() || (targetMethod = AnalyzedWorld.getTargetMethod(method, clazz)) == null) continue;
            bridgeTargetAdvisors.put(targetMethod, matchingAdvisors);
        }
        boolean intf = clazz.isInterface();
        for (Method method : clazz.getDeclaredMethods()) {
            boolean intfMethod;
            if (method.isSynthetic()) continue;
            int modifiers = method.getModifiers();
            ArrayList<String> methodAnnotations = Lists.newArrayList();
            for (Annotation annotation : method.getAnnotations()) {
                methodAnnotations.add(annotation.annotationType().getName());
            }
            ArrayList<Type> parameterTypes = Lists.newArrayList();
            for (Class<?> parameterType : method.getParameterTypes()) {
                parameterTypes.add(Type.getType(parameterType));
            }
            Type returnType = Type.getType(method.getReturnType());
            List<Advice> matchingAdvisors = AnalyzedWorld.getMatchingAdvisors(modifiers, method.getName(), methodAnnotations, parameterTypes, returnType, adviceMatchers);
            List extraAdvisors = (List)bridgeTargetAdvisors.get(method);
            if (extraAdvisors != null) {
                matchingAdvisors.addAll(extraAdvisors);
            }
            ClassAnalyzer.sortAdvisors(matchingAdvisors);
            boolean bl = intfMethod = intf && !Modifier.isStatic(modifiers);
            if (!matchingAdvisors.isEmpty() || intfMethod) {
                ImmutableAnalyzedMethod.Builder methodBuilder = ImmutableAnalyzedMethod.builder();
                methodBuilder.name(method.getName());
                for (Type parameterType : parameterTypes) {
                    methodBuilder.addParameterTypes(parameterType.getClassName());
                }
                methodBuilder.returnType(returnType.getClassName());
                methodBuilder.modifiers(modifiers);
                for (Class<?> exceptionType : method.getExceptionTypes()) {
                    methodBuilder.addExceptions(exceptionType.getName());
                }
                methodBuilder.addAllAdvisors(matchingAdvisors);
                classBuilder.addAnalyzedMethods((AnalyzedMethod)methodBuilder.build());
            }
            if (!Modifier.isFinal(modifiers) || !Modifier.isPublic(modifiers)) continue;
            ImmutablePublicFinalMethod.Builder publicFinalMethodBuilder = ImmutablePublicFinalMethod.builder().name(method.getName());
            for (Type parameterType : parameterTypes) {
                publicFinalMethodBuilder.addParameterTypes(parameterType.getClassName());
            }
            classBuilder.addPublicFinalMethods((PublicFinalMethod)publicFinalMethodBuilder.build());
        }
        boolean ejbRemote = false;
        for (Annotation annotation : clazz.getDeclaredAnnotations()) {
            if (!annotation.annotationType().getName().equals("javax.ejb.Remote")) continue;
            ejbRemote = true;
            break;
        }
        return classBuilder.ejbRemote(ejbRemote).build();
    }

    @Nullable
    private static Method getTargetMethod(Method bridgeMethod, Class<?> clazz) {
        List<Method> possibleTargetMethods = AnalyzedWorld.getPossibleTargetMethods(bridgeMethod, clazz);
        if (possibleTargetMethods.isEmpty()) {
            logger.warn("could not find any target for bridge method: {}", (Object)bridgeMethod);
        }
        if (possibleTargetMethods.size() == 1) {
            return possibleTargetMethods.get(0);
        }
        logger.warn("found more than one possible target for bridge method: {}", (Object)bridgeMethod);
        return null;
    }

    private static List<Method> getPossibleTargetMethods(Method bridgeMethod, Class<?> clazz) {
        ArrayList<Method> possibleTargetMethods = Lists.newArrayList();
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(bridgeMethod.getName()) || method.getParameterTypes().length != bridgeMethod.getParameterTypes().length) continue;
            possibleTargetMethods.add(method);
        }
        return possibleTargetMethods;
    }

    private static List<Advice> getMatchingAdvisors(int access, String name, List<String> methodAnnotations, List<Type> parameterTypes, Type returnType, List<AdviceMatcher> adviceMatchers) {
        ArrayList<Advice> matchingAdvisors = Lists.newArrayList();
        for (AdviceMatcher adviceMatcher : adviceMatchers) {
            if (!adviceMatcher.isMethodLevelMatch(name, methodAnnotations, parameterTypes, returnType, access)) continue;
            matchingAdvisors.add(adviceMatcher.advice());
        }
        return matchingAdvisors;
    }

    static {
        try {
            findLoadedClassMethod = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            findLoadedClassMethod.setAccessible(true);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    @Value.Immutable
    @Styles.AllParameters
    static abstract class ParseContext {
        ParseContext() {
        }

        abstract String className();

        @Nullable
        abstract CodeSource codeSource();

        public String toString() {
            CodeSource codeSource = this.codeSource();
            if (codeSource == null) {
                return this.className();
            }
            return this.className() + " (" + codeSource.getLocation() + ")";
        }
    }

    @Styles.AllParameters
    @Value.Immutable
    static interface AnalyzedClassAndLoader {
        public AnalyzedClass analyzedClass();

        @Nullable
        public ClassLoader analyzedClassLoader();
    }
}

