/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.util.ArrayList;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Objects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.weaving.AnalyzedClass;
import org.glowroot.agent.weaving.AnalyzedMethod;
import org.glowroot.agent.weaving.MixinType;
import org.glowroot.agent.weaving.PublicFinalMethod;
import org.glowroot.agent.weaving.ShimType;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AnalyzedClass", generator="Immutables")
@Immutable
final class ImmutableAnalyzedClass
extends AnalyzedClass {
    private final int modifiers;
    private final String name;
    @Nullable
    private final String superName;
    private final ImmutableList<String> interfaceNames;
    private final ImmutableList<AnalyzedMethod> analyzedMethods;
    private final ImmutableList<PublicFinalMethod> publicFinalMethods;
    private final ImmutableList<ShimType> shimTypes;
    private final ImmutableList<MixinType> mixinTypes;
    private final ImmutableList<MixinType> nonReweavableMixinTypes;
    private final boolean ejbRemote;

    private ImmutableAnalyzedClass(int modifiers, String name, @Nullable String superName, ImmutableList<String> interfaceNames, ImmutableList<AnalyzedMethod> analyzedMethods, ImmutableList<PublicFinalMethod> publicFinalMethods, ImmutableList<ShimType> shimTypes, ImmutableList<MixinType> mixinTypes, ImmutableList<MixinType> nonReweavableMixinTypes, boolean ejbRemote) {
        this.modifiers = modifiers;
        this.name = name;
        this.superName = superName;
        this.interfaceNames = interfaceNames;
        this.analyzedMethods = analyzedMethods;
        this.publicFinalMethods = publicFinalMethods;
        this.shimTypes = shimTypes;
        this.mixinTypes = mixinTypes;
        this.nonReweavableMixinTypes = nonReweavableMixinTypes;
        this.ejbRemote = ejbRemote;
    }

    @Override
    @JsonProperty(value="modifiers")
    int modifiers() {
        return this.modifiers;
    }

    @Override
    @JsonProperty(value="name")
    String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="superName")
    @Nullable
    String superName() {
        return this.superName;
    }

    @Override
    @JsonProperty(value="interfaceNames")
    ImmutableList<String> interfaceNames() {
        return this.interfaceNames;
    }

    @Override
    @JsonProperty(value="analyzedMethods")
    ImmutableList<AnalyzedMethod> analyzedMethods() {
        return this.analyzedMethods;
    }

    @Override
    @JsonProperty(value="publicFinalMethods")
    ImmutableList<PublicFinalMethod> publicFinalMethods() {
        return this.publicFinalMethods;
    }

    @Override
    @JsonProperty(value="shimTypes")
    ImmutableList<ShimType> shimTypes() {
        return this.shimTypes;
    }

    @Override
    @JsonProperty(value="mixinTypes")
    ImmutableList<MixinType> mixinTypes() {
        return this.mixinTypes;
    }

    @Override
    @JsonProperty(value="nonReweavableMixinTypes")
    ImmutableList<MixinType> nonReweavableMixinTypes() {
        return this.nonReweavableMixinTypes;
    }

    @Override
    @JsonProperty(value="ejbRemote")
    boolean ejbRemote() {
        return this.ejbRemote;
    }

    public final ImmutableAnalyzedClass withModifiers(int value) {
        if (this.modifiers == value) {
            return this;
        }
        return new ImmutableAnalyzedClass(value, this.name, this.superName, this.interfaceNames, this.analyzedMethods, this.publicFinalMethods, this.shimTypes, this.mixinTypes, this.nonReweavableMixinTypes, this.ejbRemote);
    }

    public final ImmutableAnalyzedClass withName(String value) {
        String newValue = Preconditions.checkNotNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableAnalyzedClass(this.modifiers, newValue, this.superName, this.interfaceNames, this.analyzedMethods, this.publicFinalMethods, this.shimTypes, this.mixinTypes, this.nonReweavableMixinTypes, this.ejbRemote);
    }

    public final ImmutableAnalyzedClass withSuperName(@Nullable String value) {
        if (Objects.equal(this.superName, value)) {
            return this;
        }
        return new ImmutableAnalyzedClass(this.modifiers, this.name, value, this.interfaceNames, this.analyzedMethods, this.publicFinalMethods, this.shimTypes, this.mixinTypes, this.nonReweavableMixinTypes, this.ejbRemote);
    }

    public final ImmutableAnalyzedClass withInterfaceNames(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedClass(this.modifiers, this.name, this.superName, newValue, this.analyzedMethods, this.publicFinalMethods, this.shimTypes, this.mixinTypes, this.nonReweavableMixinTypes, this.ejbRemote);
    }

    public final ImmutableAnalyzedClass withInterfaceNames(Iterable<String> elements) {
        if (this.interfaceNames == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedClass(this.modifiers, this.name, this.superName, newValue, this.analyzedMethods, this.publicFinalMethods, this.shimTypes, this.mixinTypes, this.nonReweavableMixinTypes, this.ejbRemote);
    }

    public final ImmutableAnalyzedClass withAnalyzedMethods(AnalyzedMethod ... elements) {
        ImmutableList<AnalyzedMethod> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedClass(this.modifiers, this.name, this.superName, this.interfaceNames, newValue, this.publicFinalMethods, this.shimTypes, this.mixinTypes, this.nonReweavableMixinTypes, this.ejbRemote);
    }

    public final ImmutableAnalyzedClass withAnalyzedMethods(Iterable<? extends AnalyzedMethod> elements) {
        if (this.analyzedMethods == elements) {
            return this;
        }
        ImmutableList<AnalyzedMethod> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedClass(this.modifiers, this.name, this.superName, this.interfaceNames, newValue, this.publicFinalMethods, this.shimTypes, this.mixinTypes, this.nonReweavableMixinTypes, this.ejbRemote);
    }

    public final ImmutableAnalyzedClass withPublicFinalMethods(PublicFinalMethod ... elements) {
        ImmutableList<PublicFinalMethod> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedClass(this.modifiers, this.name, this.superName, this.interfaceNames, this.analyzedMethods, newValue, this.shimTypes, this.mixinTypes, this.nonReweavableMixinTypes, this.ejbRemote);
    }

    public final ImmutableAnalyzedClass withPublicFinalMethods(Iterable<? extends PublicFinalMethod> elements) {
        if (this.publicFinalMethods == elements) {
            return this;
        }
        ImmutableList<PublicFinalMethod> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedClass(this.modifiers, this.name, this.superName, this.interfaceNames, this.analyzedMethods, newValue, this.shimTypes, this.mixinTypes, this.nonReweavableMixinTypes, this.ejbRemote);
    }

    public final ImmutableAnalyzedClass withShimTypes(ShimType ... elements) {
        ImmutableList<ShimType> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedClass(this.modifiers, this.name, this.superName, this.interfaceNames, this.analyzedMethods, this.publicFinalMethods, newValue, this.mixinTypes, this.nonReweavableMixinTypes, this.ejbRemote);
    }

    public final ImmutableAnalyzedClass withShimTypes(Iterable<? extends ShimType> elements) {
        if (this.shimTypes == elements) {
            return this;
        }
        ImmutableList<ShimType> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedClass(this.modifiers, this.name, this.superName, this.interfaceNames, this.analyzedMethods, this.publicFinalMethods, newValue, this.mixinTypes, this.nonReweavableMixinTypes, this.ejbRemote);
    }

    public final ImmutableAnalyzedClass withMixinTypes(MixinType ... elements) {
        ImmutableList<MixinType> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedClass(this.modifiers, this.name, this.superName, this.interfaceNames, this.analyzedMethods, this.publicFinalMethods, this.shimTypes, newValue, this.nonReweavableMixinTypes, this.ejbRemote);
    }

    public final ImmutableAnalyzedClass withMixinTypes(Iterable<? extends MixinType> elements) {
        if (this.mixinTypes == elements) {
            return this;
        }
        ImmutableList<MixinType> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedClass(this.modifiers, this.name, this.superName, this.interfaceNames, this.analyzedMethods, this.publicFinalMethods, this.shimTypes, newValue, this.nonReweavableMixinTypes, this.ejbRemote);
    }

    public final ImmutableAnalyzedClass withNonReweavableMixinTypes(MixinType ... elements) {
        ImmutableList<MixinType> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedClass(this.modifiers, this.name, this.superName, this.interfaceNames, this.analyzedMethods, this.publicFinalMethods, this.shimTypes, this.mixinTypes, newValue, this.ejbRemote);
    }

    public final ImmutableAnalyzedClass withNonReweavableMixinTypes(Iterable<? extends MixinType> elements) {
        if (this.nonReweavableMixinTypes == elements) {
            return this;
        }
        ImmutableList<MixinType> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedClass(this.modifiers, this.name, this.superName, this.interfaceNames, this.analyzedMethods, this.publicFinalMethods, this.shimTypes, this.mixinTypes, newValue, this.ejbRemote);
    }

    public final ImmutableAnalyzedClass withEjbRemote(boolean value) {
        if (this.ejbRemote == value) {
            return this;
        }
        return new ImmutableAnalyzedClass(this.modifiers, this.name, this.superName, this.interfaceNames, this.analyzedMethods, this.publicFinalMethods, this.shimTypes, this.mixinTypes, this.nonReweavableMixinTypes, value);
    }

    public boolean equals(@org.glowroot.agent.shaded.javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAnalyzedClass && this.equalTo((ImmutableAnalyzedClass)another);
    }

    private boolean equalTo(ImmutableAnalyzedClass another) {
        return this.modifiers == another.modifiers && this.name.equals(another.name) && Objects.equal(this.superName, another.superName) && this.interfaceNames.equals(another.interfaceNames) && this.analyzedMethods.equals(another.analyzedMethods) && this.publicFinalMethods.equals(another.publicFinalMethods) && this.shimTypes.equals(another.shimTypes) && this.mixinTypes.equals(another.mixinTypes) && this.nonReweavableMixinTypes.equals(another.nonReweavableMixinTypes) && this.ejbRemote == another.ejbRemote;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.modifiers;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.superName);
        h += (h << 5) + this.interfaceNames.hashCode();
        h += (h << 5) + this.analyzedMethods.hashCode();
        h += (h << 5) + this.publicFinalMethods.hashCode();
        h += (h << 5) + this.shimTypes.hashCode();
        h += (h << 5) + this.mixinTypes.hashCode();
        h += (h << 5) + this.nonReweavableMixinTypes.hashCode();
        h += (h << 5) + Booleans.hashCode(this.ejbRemote);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("AnalyzedClass").omitNullValues().add("modifiers", this.modifiers).add("name", this.name).add("superName", this.superName).add("interfaceNames", this.interfaceNames).add("analyzedMethods", this.analyzedMethods).add("publicFinalMethods", this.publicFinalMethods).add("shimTypes", this.shimTypes).add("mixinTypes", this.mixinTypes).add("nonReweavableMixinTypes", this.nonReweavableMixinTypes).add("ejbRemote", this.ejbRemote).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAnalyzedClass fromJson(Json json) {
        Builder builder = ImmutableAnalyzedClass.builder();
        if (json.modifiersIsSet) {
            builder.modifiers(json.modifiers);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.superName != null) {
            builder.superName(json.superName);
        }
        if (json.interfaceNames != null) {
            builder.addAllInterfaceNames(json.interfaceNames);
        }
        if (json.analyzedMethods != null) {
            builder.addAllAnalyzedMethods(json.analyzedMethods);
        }
        if (json.publicFinalMethods != null) {
            builder.addAllPublicFinalMethods(json.publicFinalMethods);
        }
        if (json.shimTypes != null) {
            builder.addAllShimTypes(json.shimTypes);
        }
        if (json.mixinTypes != null) {
            builder.addAllMixinTypes(json.mixinTypes);
        }
        if (json.nonReweavableMixinTypes != null) {
            builder.addAllNonReweavableMixinTypes(json.nonReweavableMixinTypes);
        }
        if (json.ejbRemoteIsSet) {
            builder.ejbRemote(json.ejbRemote);
        }
        return builder.build();
    }

    public static ImmutableAnalyzedClass copyOf(AnalyzedClass instance) {
        if (instance instanceof ImmutableAnalyzedClass) {
            return (ImmutableAnalyzedClass)instance;
        }
        return ImmutableAnalyzedClass.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AnalyzedClass", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MODIFIERS = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_EJB_REMOTE = 4L;
        private long initBits = 7L;
        private int modifiers;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        private String name;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        private String superName;
        private ImmutableList.Builder<String> interfaceNames = ImmutableList.builder();
        private ImmutableList.Builder<AnalyzedMethod> analyzedMethods = ImmutableList.builder();
        private ImmutableList.Builder<PublicFinalMethod> publicFinalMethods = ImmutableList.builder();
        private ImmutableList.Builder<ShimType> shimTypes = ImmutableList.builder();
        private ImmutableList.Builder<MixinType> mixinTypes = ImmutableList.builder();
        private ImmutableList.Builder<MixinType> nonReweavableMixinTypes = ImmutableList.builder();
        private boolean ejbRemote;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(AnalyzedClass instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.modifiers(instance.modifiers());
            this.name(instance.name());
            String superNameValue = instance.superName();
            if (superNameValue != null) {
                this.superName(superNameValue);
            }
            this.addAllInterfaceNames(instance.interfaceNames());
            this.addAllAnalyzedMethods(instance.analyzedMethods());
            this.addAllPublicFinalMethods(instance.publicFinalMethods());
            this.addAllShimTypes(instance.shimTypes());
            this.addAllMixinTypes(instance.mixinTypes());
            this.addAllNonReweavableMixinTypes(instance.nonReweavableMixinTypes());
            this.ejbRemote(instance.ejbRemote());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder modifiers(int modifiers) {
            this.modifiers = modifiers;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder superName(@Nullable String superName) {
            this.superName = superName;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInterfaceNames(String element) {
            this.interfaceNames.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInterfaceNames(String ... elements) {
            this.interfaceNames.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder interfaceNames(Iterable<String> elements) {
            this.interfaceNames = ImmutableList.builder();
            return this.addAllInterfaceNames(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllInterfaceNames(Iterable<String> elements) {
            this.interfaceNames.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAnalyzedMethods(AnalyzedMethod element) {
            this.analyzedMethods.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAnalyzedMethods(AnalyzedMethod ... elements) {
            this.analyzedMethods.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder analyzedMethods(Iterable<? extends AnalyzedMethod> elements) {
            this.analyzedMethods = ImmutableList.builder();
            return this.addAllAnalyzedMethods(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAnalyzedMethods(Iterable<? extends AnalyzedMethod> elements) {
            this.analyzedMethods.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPublicFinalMethods(PublicFinalMethod element) {
            this.publicFinalMethods.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPublicFinalMethods(PublicFinalMethod ... elements) {
            this.publicFinalMethods.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder publicFinalMethods(Iterable<? extends PublicFinalMethod> elements) {
            this.publicFinalMethods = ImmutableList.builder();
            return this.addAllPublicFinalMethods(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPublicFinalMethods(Iterable<? extends PublicFinalMethod> elements) {
            this.publicFinalMethods.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addShimTypes(ShimType element) {
            this.shimTypes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addShimTypes(ShimType ... elements) {
            this.shimTypes.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder shimTypes(Iterable<? extends ShimType> elements) {
            this.shimTypes = ImmutableList.builder();
            return this.addAllShimTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllShimTypes(Iterable<? extends ShimType> elements) {
            this.shimTypes.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMixinTypes(MixinType element) {
            this.mixinTypes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMixinTypes(MixinType ... elements) {
            this.mixinTypes.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mixinTypes(Iterable<? extends MixinType> elements) {
            this.mixinTypes = ImmutableList.builder();
            return this.addAllMixinTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMixinTypes(Iterable<? extends MixinType> elements) {
            this.mixinTypes.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNonReweavableMixinTypes(MixinType element) {
            this.nonReweavableMixinTypes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNonReweavableMixinTypes(MixinType ... elements) {
            this.nonReweavableMixinTypes.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nonReweavableMixinTypes(Iterable<? extends MixinType> elements) {
            this.nonReweavableMixinTypes = ImmutableList.builder();
            return this.addAllNonReweavableMixinTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNonReweavableMixinTypes(Iterable<? extends MixinType> elements) {
            this.nonReweavableMixinTypes.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ejbRemote(boolean ejbRemote) {
            this.ejbRemote = ejbRemote;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableAnalyzedClass build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAnalyzedClass(this.modifiers, this.name, this.superName, (ImmutableList)this.interfaceNames.build(), (ImmutableList)this.analyzedMethods.build(), (ImmutableList)this.publicFinalMethods.build(), (ImmutableList)this.shimTypes.build(), (ImmutableList)this.mixinTypes.build(), (ImmutableList)this.nonReweavableMixinTypes.build(), this.ejbRemote);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("modifiers");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("ejbRemote");
            }
            return "Cannot build AnalyzedClass, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AnalyzedClass", generator="Immutables")
    static final class Json
    extends AnalyzedClass {
        int modifiers;
        boolean modifiersIsSet;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        String name;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        String superName;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        ImmutableList<String> interfaceNames = ImmutableList.of();
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        ImmutableList<AnalyzedMethod> analyzedMethods = ImmutableList.of();
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        ImmutableList<PublicFinalMethod> publicFinalMethods = ImmutableList.of();
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        ImmutableList<ShimType> shimTypes = ImmutableList.of();
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        ImmutableList<MixinType> mixinTypes = ImmutableList.of();
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        ImmutableList<MixinType> nonReweavableMixinTypes = ImmutableList.of();
        boolean ejbRemote;
        boolean ejbRemoteIsSet;

        Json() {
        }

        @JsonProperty(value="modifiers")
        public void setModifiers(int modifiers) {
            this.modifiers = modifiers;
            this.modifiersIsSet = true;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="superName")
        public void setSuperName(@Nullable String superName) {
            this.superName = superName;
        }

        @JsonProperty(value="interfaceNames")
        public void setInterfaceNames(ImmutableList<String> interfaceNames) {
            this.interfaceNames = interfaceNames;
        }

        @JsonProperty(value="analyzedMethods")
        public void setAnalyzedMethods(ImmutableList<AnalyzedMethod> analyzedMethods) {
            this.analyzedMethods = analyzedMethods;
        }

        @JsonProperty(value="publicFinalMethods")
        public void setPublicFinalMethods(ImmutableList<PublicFinalMethod> publicFinalMethods) {
            this.publicFinalMethods = publicFinalMethods;
        }

        @JsonProperty(value="shimTypes")
        public void setShimTypes(ImmutableList<ShimType> shimTypes) {
            this.shimTypes = shimTypes;
        }

        @JsonProperty(value="mixinTypes")
        public void setMixinTypes(ImmutableList<MixinType> mixinTypes) {
            this.mixinTypes = mixinTypes;
        }

        @JsonProperty(value="nonReweavableMixinTypes")
        public void setNonReweavableMixinTypes(ImmutableList<MixinType> nonReweavableMixinTypes) {
            this.nonReweavableMixinTypes = nonReweavableMixinTypes;
        }

        @JsonProperty(value="ejbRemote")
        public void setEjbRemote(boolean ejbRemote) {
            this.ejbRemote = ejbRemote;
            this.ejbRemoteIsSet = true;
        }

        @Override
        int modifiers() {
            throw new UnsupportedOperationException();
        }

        @Override
        String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        String superName() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<String> interfaceNames() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<AnalyzedMethod> analyzedMethods() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<PublicFinalMethod> publicFinalMethods() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<ShimType> shimTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<MixinType> mixinTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<MixinType> nonReweavableMixinTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean ejbRemote() {
            throw new UnsupportedOperationException();
        }
    }
}

