/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Objects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.weaving.PluginDetail;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PluginDetail.PointcutClass", generator="Immutables")
@Immutable
public final class ImmutablePointcutClass
extends PluginDetail.PointcutClass {
    private final Type type;
    private final Pointcut pointcut;
    private final ImmutableList<PluginDetail.PointcutMethod> methods;
    private final byte[] bytes;
    private final boolean collocateInClassLoader;
    @Nullable
    private final File pluginJar;

    private ImmutablePointcutClass(Type type, Pointcut pointcut, ImmutableList<PluginDetail.PointcutMethod> methods, byte[] bytes, boolean collocateInClassLoader, @Nullable File pluginJar) {
        this.type = type;
        this.pointcut = pointcut;
        this.methods = methods;
        this.bytes = bytes;
        this.collocateInClassLoader = collocateInClassLoader;
        this.pluginJar = pluginJar;
    }

    @Override
    @JsonProperty(value="type")
    Type type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="pointcut")
    Pointcut pointcut() {
        return this.pointcut;
    }

    @JsonProperty(value="methods")
    ImmutableList<PluginDetail.PointcutMethod> methods() {
        return this.methods;
    }

    @Override
    @JsonProperty(value="bytes")
    byte[] bytes() {
        return (byte[])this.bytes.clone();
    }

    @Override
    @JsonProperty(value="collocateInClassLoader")
    boolean collocateInClassLoader() {
        return this.collocateInClassLoader;
    }

    @Override
    @JsonProperty(value="pluginJar")
    @Nullable
    File pluginJar() {
        return this.pluginJar;
    }

    public final ImmutablePointcutClass withType(Type value) {
        if (this.type == value) {
            return this;
        }
        Type newValue = Preconditions.checkNotNull(value, "type");
        return new ImmutablePointcutClass(newValue, this.pointcut, this.methods, this.bytes, this.collocateInClassLoader, this.pluginJar);
    }

    public final ImmutablePointcutClass withPointcut(Pointcut value) {
        if (this.pointcut == value) {
            return this;
        }
        Pointcut newValue = Preconditions.checkNotNull(value, "pointcut");
        return new ImmutablePointcutClass(this.type, newValue, this.methods, this.bytes, this.collocateInClassLoader, this.pluginJar);
    }

    public final ImmutablePointcutClass withMethods(PluginDetail.PointcutMethod ... elements) {
        ImmutableList<PluginDetail.PointcutMethod> newValue = ImmutableList.copyOf(elements);
        return new ImmutablePointcutClass(this.type, this.pointcut, newValue, this.bytes, this.collocateInClassLoader, this.pluginJar);
    }

    public final ImmutablePointcutClass withMethods(Iterable<? extends PluginDetail.PointcutMethod> elements) {
        if (this.methods == elements) {
            return this;
        }
        ImmutableList<PluginDetail.PointcutMethod> newValue = ImmutableList.copyOf(elements);
        return new ImmutablePointcutClass(this.type, this.pointcut, newValue, this.bytes, this.collocateInClassLoader, this.pluginJar);
    }

    public final ImmutablePointcutClass withBytes(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutablePointcutClass(this.type, this.pointcut, this.methods, newValue, this.collocateInClassLoader, this.pluginJar);
    }

    public final ImmutablePointcutClass withCollocateInClassLoader(boolean value) {
        if (this.collocateInClassLoader == value) {
            return this;
        }
        return new ImmutablePointcutClass(this.type, this.pointcut, this.methods, this.bytes, value, this.pluginJar);
    }

    public final ImmutablePointcutClass withPluginJar(@Nullable File value) {
        if (this.pluginJar == value) {
            return this;
        }
        return new ImmutablePointcutClass(this.type, this.pointcut, this.methods, this.bytes, this.collocateInClassLoader, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePointcutClass && this.equalTo((ImmutablePointcutClass)another);
    }

    private boolean equalTo(ImmutablePointcutClass another) {
        return this.type.equals(another.type) && this.pointcut.equals(another.pointcut) && this.methods.equals(another.methods) && Arrays.equals(this.bytes, another.bytes) && this.collocateInClassLoader == another.collocateInClassLoader && Objects.equal(this.pluginJar, another.pluginJar);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.pointcut.hashCode();
        h += (h << 5) + this.methods.hashCode();
        h += (h << 5) + Arrays.hashCode(this.bytes);
        h += (h << 5) + Booleans.hashCode(this.collocateInClassLoader);
        h += (h << 5) + Objects.hashCode(this.pluginJar);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PointcutClass").omitNullValues().add("type", this.type).add("pointcut", this.pointcut).add("methods", this.methods).add("bytes", Arrays.toString(this.bytes)).add("collocateInClassLoader", this.collocateInClassLoader).add("pluginJar", this.pluginJar).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePointcutClass fromJson(Json json) {
        Builder builder = ImmutablePointcutClass.builder();
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.pointcut != null) {
            builder.pointcut(json.pointcut);
        }
        if (json.methods != null) {
            builder.addAllMethods(json.methods);
        }
        if (json.bytes != null) {
            builder.bytes(json.bytes);
        }
        if (json.collocateInClassLoaderIsSet) {
            builder.collocateInClassLoader(json.collocateInClassLoader);
        }
        if (json.pluginJar != null) {
            builder.pluginJar(json.pluginJar);
        }
        return builder.build();
    }

    public static ImmutablePointcutClass copyOf(PluginDetail.PointcutClass instance) {
        if (instance instanceof ImmutablePointcutClass) {
            return (ImmutablePointcutClass)instance;
        }
        return ImmutablePointcutClass.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PluginDetail.PointcutClass", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_POINTCUT = 2L;
        private static final long INIT_BIT_BYTES = 4L;
        private static final long INIT_BIT_COLLOCATE_IN_CLASS_LOADER = 8L;
        private long initBits = 15L;
        @Nullable
        private Type type;
        @Nullable
        private Pointcut pointcut;
        private ImmutableList.Builder<PluginDetail.PointcutMethod> methods = ImmutableList.builder();
        @Nullable
        private byte[] bytes;
        private boolean collocateInClassLoader;
        @Nullable
        private File pluginJar;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(PluginDetail.PointcutClass instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.type(instance.type());
            this.pointcut(instance.pointcut());
            this.addAllMethods(instance.methods());
            this.bytes(instance.bytes());
            this.collocateInClassLoader(instance.collocateInClassLoader());
            File pluginJarValue = instance.pluginJar();
            if (pluginJarValue != null) {
                this.pluginJar(pluginJarValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(Type type) {
            this.type = Preconditions.checkNotNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pointcut(Pointcut pointcut) {
            this.pointcut = Preconditions.checkNotNull(pointcut, "pointcut");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMethods(PluginDetail.PointcutMethod element) {
            this.methods.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMethods(PluginDetail.PointcutMethod ... elements) {
            this.methods.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder methods(Iterable<? extends PluginDetail.PointcutMethod> elements) {
            this.methods = ImmutableList.builder();
            return this.addAllMethods(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMethods(Iterable<? extends PluginDetail.PointcutMethod> elements) {
            this.methods.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bytes(byte ... bytes) {
            this.bytes = (byte[])bytes.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder collocateInClassLoader(boolean collocateInClassLoader) {
            this.collocateInClassLoader = collocateInClassLoader;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pluginJar(@Nullable File pluginJar) {
            this.pluginJar = pluginJar;
            return this;
        }

        public ImmutablePointcutClass build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePointcutClass(this.type, this.pointcut, (ImmutableList)this.methods.build(), this.bytes, this.collocateInClassLoader, this.pluginJar);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("pointcut");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("bytes");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("collocateInClassLoader");
            }
            return "Cannot build PointcutClass, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PluginDetail.PointcutClass", generator="Immutables")
    static final class Json
    extends PluginDetail.PointcutClass {
        @Nullable
        Type type;
        @Nullable
        Pointcut pointcut;
        @Nullable
        List<PluginDetail.PointcutMethod> methods = ImmutableList.of();
        @Nullable
        byte[] bytes;
        boolean collocateInClassLoader;
        boolean collocateInClassLoaderIsSet;
        @Nullable
        File pluginJar;

        Json() {
        }

        @JsonProperty(value="type")
        public void setType(Type type) {
            this.type = type;
        }

        @JsonProperty(value="pointcut")
        public void setPointcut(Pointcut pointcut) {
            this.pointcut = pointcut;
        }

        @JsonProperty(value="methods")
        public void setMethods(List<PluginDetail.PointcutMethod> methods) {
            this.methods = methods;
        }

        @JsonProperty(value="bytes")
        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        @JsonProperty(value="collocateInClassLoader")
        public void setCollocateInClassLoader(boolean collocateInClassLoader) {
            this.collocateInClassLoader = collocateInClassLoader;
            this.collocateInClassLoaderIsSet = true;
        }

        @JsonProperty(value="pluginJar")
        public void setPluginJar(@Nullable File pluginJar) {
            this.pluginJar = pluginJar;
        }

        @Override
        Type type() {
            throw new UnsupportedOperationException();
        }

        @Override
        Pointcut pointcut() {
            throw new UnsupportedOperationException();
        }

        @Override
        List<PluginDetail.PointcutMethod> methods() {
            throw new UnsupportedOperationException();
        }

        @Override
        byte[] bytes() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean collocateInClassLoader() {
            throw new UnsupportedOperationException();
        }

        @Override
        File pluginJar() {
            throw new UnsupportedOperationException();
        }
    }
}

