/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Objects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.weaving.ThinClassVisitor;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ThinClassVisitor.ThinMethod", generator="Immutables")
@Immutable
final class ImmutableThinMethod
implements ThinClassVisitor.ThinMethod {
    private final int access;
    private final String name;
    private final String descriptor;
    @Nullable
    private final String signature;
    private final ImmutableList<String> exceptions;
    private final ImmutableList<String> annotations;

    private ImmutableThinMethod(int access, String name, String descriptor, @Nullable String signature, ImmutableList<String> exceptions, ImmutableList<String> annotations) {
        this.access = access;
        this.name = name;
        this.descriptor = descriptor;
        this.signature = signature;
        this.exceptions = exceptions;
        this.annotations = annotations;
    }

    @Override
    @JsonProperty(value="access")
    public int access() {
        return this.access;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="descriptor")
    public String descriptor() {
        return this.descriptor;
    }

    @Override
    @JsonProperty(value="signature")
    @Nullable
    public String signature() {
        return this.signature;
    }

    @JsonProperty(value="exceptions")
    public ImmutableList<String> exceptions() {
        return this.exceptions;
    }

    @JsonProperty(value="annotations")
    public ImmutableList<String> annotations() {
        return this.annotations;
    }

    public final ImmutableThinMethod withAccess(int value) {
        if (this.access == value) {
            return this;
        }
        return new ImmutableThinMethod(value, this.name, this.descriptor, this.signature, this.exceptions, this.annotations);
    }

    public final ImmutableThinMethod withName(String value) {
        String newValue = Preconditions.checkNotNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableThinMethod(this.access, newValue, this.descriptor, this.signature, this.exceptions, this.annotations);
    }

    public final ImmutableThinMethod withDescriptor(String value) {
        String newValue = Preconditions.checkNotNull(value, "descriptor");
        if (this.descriptor.equals(newValue)) {
            return this;
        }
        return new ImmutableThinMethod(this.access, this.name, newValue, this.signature, this.exceptions, this.annotations);
    }

    public final ImmutableThinMethod withSignature(@Nullable String value) {
        if (Objects.equal(this.signature, value)) {
            return this;
        }
        return new ImmutableThinMethod(this.access, this.name, this.descriptor, value, this.exceptions, this.annotations);
    }

    public final ImmutableThinMethod withExceptions(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableThinMethod(this.access, this.name, this.descriptor, this.signature, newValue, this.annotations);
    }

    public final ImmutableThinMethod withExceptions(Iterable<String> elements) {
        if (this.exceptions == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableThinMethod(this.access, this.name, this.descriptor, this.signature, newValue, this.annotations);
    }

    public final ImmutableThinMethod withAnnotations(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableThinMethod(this.access, this.name, this.descriptor, this.signature, this.exceptions, newValue);
    }

    public final ImmutableThinMethod withAnnotations(Iterable<String> elements) {
        if (this.annotations == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableThinMethod(this.access, this.name, this.descriptor, this.signature, this.exceptions, newValue);
    }

    public boolean equals(@org.glowroot.agent.shaded.javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableThinMethod && this.equalTo((ImmutableThinMethod)another);
    }

    private boolean equalTo(ImmutableThinMethod another) {
        return this.access == another.access && this.name.equals(another.name) && this.descriptor.equals(another.descriptor) && Objects.equal(this.signature, another.signature) && this.exceptions.equals(another.exceptions) && this.annotations.equals(another.annotations);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.access;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.descriptor.hashCode();
        h += (h << 5) + Objects.hashCode(this.signature);
        h += (h << 5) + this.exceptions.hashCode();
        h += (h << 5) + this.annotations.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ThinMethod").omitNullValues().add("access", this.access).add("name", this.name).add("descriptor", this.descriptor).add("signature", this.signature).add("exceptions", this.exceptions).add("annotations", this.annotations).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableThinMethod fromJson(Json json) {
        Builder builder = ImmutableThinMethod.builder();
        if (json.accessIsSet) {
            builder.access(json.access);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.descriptor != null) {
            builder.descriptor(json.descriptor);
        }
        if (json.signature != null) {
            builder.signature(json.signature);
        }
        if (json.exceptions != null) {
            builder.addAllExceptions(json.exceptions);
        }
        if (json.annotations != null) {
            builder.addAllAnnotations(json.annotations);
        }
        return builder.build();
    }

    public static ImmutableThinMethod copyOf(ThinClassVisitor.ThinMethod instance) {
        if (instance instanceof ImmutableThinMethod) {
            return (ImmutableThinMethod)instance;
        }
        return ImmutableThinMethod.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ThinClassVisitor.ThinMethod", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCESS = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_DESCRIPTOR = 4L;
        private long initBits = 7L;
        private int access;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        private String name;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        private String descriptor;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        private String signature;
        private ImmutableList.Builder<String> exceptions = ImmutableList.builder();
        private ImmutableList.Builder<String> annotations = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(ThinClassVisitor.ThinMethod instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.access(instance.access());
            this.name(instance.name());
            this.descriptor(instance.descriptor());
            String signatureValue = instance.signature();
            if (signatureValue != null) {
                this.signature(signatureValue);
            }
            this.addAllExceptions(instance.exceptions());
            this.addAllAnnotations(instance.annotations());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder access(int access) {
            this.access = access;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder descriptor(String descriptor) {
            this.descriptor = Preconditions.checkNotNull(descriptor, "descriptor");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signature(@Nullable String signature) {
            this.signature = signature;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExceptions(String element) {
            this.exceptions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExceptions(String ... elements) {
            this.exceptions.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder exceptions(Iterable<String> elements) {
            this.exceptions = ImmutableList.builder();
            return this.addAllExceptions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExceptions(Iterable<String> elements) {
            this.exceptions.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAnnotations(String element) {
            this.annotations.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAnnotations(String ... elements) {
            this.annotations.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder annotations(Iterable<String> elements) {
            this.annotations = ImmutableList.builder();
            return this.addAllAnnotations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAnnotations(Iterable<String> elements) {
            this.annotations.addAll((Iterable)elements);
            return this;
        }

        public ImmutableThinMethod build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableThinMethod(this.access, this.name, this.descriptor, this.signature, (ImmutableList)this.exceptions.build(), (ImmutableList)this.annotations.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("access");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("descriptor");
            }
            return "Cannot build ThinMethod, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ThinClassVisitor.ThinMethod", generator="Immutables")
    static final class Json
    implements ThinClassVisitor.ThinMethod {
        int access;
        boolean accessIsSet;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        String name;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        String descriptor;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        String signature;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        List<String> exceptions = ImmutableList.of();
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        List<String> annotations = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="access")
        public void setAccess(int access) {
            this.access = access;
            this.accessIsSet = true;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="descriptor")
        public void setDescriptor(String descriptor) {
            this.descriptor = descriptor;
        }

        @JsonProperty(value="signature")
        public void setSignature(@Nullable String signature) {
            this.signature = signature;
        }

        @JsonProperty(value="exceptions")
        public void setExceptions(List<String> exceptions) {
            this.exceptions = exceptions;
        }

        @JsonProperty(value="annotations")
        public void setAnnotations(List<String> annotations) {
            this.annotations = annotations;
        }

        @Override
        public int access() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String descriptor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String signature() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> exceptions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> annotations() {
            throw new UnsupportedOperationException();
        }
    }
}

