/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.glowroot.agent.config.PluginDescriptor;
import org.glowroot.agent.plugin.api.weaving.MethodModifier;
import org.glowroot.agent.plugin.api.weaving.Mixin;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.Iterables;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.io.Resources;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;
import org.glowroot.agent.shaded.org.objectweb.asm.AnnotationVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassReader;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.MethodVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.weaving.ClassNames;
import org.glowroot.agent.weaving.ImmutableMixinClass;
import org.glowroot.agent.weaving.ImmutablePluginDetail;
import org.glowroot.agent.weaving.ImmutablePointcutClass;
import org.glowroot.agent.weaving.ImmutablePointcutMethod;
import org.glowroot.agent.weaving.ImmutableShimClass;
import org.glowroot.agent.weaving.PluginDetail;

class PluginDetailBuilder {
    private static final Logger logger = LoggerFactory.getLogger(PluginDetailBuilder.class);
    private PluginDescriptor pluginDescriptor;

    PluginDetailBuilder(PluginDescriptor pluginDescriptor) {
        this.pluginDescriptor = pluginDescriptor;
    }

    PluginDetail build() throws IOException {
        ImmutablePluginDetail.Builder builder = ImmutablePluginDetail.builder();
        for (String aspect : this.pluginDescriptor.aspects()) {
            byte[] bytes = PluginDetailBuilder.getBytes(ClassNames.toInternalName(aspect), this.pluginDescriptor.pluginJar());
            AspectClassVisitor cv = new AspectClassVisitor();
            new ClassReader(bytes).accept(cv, 1);
            for (String innerClassName : cv.innerClassNames) {
                bytes = PluginDetailBuilder.getBytes(innerClassName, this.pluginDescriptor.pluginJar());
                MemberClassVisitor mcv = new MemberClassVisitor();
                new ClassReader(bytes).accept(mcv, 1);
                if (mcv.pointcutAnnotationVisitor != null) {
                    builder.addPointcutClasses((PluginDetail.PointcutClass)mcv.buildPointcutClass(bytes, this.pluginDescriptor.collocate(), this.pluginDescriptor.pluginJar()));
                    continue;
                }
                if (mcv.mixinAnnotationVisitor != null) {
                    builder.addMixinClasses((PluginDetail.MixinClass)mcv.buildMixinClass(this.pluginDescriptor.collocate(), bytes));
                    continue;
                }
                if (!mcv.shim) continue;
                builder.addShimClasses((PluginDetail.ShimClass)mcv.buildShimClass(this.pluginDescriptor.collocate()));
            }
        }
        return builder.build();
    }

    static PluginDetail.PointcutClass buildAdviceClass(byte[] bytes) {
        MemberClassVisitor acv = new MemberClassVisitor();
        new ClassReader(bytes).accept(acv, 1);
        return acv.buildPointcutClass(bytes, false, null);
    }

    static byte[] getBytes(String className, @Nullable File pluginJar) throws IOException {
        String resourceName = "/" + className + ".class";
        URL url = PluginDetailBuilder.class.getResource(resourceName);
        if (url != null) {
            return Resources.toByteArray(url);
        }
        if (pluginJar != null) {
            url = new URL("jar:" + pluginJar.toURI() + "!" + resourceName);
            return Resources.toByteArray(url);
        }
        throw new IOException("Class not found: " + className);
    }

    @OnlyUsedByTests
    static PluginDetail.PointcutClass buildAdviceClass(Class<?> clazz) throws IOException {
        return PluginDetailBuilder.buildAdviceClassLookAtSuperClass(ClassNames.toInternalName(clazz.getName()));
    }

    @OnlyUsedByTests
    static PluginDetail.MixinClass buildMixinClass(Class<?> clazz) throws IOException {
        URL url = Preconditions.checkNotNull(PluginDetailBuilder.class.getResource("/" + ClassNames.toInternalName(clazz.getName()) + ".class"));
        byte[] bytes = Resources.asByteSource(url).read();
        MemberClassVisitor mcv = new MemberClassVisitor();
        new ClassReader(bytes).accept(mcv, 1);
        return mcv.buildMixinClass(false, bytes);
    }

    @OnlyUsedByTests
    private static PluginDetail.PointcutClass buildAdviceClassLookAtSuperClass(String internalName) throws IOException {
        URL url = Preconditions.checkNotNull(PluginDetailBuilder.class.getResource("/" + internalName + ".class"));
        byte[] bytes = Resources.asByteSource(url).read();
        MemberClassVisitor mcv = new MemberClassVisitor();
        new ClassReader(bytes).accept(mcv, 1);
        ImmutablePointcutClass pointcutClass = mcv.buildPointcutClass(bytes, false, null);
        String superName = Preconditions.checkNotNull(mcv.superName);
        if (!"java/lang/Object".equals(superName)) {
            pointcutClass = ImmutablePointcutClass.builder().copyFrom(pointcutClass).addAllMethods(PluginDetailBuilder.buildAdviceClassLookAtSuperClass(superName).methods()).build();
        }
        return pointcutClass;
    }

    private static class MethodModifierArrayAnnotationVisitor
    extends AnnotationVisitor {
        private final List<MethodModifier> list;

        private MethodModifierArrayAnnotationVisitor(List<MethodModifier> list) {
            super(458752);
            this.list = list;
        }

        @Override
        public void visitEnum(String name, String descriptor, String value) {
            this.list.add(MethodModifier.valueOf(value));
        }
    }

    private static class StringArrayAnnotationVisitor
    extends AnnotationVisitor {
        private final List<String> list;

        private StringArrayAnnotationVisitor(List<String> list) {
            super(458752);
            this.list = list;
        }

        @Override
        public void visit(@Nullable String name, Object value) {
            this.list.add((String)value);
        }
    }

    private static class MixinMethodVisitor
    extends MethodVisitor {
        private final String name;
        private final String descriptor;
        private boolean init;

        private MixinMethodVisitor(String name, String descriptor) {
            super(458752);
            this.name = name;
            this.descriptor = descriptor;
        }

        @Override
        @Nullable
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (descriptor.equals("Lorg/glowroot/agent/plugin/api/weaving/MixinInit;")) {
                if (Type.getArgumentTypes(this.descriptor).length > 0) {
                    throw new IllegalStateException("@MixinInit method cannot have any parameters");
                }
                if (!Type.getReturnType(this.descriptor).equals(Type.VOID_TYPE)) {
                    throw new IllegalStateException("@MixinInit method must return void");
                }
                this.init = true;
            }
            return null;
        }
    }

    private static class MixinAnnotationVisitor
    extends AnnotationVisitor {
        private List<String> values = Lists.newArrayList();

        private MixinAnnotationVisitor() {
            super(458752);
        }

        @Override
        public void visit(@Nullable String name, Object value) {
            throw new IllegalStateException("Unexpected @Mixin attribute name: " + name);
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            if ("value".equals(name)) {
                return new StringArrayAnnotationVisitor(this.values);
            }
            throw new IllegalStateException("Unexpected @Mixin attribute name: " + name);
        }

        private Mixin build() {
            return new Mixin(){

                @Override
                public Class<? extends Annotation> annotationType() {
                    return Mixin.class;
                }

                @Override
                public String[] value() {
                    return Iterables.toArray(MixinAnnotationVisitor.this.values, String.class);
                }
            };
        }
    }

    private static class PointcutMethodVisitor
    extends MethodVisitor {
        private final String name;
        private final String descriptor;
        private final List<Type> annotationTypes = Lists.newArrayList();
        private final Map<Integer, List<Type>> parameterAnnotationTypes = Maps.newHashMap();

        private PointcutMethodVisitor(String name, String descriptor) {
            super(458752);
            this.name = name;
            this.descriptor = descriptor;
        }

        @Override
        @Nullable
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            this.annotationTypes.add(Type.getType(descriptor));
            return null;
        }

        @Override
        @Nullable
        public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
            List<Type> list = this.parameterAnnotationTypes.get(parameter);
            if (list == null) {
                list = Lists.newArrayList();
                this.parameterAnnotationTypes.put(parameter, list);
            }
            list.add(Type.getType(descriptor));
            return null;
        }

        private PluginDetail.PointcutMethod build() {
            return ImmutablePointcutMethod.builder().name(this.name).descriptor(this.descriptor).addAllAnnotationTypes(this.annotationTypes).putAllParameterAnnotationTypes(this.parameterAnnotationTypes).build();
        }
    }

    private static class PointcutAnnotationVisitor
    extends AnnotationVisitor {
        private String className = "";
        private String classAnnotation = "";
        private String subTypeRestriction = "";
        private String superTypeRestriction = "";
        private String methodName = "";
        private String methodAnnotation = "";
        private List<String> methodParameterTypes = Lists.newArrayList();
        private String methodReturnType = "";
        private List<MethodModifier> methodModifiers = Lists.newArrayList();
        private String nestingGroup = "";
        private String timerName = "";
        private int order;
        private String suppressibleUsingKey = "";
        private String suppressionKey = "";

        private PointcutAnnotationVisitor() {
            super(458752);
        }

        @Override
        public void visit(@Nullable String name, Object value) {
            if ("className".equals(name)) {
                this.className = (String)value;
            } else if ("classAnnotation".equals(name)) {
                this.classAnnotation = (String)value;
            } else if ("subTypeRestriction".equals(name)) {
                this.subTypeRestriction = (String)value;
            } else if ("superTypeRestriction".equals(name)) {
                this.superTypeRestriction = (String)value;
            } else if ("methodName".equals(name)) {
                this.methodName = (String)value;
            } else if ("methodAnnotation".equals(name)) {
                this.methodAnnotation = (String)value;
            } else if ("methodReturnType".equals(name)) {
                this.methodReturnType = (String)value;
            } else if ("nestingGroup".equals(name)) {
                this.nestingGroup = (String)value;
            } else if ("timerName".equals(name)) {
                this.timerName = (String)value;
            } else if ("order".equals(name)) {
                this.order = (Integer)value;
            } else if ("suppressibleUsingKey".equals(name)) {
                this.suppressibleUsingKey = (String)value;
            } else if ("suppressionKey".equals(name)) {
                this.suppressionKey = (String)value;
            } else {
                throw new IllegalStateException("Unexpected @Pointcut attribute name: " + name);
            }
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            if ("methodParameterTypes".equals(name)) {
                return new StringArrayAnnotationVisitor(this.methodParameterTypes);
            }
            if ("methodModifiers".equals(name)) {
                return new MethodModifierArrayAnnotationVisitor(this.methodModifiers);
            }
            throw new IllegalStateException("Unexpected @Pointcut attribute name: " + name);
        }

        private Pointcut build() {
            return new Pointcut(){

                @Override
                public Class<? extends Annotation> annotationType() {
                    return Pointcut.class;
                }

                @Override
                public String className() {
                    return PointcutAnnotationVisitor.this.className;
                }

                @Override
                public String classAnnotation() {
                    return PointcutAnnotationVisitor.this.classAnnotation;
                }

                @Override
                public String subTypeRestriction() {
                    return PointcutAnnotationVisitor.this.subTypeRestriction;
                }

                @Override
                public String superTypeRestriction() {
                    return PointcutAnnotationVisitor.this.superTypeRestriction;
                }

                @Override
                public String methodName() {
                    return PointcutAnnotationVisitor.this.methodName;
                }

                @Override
                public String methodAnnotation() {
                    return PointcutAnnotationVisitor.this.methodAnnotation;
                }

                @Override
                public String[] methodParameterTypes() {
                    return Iterables.toArray(PointcutAnnotationVisitor.this.methodParameterTypes, String.class);
                }

                @Override
                public String methodReturnType() {
                    return PointcutAnnotationVisitor.this.methodReturnType;
                }

                @Override
                public MethodModifier[] methodModifiers() {
                    return Iterables.toArray(PointcutAnnotationVisitor.this.methodModifiers, MethodModifier.class);
                }

                @Override
                public String nestingGroup() {
                    return PointcutAnnotationVisitor.this.nestingGroup;
                }

                @Override
                public String timerName() {
                    return PointcutAnnotationVisitor.this.timerName;
                }

                @Override
                public int order() {
                    return PointcutAnnotationVisitor.this.order;
                }

                @Override
                public String suppressibleUsingKey() {
                    return PointcutAnnotationVisitor.this.suppressibleUsingKey;
                }

                @Override
                public String suppressionKey() {
                    return PointcutAnnotationVisitor.this.suppressionKey;
                }
            };
        }
    }

    private static class MemberClassVisitor
    extends ClassVisitor {
        @Nullable
        private String name;
        @Nullable
        private String superName;
        private String[] interfaces;
        @Nullable
        private PointcutAnnotationVisitor pointcutAnnotationVisitor;
        @Nullable
        private MixinAnnotationVisitor mixinAnnotationVisitor;
        private List<PointcutMethodVisitor> pointcutMethodVisitors = Lists.newArrayList();
        private List<MixinMethodVisitor> mixinMethodVisitors = Lists.newArrayList();
        private boolean shim;

        private MemberClassVisitor() {
            super(458752);
        }

        @Override
        public void visit(int version, int access, String name, @Nullable String signature, @Nullable String superName, String[] interfaces) {
            this.name = name;
            this.superName = superName;
            this.interfaces = interfaces;
        }

        @Override
        @Nullable
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (descriptor.equals("Lorg/glowroot/agent/plugin/api/weaving/Pointcut;")) {
                this.pointcutAnnotationVisitor = new PointcutAnnotationVisitor();
                return this.pointcutAnnotationVisitor;
            }
            if (descriptor.equals("Lorg/glowroot/agent/plugin/api/weaving/Mixin;")) {
                this.mixinAnnotationVisitor = new MixinAnnotationVisitor();
                return this.mixinAnnotationVisitor;
            }
            if (descriptor.equals("Lorg/glowroot/agent/plugin/api/weaving/Shim;")) {
                this.shim = true;
            }
            return null;
        }

        @Override
        @Nullable
        public MethodVisitor visitMethod(int access, String name, String descriptor, @Nullable String signature, String[] exceptions) {
            if (this.pointcutAnnotationVisitor != null) {
                PointcutMethodVisitor methodVisitor = new PointcutMethodVisitor(name, descriptor);
                this.pointcutMethodVisitors.add(methodVisitor);
                return methodVisitor;
            }
            if (this.mixinAnnotationVisitor != null) {
                MixinMethodVisitor methodVisitor = new MixinMethodVisitor(name, descriptor);
                this.mixinMethodVisitors.add(methodVisitor);
                return methodVisitor;
            }
            return null;
        }

        private ImmutablePointcutClass buildPointcutClass(byte[] bytes, boolean collocateInClassLoader, @Nullable File pluginJar) {
            ImmutablePointcutClass.Builder builder = ImmutablePointcutClass.builder().type(Type.getObjectType(Preconditions.checkNotNull(this.name)));
            for (PointcutMethodVisitor methodVisitor : this.pointcutMethodVisitors) {
                builder.addMethods(methodVisitor.build());
            }
            return builder.pointcut(Preconditions.checkNotNull(this.pointcutAnnotationVisitor).build()).bytes(bytes).collocateInClassLoader(collocateInClassLoader).pluginJar(pluginJar).build();
        }

        private ImmutableMixinClass buildMixinClass(boolean collocateInClassLoader, byte[] bytes) {
            String initMethodName = null;
            for (MixinMethodVisitor methodVisitor : this.mixinMethodVisitors) {
                if (!methodVisitor.init) continue;
                if (initMethodName != null) {
                    throw new IllegalStateException("@Mixin has more than one @MixinInit");
                }
                initMethodName = methodVisitor.name;
            }
            ImmutableMixinClass.Builder builder = ImmutableMixinClass.builder().type(Type.getObjectType(Preconditions.checkNotNull(this.name)));
            if (this.interfaces != null) {
                for (String iface : this.interfaces) {
                    if (collocateInClassLoader && !iface.endsWith("Mixin")) {
                        logger.warn("mixin interface name should end with \"Mixin\": {}", (Object)iface);
                    }
                    builder.addInterfaces(Type.getObjectType(iface));
                }
            }
            return builder.mixin(Preconditions.checkNotNull(this.mixinAnnotationVisitor).build()).initMethodName(initMethodName).bytes(bytes).build();
        }

        private ImmutableShimClass buildShimClass(boolean collocateInClassLoader) {
            if (collocateInClassLoader && !Preconditions.checkNotNull(this.name).endsWith("Shim")) {
                logger.warn("shim interface name should end with \"Shim\": {}", (Object)this.name);
            }
            return ImmutableShimClass.builder().type(Type.getObjectType(Preconditions.checkNotNull(this.name))).build();
        }
    }

    private static class AspectClassVisitor
    extends ClassVisitor {
        private List<String> innerClassNames = Lists.newArrayList();

        private AspectClassVisitor() {
            super(458752);
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            this.innerClassNames.add(name);
        }
    }
}

