/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.weaving.Java9;
import org.glowroot.agent.weaving.Weaver;

public class WeavingClassFileTransformer
implements ClassFileTransformer {
    private static final boolean ALLOW_WEAVING_AGENT_CLASSES = Boolean.getBoolean("glowroot.internal.allowWeavingAgentClasses");
    private static final Logger logger = LoggerFactory.getLogger(WeavingClassFileTransformer.class);
    private final Weaver weaver;
    private final Instrumentation instrumentation;
    private final boolean weaveBootstrapClassLoader;
    private final Set<Object> redefinedModules = Collections.newSetFromMap(Collections.synchronizedMap(new WeakHashMap()));

    public WeavingClassFileTransformer(Weaver weaver, Instrumentation instrumentation) {
        this.weaver = weaver;
        this.instrumentation = instrumentation;
        this.weaveBootstrapClassLoader = WeavingClassFileTransformer.isInBootstrapClassLoader();
    }

    public byte[] transformJava9(Object module, @Nullable ClassLoader loader, @Nullable String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, byte[] bytes) {
        if (this.redefinedModules.add(module)) {
            try {
                Java9.grantAccessToGlowroot(this.instrumentation, module);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }
        return this.transform(loader, className, classBeingRedefined, protectionDomain, bytes);
    }

    @Override
    public byte[] transform(@Nullable ClassLoader loader, @Nullable String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, byte[] bytes) {
        String nonNullClassName = className == null ? "unnamed" : className;
        try {
            return this.transformInternal(loader, nonNullClassName, classBeingRedefined, protectionDomain, bytes);
        }
        catch (Throwable t) {
            logger.error("error weaving {}: {}", nonNullClassName, t.getMessage(), t);
            return null;
        }
    }

    private byte[] transformInternal(@Nullable ClassLoader loader, String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, byte[] bytes) {
        if (WeavingClassFileTransformer.ignoreClass(className, loader)) {
            return null;
        }
        if (loader == null && !this.weaveBootstrapClassLoader) {
            return null;
        }
        CodeSource codeSource = protectionDomain == null ? null : protectionDomain.getCodeSource();
        return this.weaver.weave(bytes, className, classBeingRedefined, codeSource, loader);
    }

    private static boolean ignoreClass(String className, @Nullable ClassLoader loader) {
        if (!ALLOW_WEAVING_AGENT_CLASSES && WeavingClassFileTransformer.isGlowrootAgentClass(className)) {
            return true;
        }
        if (className.startsWith("sun/reflect/Generated")) {
            return true;
        }
        return className.equals("load/C4") && loader != null && loader.getClass().getName().equals("oracle.classloader.util.ClassLoadEnvironment$DependencyLoader");
    }

    private static boolean isGlowrootAgentClass(String className) {
        if (!className.startsWith("org/glowroot")) {
            return false;
        }
        return className.startsWith("org/glowroot/agent/shaded/org/glowroot/common/") || className.startsWith("org/glowroot/agent/shaded/org/glowroot/wire/api/") || className.startsWith("org/glowroot/agent/api/") || className.startsWith("org/glowroot/agent/plugin/api/") || className.startsWith("org/glowroot/agent/bytecode/api/") || className.startsWith("org/glowroot/agent/central/") || className.startsWith("org/glowroot/agent/collector/") || className.startsWith("org/glowroot/agent/config/") || className.startsWith("org/glowroot/agent/embedded/") || className.startsWith("org/glowroot/agent/impl/") || className.startsWith("org/glowroot/agent/init/") || className.startsWith("org/glowroot/agent/jul/") || className.startsWith("org/glowroot/agent/live/") || className.startsWith("org/glowroot/agent/model/") || className.startsWith("org/glowroot/agent/shaded/") || className.startsWith("org/glowroot/agent/util/") || className.startsWith("org/glowroot/agent/weaving/");
    }

    private static boolean isInBootstrapClassLoader() {
        return WeavingClassFileTransformer.class.getClassLoader() == null;
    }
}

