/*
 * Decompiled with CFR 0.152.
 */
package fs2.data.xml.internals;

import cats.Foldable;
import cats.MonadError;
import cats.UnorderedFoldable$;
import cats.kernel.Eq;
import cats.kernel.Eq$;
import cats.syntax.package;
import fs2.Stream;
import fs2.data.xml.Attr;
import fs2.data.xml.Attr$;
import fs2.data.xml.NSCAttributesUnique$;
import fs2.data.xml.NSCNoPrefixUndeclaring$;
import fs2.data.xml.NSCPrefixDeclared$;
import fs2.data.xml.QName;
import fs2.data.xml.QName$;
import fs2.data.xml.XmlEvent;
import fs2.data.xml.XmlEvent$EndTag$;
import fs2.data.xml.XmlEvent$StartTag$;
import fs2.data.xml.XmlException;
import fs2.data.xml.XmlSyntax$;
import fs2.data.xml.internals.NamespaceResolver$;
import fs2.data.xml.internals.ResolverEnv;
import fs2.data.xml.internals.ResolverEnv$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;

public class NamespaceResolver<F> {
    private final MonadError<F, Throwable> F;
    private final Some<String> xmlNSURI;

    public static <F> NamespaceResolver<F> apply(MonadError<F, Throwable> monadError) {
        return NamespaceResolver$.MODULE$.apply(monadError);
    }

    public NamespaceResolver(MonadError<F, Throwable> F) {
        this.F = F;
        this.xmlNSURI = Some$.MODULE$.apply((Object)"http://www.w3.org/XML/1998/namespace");
    }

    public Function1<Stream<F, XmlEvent>, Stream<F, XmlEvent>> pipe() {
        return (Function1 & Serializable)_$3 -> _$3.evalMapAccumulate((Object)ResolverEnv$.MODULE$.apply((Option<ResolverEnv>)None$.MODULE$, (Map<String, String>)Predef$.MODULE$.Map().empty(), 0), (Function2 & Serializable)(x$12, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$12, x$2);
            if (tuple2 != null) {
                ResolverEnv resolverEnv = (ResolverEnv)tuple2._1();
                XmlEvent xmlEvent = (XmlEvent)tuple2._2();
                ResolverEnv env2 = resolverEnv;
                if (xmlEvent instanceof XmlEvent.StartTag) {
                    XmlEvent.StartTag startTag = (XmlEvent.StartTag)xmlEvent;
                    XmlEvent.StartTag startTag2 = XmlEvent$StartTag$.MODULE$.unapply(startTag);
                    QName qName = startTag2._1();
                    List<Attr> list = startTag2._2();
                    boolean bl = startTag2._3();
                    QName name2 = qName;
                    List<Attr> attrs = list;
                    XmlEvent.StartTag evt = startTag;
                    return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFoldableOps(attrs, (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()).foldM((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(env, attr) -> this.updateNS((Map<String, String>)env, (Attr)attr), this.F), this.F).map((Function1 & Serializable)mapping -> {
                        ResolverEnv env1 = env2.push((Map<String, String>)mapping);
                        return Tuple2$.MODULE$.apply(mapping, (Object)env1);
                    }), this.F).flatMap((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Map mapping = (Map)tuple2._1();
                            ResolverEnv env1 = (ResolverEnv)tuple2._2();
                            return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toTraverseOps((Object)attrs, UnorderedFoldable$.MODULE$.catsTraverseForList()).traverse((Function1 & Serializable)attr -> package.all$.MODULE$.toFunctorOps(this.resolve(env1, attr.name(), false), this.F).map((Function1 & Serializable)n -> attr.copy((QName)n, attr.copy$default$2())), this.F), this.F).flatMap((Function1 & Serializable)attrs -> package.all$.MODULE$.toFlatMapOps(this.checkDuplicates((List<Attr>)attrs), this.F).flatMap((Function1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return package.all$.MODULE$.toFunctorOps(this.resolve(env1, name2, true), this.F).map((Function1 & Serializable)name -> Tuple2$.MODULE$.apply((Object)env1, (Object)evt.copy((QName)name, (List<Attr>)attrs, evt.copy$default$3())));
                            }));
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
                ResolverEnv env3 = resolverEnv;
                if (xmlEvent instanceof XmlEvent.EndTag) {
                    QName qName;
                    XmlEvent.EndTag endTag = (XmlEvent.EndTag)xmlEvent;
                    XmlEvent.EndTag endTag2 = XmlEvent$EndTag$.MODULE$.unapply(endTag);
                    QName name3 = qName = endTag2._1();
                    XmlEvent.EndTag evt = endTag;
                    return package.all$.MODULE$.toFlatMapOps(this.resolve(env3, name3, true), this.F).flatMap((Function1 & Serializable)name -> {
                        Object object;
                        Option<ResolverEnv> option = env3.pop();
                        if (option instanceof Some) {
                            ResolverEnv env2 = (ResolverEnv)((Some)option).value();
                            object = this.F.pure((Object)env2);
                        } else if (None$.MODULE$.equals(option)) {
                            object = this.F.raiseError((Object)new XmlException(XmlSyntax$.MODULE$.apply("GIMatch"), "unexpected closing tag '</" + name.render() + ">'"));
                        } else {
                            throw new MatchError(option);
                        }
                        return package.all$.MODULE$.toFunctorOps(object, this.F).map((Function1 & Serializable)env -> Tuple2$.MODULE$.apply(env, (Object)evt.copy((QName)name)));
                    });
                }
            }
            Tuple2 v = tuple2;
            return this.F.pure((Object)v);
        }).map((Function1 & Serializable)_$4 -> (XmlEvent)_$4._2());
    }

    private F resolve(ResolverEnv env, QName name, boolean withDefault) {
        QName qName = name;
        if (qName != null) {
            String pfx;
            QName qName2 = QName$.MODULE$.unapply(qName);
            Option<String> option = qName2._1();
            String string = qName2._2();
            if (option instanceof Some && package.all$.MODULE$.catsSyntaxEq((Object)StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(pfx = (String)((Some)option).value()), 3).toLowerCase(), (Eq)Eq$.MODULE$.catsKernelInstancesForString()).$eq$bang$eq((Object)"xml")) {
                Option<String> option2 = env.resolve(pfx);
                if (None$.MODULE$.equals(option2)) {
                    return (F)this.F.raiseError((Object)new XmlException(NSCPrefixDeclared$.MODULE$, "undeclared namespace " + pfx));
                }
                Option<String> uri = option2;
                return (F)this.F.pure((Object)name.copy(uri, name.copy$default$2()));
            }
            if (None$.MODULE$.equals(option) && withDefault) {
                Option<String> option3 = env.resolve("");
                if (option3 instanceof Some) {
                    Some uri = (Some)option3;
                    return (F)this.F.pure((Object)name.copy((Option<String>)uri, name.copy$default$2()));
                }
                if (None$.MODULE$.equals(option3)) {
                    return (F)this.F.pure((Object)name.copy((Option<String>)this.xmlNSURI, name.copy$default$2()));
                }
                throw new MatchError(option3);
            }
        }
        return (F)this.F.pure((Object)name);
    }

    private F checkDuplicates(List<Attr> attrs) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFoldableOps(attrs, (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()).foldM((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Attr attr = (Attr)tuple2._2();
                Set seen = (Set)tuple2._1();
                if (attr != null) {
                    Attr attr2 = Attr$.MODULE$.unapply(attr);
                    QName qName = attr2._1();
                    List<XmlEvent.XmlTexty> list = attr2._2();
                    QName name = qName;
                    if (seen.contains((Object)name)) {
                        return this.F.raiseError((Object)new XmlException(NSCAttributesUnique$.MODULE$, "duplicate attribute with resolved name " + name.render()));
                    }
                    return this.F.pure((Object)seen.$plus((Object)name));
                }
            }
            throw new MatchError((Object)tuple2);
        }, this.F), this.F).void();
    }

    private F updateNS(Map<String, String> env, Attr attr) {
        Attr attr2 = attr;
        if (attr2 != null) {
            Attr attr3 = Attr$.MODULE$.unapply(attr2);
            QName qName = attr3._1();
            List<XmlEvent.XmlTexty> list = attr3._2();
            if (qName != null) {
                QName qName2 = QName$.MODULE$.unapply(qName);
                Option<String> option = qName2._1();
                String string = qName2._2();
                if (None$.MODULE$.equals(option) && "xmlns".equals(string)) {
                    List<XmlEvent.XmlTexty> v = list;
                    String uri = v.map((Function1 & Serializable)_$5 -> _$5.render()).mkString();
                    return (F)this.F.pure((Object)env.updated((Object)"", (Object)uri));
                }
                if (option instanceof Some && "xmlns".equals(((Some)option).value())) {
                    String name = string;
                    List<XmlEvent.XmlTexty> v = list;
                    String uri = v.map((Function1 & Serializable)_$6 -> _$6.render()).mkString();
                    if (uri.isEmpty()) {
                        return (F)this.F.raiseError((Object)new XmlException(NSCNoPrefixUndeclaring$.MODULE$, "undeclaring namespace " + name + " is not allowed"));
                    }
                    return (F)this.F.pure((Object)env.updated((Object)name, (Object)uri));
                }
            }
        }
        return (F)this.F.pure(env);
    }
}

