/*
 * Decompiled with CFR 0.152.
 */
package gnieh.string;

import scala.Array$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001\u000f\tIq)\u00199Ck\u001a4WM\u001d\u0006\u0003\u0007\u0011\taa\u001d;sS:<'\"A\u0003\u0002\u000b\u001dt\u0017.\u001a5\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u0011=\u0001!\u0011!Q\u0001\nA\t1\"\u001b8ji&\fGnU5{KB\u0011\u0011\"E\u0005\u0003%)\u00111!\u00138u\u0011\u0015!\u0002\u0001\"\u0001\u0016\u0003\u0019a\u0014N\\5u}Q\u0011a\u0003\u0007\t\u0003/\u0001i\u0011A\u0001\u0005\u0006\u001fM\u0001\r\u0001\u0005\u0005\b5\u0001\u0001\r\u0011\"\u0003\u001c\u0003\u001dy&-\u001e4gKJ,\u0012\u0001\b\t\u0004\u0013uy\u0012B\u0001\u0010\u000b\u0005\u0015\t%O]1z!\tI\u0001%\u0003\u0002\"\u0015\t!1\t[1s\u0011\u001d\u0019\u0003\u00011A\u0005\n\u0011\n1b\u00182vM\u001a,'o\u0018\u0013fcR\u0011Q\u0005\u000b\t\u0003\u0013\u0019J!a\n\u0006\u0003\tUs\u0017\u000e\u001e\u0005\bS\t\n\t\u00111\u0001\u001d\u0003\rAH%\r\u0005\u0007W\u0001\u0001\u000b\u0015\u0002\u000f\u0002\u0011}\u0013WO\u001a4fe\u0002Bq!\f\u0001A\u0002\u0013%a&A\u0005`O\u0006\u00048\u000b^1siV\t\u0001\u0003C\u00041\u0001\u0001\u0007I\u0011B\u0019\u0002\u001b};\u0017\r]*uCJ$x\fJ3r)\t)#\u0007C\u0004*_\u0005\u0005\t\u0019\u0001\t\t\rQ\u0002\u0001\u0015)\u0003\u0011\u0003)yv-\u00199Ti\u0006\u0014H\u000f\t\u0005\u0006m\u0001!IAL\u0001\u0006?NL'0\u001a\u0005\bq\u0001\u0001\r\u0011\"\u0003/\u0003\u001dyv-\u00199F]\u0012DqA\u000f\u0001A\u0002\u0013%1(A\u0006`O\u0006\u0004XI\u001c3`I\u0015\fHCA\u0013=\u0011\u001dI\u0013(!AA\u0002AAaA\u0010\u0001!B\u0013\u0001\u0012\u0001C0hCB,e\u000e\u001a\u0011\t\u000b\u0001\u0003A\u0011\u0002\u0018\u0002\u000f\u001d\f\u0007oU5{K\")!\t\u0001C\u0001]\u000511-\u001e:t_JDQ\u0001\u0012\u0001\u0005\u0002\u0015\u000b!bY;sg>\u0014x\fJ3r)\t)c\tC\u0003H\u0007\u0002\u0007\u0001#A\u0002q_NDQ!\u0013\u0001\u0005\u00029\n!BY;gM\u0016\u00148+\u001b>f\u0011\u0015Y\u0005\u0001\"\u0001/\u0003-\u0019wN\u001c;f]R\u001c\u0016N_3\t\u000b5\u0003A\u0011\u0001(\u0002\r5|g/\u001a\"z)\t)s\nC\u0003Q\u0019\u0002\u0007\u0001#A\u0003eK2$\u0018\rC\u0003S\u0001\u0011\u00051+\u0001\u0004j]N,'\u000f\u001e\u000b\u0003KQCQ!V)A\u0002}\t\u0011a\u0019\u0005\u0006%\u0002!\ta\u0016\u000b\u0003KaCQ!\u0017,A\u0002i\u000b\u0011a\u001d\t\u00037\nt!\u0001\u00181\u0011\u0005uSQ\"\u00010\u000b\u0005}3\u0011A\u0002\u001fs_>$h(\u0003\u0002b\u0015\u00051\u0001K]3eK\u001aL!a\u00193\u0003\rM#(/\u001b8h\u0015\t\t'\u0002C\u0003g\u0001\u0011\u0005s-\u0001\u0005u_N#(/\u001b8h)\u0005Q\u0006\"B5\u0001\t\u0013Q\u0017!\u0002:fO\u0006\u0004H#A\u0013")
public class GapBuffer {
    private char[] _buffer;
    private int _gapStart;
    private int _gapEnd;

    private char[] _buffer() {
        return this._buffer;
    }

    private void _buffer_$eq(char[] x$1) {
        this._buffer = x$1;
    }

    private int _gapStart() {
        return this._gapStart;
    }

    private void _gapStart_$eq(int x$1) {
        this._gapStart = x$1;
    }

    private int _size() {
        return new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(this._buffer())).size();
    }

    private int _gapEnd() {
        return this._gapEnd;
    }

    private void _gapEnd_$eq(int x$1) {
        this._gapEnd = x$1;
    }

    private int gapSize() {
        return this._gapEnd() - this._gapStart();
    }

    public int cursor() {
        return this._gapStart();
    }

    public void cursor_$eq(int pos) {
        this.moveBy(pos - this.cursor());
    }

    public int bufferSize() {
        return this._size();
    }

    public int contentSize() {
        return this._size() - (this._gapEnd() - this._gapStart());
    }

    public void moveBy(int delta) {
        block3: {
            if (this._gapStart() + delta > this.contentSize() || this._gapStart() + delta < 0) {
                Integer arg$macro$60 = BoxesRunTime.boxToInteger((int)(this.cursor() + delta));
                throw new Exception(new StringOps("Cursor index out of buffer: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$60})));
            }
            if (delta == 0) break block3;
            int oldStart = this._gapStart();
            int oldEnd = this._gapEnd();
            this._gapStart_$eq(this._gapStart() + delta);
            this._gapEnd_$eq(package$.MODULE$.min(this._gapEnd() + delta, this._size()));
            if (delta > 0) {
                System.arraycopy(this._buffer(), oldEnd, this._buffer(), oldStart, delta);
            } else {
                System.arraycopy(this._buffer(), oldStart + delta, this._buffer(), oldEnd + delta, -delta);
            }
            this.regap();
        }
    }

    public void insert(char c) {
        this._buffer()[this._gapStart()] = c;
        this._gapStart_$eq(this._gapStart() + 1);
        this.regap();
    }

    public void insert(String s) {
        this.loop$1(s);
    }

    public String toString() {
        String string;
        if (this.gapSize() == 0) {
            string = new String(this._buffer());
        } else {
            String start = new String(this._buffer(), 0, this._gapStart());
            String end = new String(this._buffer(), this._gapEnd(), this._size() - this._gapEnd());
            string = start + end;
        }
        return string;
    }

    private void regap() {
        block1: {
            if (this.gapSize() != 0) break block1;
            int newSize = (int)package$.MODULE$.min((long)this._size() * 3L / 2L, Integer.MAX_VALUE);
            if (newSize == this._size()) {
                throw new Exception("Buffer is full");
            }
            char[] newBuffer = (char[])Array$.MODULE$.ofDim(newSize, ClassTag$.MODULE$.Char());
            int endLength = this._size() - this._gapEnd();
            System.arraycopy(this._buffer(), 0, newBuffer, 0, this._gapStart());
            System.arraycopy(this._buffer(), this._gapEnd(), newBuffer, newSize - endLength, endLength);
            this._gapEnd_$eq(newSize - endLength);
            this._buffer_$eq(newBuffer);
        }
    }

    private final void loop$1(String s) {
        while (true) {
            if (new StringOps(Predef$.MODULE$.augmentString(s)).size() <= this.gapSize()) break;
            int size = this.gapSize();
            s.getChars(0, size, this._buffer(), this._gapStart());
            this._gapStart_$eq(this._gapStart() + size);
            this.regap();
            s = s.substring(size);
        }
        s.getChars(0, new StringOps(Predef$.MODULE$.augmentString(s)).size(), this._buffer(), this._gapStart());
        this._gapStart_$eq(this._gapStart() + new StringOps(Predef$.MODULE$.augmentString(s)).size());
        this.regap();
    }

    public GapBuffer(int initialSize) {
        this._buffer = (char[])Array$.MODULE$.ofDim(initialSize, ClassTag$.MODULE$.Char());
        this._gapStart = 0;
        this._gapEnd = this._size();
    }
}

