/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.ext.com.beust.jcommander;

import gw.internal.ext.com.beust.jcommander.ParameterException;
import gw.internal.ext.com.beust.jcommander.internal.Maps;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FuzzyMap {
    public static <V> V findInMap(Map<? extends IKey, V> map, IKey name, boolean caseSensitive, boolean allowAbbreviations) {
        if (allowAbbreviations) {
            return FuzzyMap.findAbbreviatedValue(map, name, caseSensitive);
        }
        if (caseSensitive) {
            return map.get(name);
        }
        for (IKey iKey : map.keySet()) {
            if (!iKey.getName().equalsIgnoreCase(name.getName())) continue;
            return map.get(iKey);
        }
        return null;
    }

    private static <V> V findAbbreviatedValue(Map<? extends IKey, V> map, IKey name, boolean caseSensitive) {
        String string = name.getName();
        Map<String, V> results = Maps.newHashMap();
        for (IKey iKey : map.keySet()) {
            String n = iKey.getName();
            boolean match = caseSensitive && n.startsWith(string) || !caseSensitive && n.toLowerCase().startsWith(string.toLowerCase());
            if (!match) continue;
            results.put(n, map.get(iKey));
        }
        if (results.size() > 1) {
            throw new ParameterException("Ambiguous option: " + name + " matches " + results.keySet());
        }
        V result = results.size() == 1 ? (V)results.values().iterator().next() : null;
        return result;
    }

    static interface IKey {
        public String getName();
    }
}

