/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.components;

import org.apache.commons.lang3.StringUtils;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.PropertyOverrides;
import org.apache.tapestry5.Renderable;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.apache.tapestry5.services.ClientBehaviorSupport;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@SupportsInformalParameters
public class CarouselItem
implements ClientElement {
    @Property
    @Parameter(value="75", defaultPrefix="literal")
    private int width;
    @Property
    @Parameter(value="75", defaultPrefix="literal")
    private int height;
    @Property
    @Parameter(defaultPrefix="prop")
    private String imageSource;
    @Property
    @Parameter(defaultPrefix="literal")
    private String page;
    @Property
    @Parameter(defaultPrefix="literal")
    private String event;
    @Property
    @Parameter(allowNull=true, defaultPrefix="prop")
    private Object context;
    @Property
    @Parameter(defaultPrefix="literal")
    private String zone;
    @Parameter(value="this")
    private PropertyOverrides overrides;
    @Inject
    private ComponentResources componentResources;
    @Inject
    private JavaScriptSupport javaScriptSupport;
    @Inject
    private PageRenderLinkSource pageRenderLink;
    private String clientId;
    private boolean isPageLink;
    private boolean isEventLink;
    private Link url;
    private Block override;
    @Inject
    private ClientBehaviorSupport clientSupport;
    Renderable defaultBlock = new Renderable(){

        public void render(MarkupWriter writer) {
            if (CarouselItem.this.isPageLink) {
                writer.element("a", new Object[]{"href", CarouselItem.this.url.toURI()});
            } else if (CarouselItem.this.isEventLink) {
                writer.element("a", new Object[]{"href", CarouselItem.this.url.toURI(), "id", CarouselItem.this.clientId});
                if (CarouselItem.this.zone != null) {
                    writer.attributes(new Object[]{"data-update-zone", CarouselItem.this.zone});
                }
            }
            writer.element("img", new Object[]{"src", CarouselItem.this.imageSource, "height", CarouselItem.this.height + "px", "width", CarouselItem.this.width + "px"});
            CarouselItem.this.componentResources.renderInformalParameters(writer);
            writer.end();
        }
    };

    public boolean isPagelink() {
        return StringUtils.isNotEmpty((CharSequence)this.page);
    }

    public boolean isEventlink() {
        return StringUtils.isNotEmpty((CharSequence)this.event);
    }

    void setupRender() {
        this.override = this.overrides.getOverrideBlock("item");
        if (this.override == null && !this.componentResources.isBound("imageSource")) {
            throw new TapestryException("The imageSource parameter is not bound! ", (Object)this, null);
        }
        this.clientId = this.javaScriptSupport.allocateClientId(this.componentResources);
        this.isPageLink = StringUtils.isNotEmpty((CharSequence)this.page);
        this.isEventLink = StringUtils.isNotEmpty((CharSequence)this.event);
        this.url = null;
        if (this.isPageLink) {
            this.url = this.context != null ? this.pageRenderLink.createPageRenderLinkWithContext(this.page, new Object[]{this.context}) : this.pageRenderLink.createPageRenderLinkWithContext(this.page, new Object[0]);
        } else if (this.isEventLink) {
            this.url = this.context != null ? this.componentResources.createEventLink(this.event, new Object[]{this.context}) : this.componentResources.createEventLink(this.event, new Object[0]);
        }
    }

    Object beginRender(MarkupWriter w) {
        w.element("li", new Object[0]);
        return this.override != null ? this.override : this.defaultBlock;
    }

    void afterRender(MarkupWriter writer) {
        if (this.isPageLink || this.isEventLink) {
            writer.end();
        }
        writer.end();
    }

    public String getClientId() {
        return this.clientId;
    }
}

