/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.PropertyConduit;
import org.apache.tapestry5.PropertyOverrides;
import org.apache.tapestry5.Translator;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.grid.ColumnSort;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.grid.GridSortModel;
import org.apache.tapestry5.grid.SortConstraint;
import org.apache.tapestry5.internal.grid.CollectionGridDataSource;
import org.apache.tapestry5.internal.services.AjaxPartialResponseRenderer;
import org.apache.tapestry5.internal.services.PageRenderQueue;
import org.apache.tapestry5.internal.services.ajax.AjaxFormUpdateController;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.runtime.RenderCommand;
import org.apache.tapestry5.runtime.RenderQueue;
import org.apache.tapestry5.services.PartialMarkupRenderer;
import org.apache.tapestry5.services.PartialMarkupRendererFilter;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.TranslatorSource;
import org.got5.tapestry5.jquery.internal.DataTableModel;
import org.got5.tapestry5.jquery.internal.FakeInheritedBinding;

public class DefaultDataTableModel
implements DataTableModel {
    private TypeCoercer typeCoercer;
    private Request request;
    private GridSortModel sortModel;
    private BeanModel model;
    private PropertyOverrides overrides;
    private TranslatorSource translatorSource;
    private PageRenderQueue pageRenderQueue;
    private AjaxFormUpdateController ajaxFormUpdateController;
    private AjaxPartialResponseRenderer partialRenderer;
    private JSONObject response;
    JSONArray rows;
    private final FakeInheritedBinding rowParam;
    private final FakeInheritedBinding rowIndexParam;

    public DefaultDataTableModel(TypeCoercer typeCoercer, TranslatorSource translatorSource, PageRenderQueue pageRenderQueue, AjaxFormUpdateController ajaxFormUpdateController, AjaxPartialResponseRenderer partialRenderer, FakeInheritedBinding row, FakeInheritedBinding rowIndex) {
        this.typeCoercer = typeCoercer;
        this.translatorSource = translatorSource;
        this.pageRenderQueue = pageRenderQueue;
        this.ajaxFormUpdateController = ajaxFormUpdateController;
        this.partialRenderer = partialRenderer;
        this.rowParam = row;
        this.rowIndexParam = rowIndex;
        this.response = new JSONObject();
        this.rows = new JSONArray();
    }

    public GridDataSource filterData(GridDataSource source) {
        ArrayList<Object> datas = new ArrayList<Object>();
        for (int index = 0; index < source.getAvailableRows(); ++index) {
            boolean flag = false;
            for (Object name : this.model.getPropertyNames()) {
                PropertyConduit conduit = this.model.get((String)name).getConduit();
                try {
                    String val = (String)conduit.get(source.getRowValue(index));
                    if (!val.contains(this.request.getParameter("sSearch"))) continue;
                    flag = true;
                }
                catch (Exception e) {}
            }
            if (!flag) continue;
            datas.add(source.getRowValue(index));
        }
        return new CustomGridDataSource(datas);
    }

    public void prepareResponse(GridDataSource source) {
        String sortingCols = this.request.getParameter("iSortingCols");
        if (InternalUtils.isNonBlank((String)sortingCols)) {
            int indexProperty;
            List names;
            String propName;
            ColumnSort colSort;
            int nbSortingCols = Integer.parseInt(sortingCols);
            String sord = this.request.getParameter("sSortDir_0");
            String sidx = this.request.getParameter("iSortCol_0");
            if (!(nbSortingCols <= 0 || InternalUtils.isNonBlank((String)(colSort = this.sortModel.getColumnSort(propName = (String)(names = this.model.getPropertyNames()).get(indexProperty = Integer.parseInt(sidx)))).name()) && colSort.name().startsWith(sord.toUpperCase()))) {
                this.sortModel.updateSort(propName);
            }
        }
    }

    public JSONObject getResponse(GridDataSource source) throws IOException {
        String displayLength;
        int rowsPerPage;
        final String sEcho = this.request.getParameter("sEcho");
        final int records = source.getAvailableRows();
        if (records == 0) {
            this.response.put("sEcho", (Object)sEcho);
            this.response.put("iTotalDisplayRecords", (Object)records);
            this.response.put("iTotalRecords", (Object)records);
            this.response.put("aaData", (Object)this.rows);
            return this.response;
        }
        String displayStart = this.request.getParameter("iDisplayStart");
        int startIndex = Integer.parseInt(displayStart);
        int endIndex = startIndex + (rowsPerPage = Integer.parseInt(displayLength = this.request.getParameter("iDisplayLength"))) - 1;
        if (endIndex > records - 1) {
            endIndex = records - 1;
        }
        source.prepare(startIndex, endIndex, this.sortModel.getSortConstraints());
        this.pageRenderQueue.addPartialMarkupRendererFilter(new PartialMarkupRendererFilter(){

            public void renderMarkup(MarkupWriter writer, JSONObject reply, PartialMarkupRenderer renderer) {
                reply.put("aaData", (Object)DefaultDataTableModel.this.rows);
                reply.put("sEcho", (Object)sEcho);
                reply.put("iTotalDisplayRecords", (Object)records);
                reply.put("iTotalRecords", (Object)records);
                renderer.renderMarkup(writer, reply);
            }
        });
        for (int index = startIndex; index <= endIndex; ++index) {
            JSONObject cell = new JSONObject();
            this.rows.put((Object)cell);
            Object obj = source.getRowValue(index);
            List names = this.model.getPropertyNames();
            int rowIndex = index % rowsPerPage;
            int columnIndex = 0;
            for (String name : names) {
                Block override = this.overrides.getOverrideBlock(name + "Cell");
                if (override != null) {
                    this.addPartialMarkupRendererFilter(override, source.getRowType(), obj, name, rowIndex, columnIndex, index);
                } else {
                    String val;
                    PropertyConduit conduit = this.model.get(name).getConduit();
                    String string = val = conduit.get(obj) != null ? conduit.get(obj) : "";
                    if (!String.class.equals(this.model.get(name).getClass()) && !Number.class.isAssignableFrom(this.model.get(name).getClass())) {
                        Translator translator = this.translatorSource.findByType(this.model.get(name).getPropertyType());
                        val = translator != null ? translator.toClient((Object)val) : val.toString();
                    }
                    this.addPartialMarkupRendererFilter(val, source.getRowType(), obj, name, rowIndex, columnIndex, index);
                }
                ++columnIndex;
            }
        }
        this.partialRenderer.renderPartialPageMarkup();
        this.rows = new JSONArray();
        return new JSONObject();
    }

    public JSONObject sendResponse(Request request, GridDataSource source, BeanModel model, GridSortModel sortModel, PropertyOverrides overrides, boolean mode) throws IOException {
        this.request = request;
        this.sortModel = sortModel;
        this.model = model;
        this.overrides = overrides;
        CustomGridDataSource s = new CustomGridDataSource(source);
        if (!mode && InternalUtils.isNonBlank((String)request.getParameter("sSearch"))) {
            s = this.filterData(source);
        }
        this.prepareResponse(s);
        return this.getResponse(s);
    }

    public void addPartialMarkupRendererFilter(final Object override, Class type, final Object value, final String columnName, final int rowIndex, int columnIndex, final int globalIndex) {
        final RenderCommand renderCommand = (RenderCommand)this.typeCoercer.coerce(override, RenderCommand.class);
        this.pageRenderQueue.addPartialMarkupRendererFilter(new PartialMarkupRendererFilter(){

            public void renderMarkup(MarkupWriter writer, JSONObject reply, PartialMarkupRenderer renderer) {
                RenderCommand forZone = new RenderCommand(){

                    public void render(MarkupWriter writer, RenderQueue queue) {
                        final Element zoneContainer = writer.element("ajax-partial", new Object[0]);
                        DefaultDataTableModel.this.ajaxFormUpdateController.setupBeforePartialZoneRender(writer);
                        DefaultDataTableModel.this.rowParam.set(value);
                        DefaultDataTableModel.this.rowIndexParam.set(globalIndex);
                        queue.push(new RenderCommand(){

                            public void render(MarkupWriter writer, RenderQueue queue) {
                                writer.end();
                                DefaultDataTableModel.this.ajaxFormUpdateController.cleanupAfterPartialZoneRender();
                                String zoneUpdateContent = zoneContainer.getChildMarkup();
                                if (DefaultDataTableModel.this.rows.length() <= rowIndex) {
                                    for (int i = 0; i < rowIndex + 1; ++i) {
                                        DefaultDataTableModel.this.rows.put((Object)new JSONObject());
                                    }
                                }
                                if (!(override instanceof Block)) {
                                    if (DefaultDataTableModel.this.rows.length() > rowIndex) {
                                        DefaultDataTableModel.this.rows.getJSONObject(rowIndex).put(columnName, override);
                                    }
                                } else if (DefaultDataTableModel.this.rows.length() > rowIndex) {
                                    DefaultDataTableModel.this.rows.getJSONObject(rowIndex).put(columnName, (Object)zoneUpdateContent);
                                }
                                zoneContainer.remove();
                            }
                        });
                        queue.push(renderCommand);
                    }
                };
                DefaultDataTableModel.this.pageRenderQueue.addPartialRenderer(forZone);
                renderer.renderMarkup(writer, reply);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CustomGridDataSource
    implements GridDataSource {
        private List<Object> datas;
        private CollectionGridDataSource cgds;

        public CustomGridDataSource(List<Object> datas) {
            this.datas = datas;
            this.cgds = new CollectionGridDataSource(datas);
        }

        public CustomGridDataSource(GridDataSource gds) {
            this.datas = new ArrayList<Object>();
            for (int i = 0; i < gds.getAvailableRows(); ++i) {
                this.datas.add(gds.getRowValue(i));
            }
            this.cgds = new CollectionGridDataSource(this.datas);
        }

        public void prepare(int startIndex, int endIndex, List<SortConstraint> sortConstraints) {
            for (SortConstraint constraint : sortConstraints) {
                final ColumnSort sort = constraint.getColumnSort();
                String name = constraint.getPropertyModel().getPropertyName();
                final PropertyConduit conduit = DefaultDataTableModel.this.model.get(name).getConduit();
                if (sort == ColumnSort.UNSORTED || conduit == null) continue;
                final Comparator<Comparable> valueComparator = new Comparator<Comparable>(){

                    @Override
                    public int compare(Comparable o1, Comparable o2) {
                        if (o1 == o2) {
                            return 0;
                        }
                        if (o2 == null) {
                            return 1;
                        }
                        if (o1 == null) {
                            return -1;
                        }
                        return o1.compareTo(o2);
                    }
                };
                final Comparator rowComparator = new Comparator(){

                    public int compare(Object row1, Object row2) {
                        Comparable value1 = (Comparable)conduit.get(row1);
                        Comparable value2 = (Comparable)conduit.get(row2);
                        return valueComparator.compare(value1, value2);
                    }
                };
                Comparator reverseComparator = new Comparator(){

                    public int compare(Object o1, Object o2) {
                        int modifier = sort == ColumnSort.ASCENDING ? 1 : -1;
                        return modifier * rowComparator.compare(o1, o2);
                    }
                };
                Collections.sort(this.datas, reverseComparator);
                this.cgds = new CollectionGridDataSource(this.datas);
            }
        }

        public Object getRowValue(int index) {
            return this.cgds.getRowValue(index);
        }

        public Class getRowType() {
            return this.cgds.getRowType();
        }

        public int getAvailableRows() {
            return this.cgds.getAvailableRows();
        }
    }
}

