/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.mixins;

import java.util.Map;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.annotations.InjectContainer;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

public class Bind {
    @Parameter(defaultPrefix="literal")
    private String element;
    @Parameter(defaultPrefix="literal")
    private String event;
    @Parameter(defaultPrefix="literal")
    private String hide;
    @Parameter(defaultPrefix="literal", value="slide")
    private String hideEffect;
    @Parameter(defaultPrefix="literal", value="500")
    private String hideTime;
    @Parameter
    private Map<String, String> hideOptions;
    @Parameter(defaultPrefix="literal")
    private String zone;
    @Parameter(defaultPrefix="literal", value="highlight")
    private String zoneUpdate;
    @Parameter(defaultPrefix="literal")
    private String callback;
    @Parameter
    private Object[] context;
    @Parameter(defaultPrefix="literal")
    private String title;
    @Parameter(defaultPrefix="literal")
    private String history;
    @Parameter(defaultPrefix="literal")
    private String eventType;
    @Parameter(value="true")
    private Boolean preventDefault;
    @Parameter(value="true")
    private Boolean doImports;
    @Parameter(value="CoNtExT", defaultPrefix="literal")
    private String contextMarker;
    @Inject
    private AssetSource assetSource;
    @Inject
    private JavaScriptSupport javaScriptSupport;
    @InjectContainer
    private ClientElement clientElement;
    @Inject
    private ComponentResources resources;

    String element() {
        if (this.element != null) {
            return this.element;
        }
        return this.clientElement.getClientId();
    }

    String eventType() {
        if (this.eventType != null) {
            return this.eventType;
        }
        return this.getClass().getSimpleName().toLowerCase();
    }

    String event() {
        return this.event;
    }

    Link createLink(String event, String marker) {
        ComponentResources parent = this.resources.getContainerResources().getContainerResources();
        Object[] o = this.context;
        if (this.callback != null) {
            if (o == null) {
                o = new Object[1];
            } else {
                o = new Object[o.length + 1];
                System.arraycopy(this.context, 0, o, 0, this.context.length);
            }
            o[o.length - 1] = marker;
        }
        return parent.createEventLink(event, o);
    }

    public void afterRender() {
        JSONObject spec = new JSONObject();
        spec.put("elementId", (Object)this.element());
        spec.put("eventType", (Object)this.eventType());
        if (this.event() != null) {
            spec.put("url", (Object)this.createLink(this.event(), this.contextMarker).toAbsoluteURI());
            spec.put("contextMarker", (Object)this.contextMarker);
        }
        spec.put("preventDefault", (Object)this.preventDefault);
        spec.put("hide", (Object)this.hide);
        spec.put("hideEffect", (Object)this.hideEffect);
        spec.put("hideTime", (Object)this.hideTime);
        if (this.hideOptions != null) {
            JSONObject joptions = new JSONObject();
            for (Map.Entry<String, String> o : this.hideOptions.entrySet()) {
                joptions.put(o.getKey(), (Object)o.getValue());
            }
            spec.put("hideOptions", (Object)joptions);
        }
        spec.put("zoneId", (Object)this.zone);
        spec.put("zoneUpdate", (Object)this.zoneUpdate);
        spec.put("title", (Object)this.title);
        spec.put("history", (Object)this.history);
        spec.put("callback", (Object)this.callback);
        this.javaScriptSupport.require("tjq/bind").with(new Object[]{spec});
    }

    private String findEffect(String effect) {
        if ((effect = effect.toUpperCase()).equals("BLIND")) {
            return "${jquery.ui.path}/jquery.ui.effect-blind.js";
        }
        if (effect.equals("BOUNCE")) {
            return "${jquery.ui.path}/jquery.ui.effect-bounce.js";
        }
        if (effect.equals("CLIP")) {
            return "${jquery.ui.path}/jquery.ui.effect-clip.js";
        }
        if (effect.equals("DROP")) {
            return "${jquery.ui.path}/jquery.ui.effect-drop.js";
        }
        if (effect.equals("EXPLODE")) {
            return "${jquery.ui.path}/jquery.ui.effect-explode.js";
        }
        if (effect.equals("FOLD")) {
            return "${jquery.ui.path}/jquery.ui.effect-fold.js";
        }
        if (effect.equals("HIGHLIGHT")) {
            return "${jquery.ui.path}/jquery.ui.effect-highlight.js";
        }
        if (effect.equals("PULSATE")) {
            return "${jquery.ui.path}/jquery.ui.effect-pulsate.js";
        }
        if (effect.equals("SCALE")) {
            return "${jquery.ui.path}/jquery.ui.effect-scale.js";
        }
        if (effect.equals("SHAKE")) {
            return "${jquery.ui.path}/jquery.ui.effect-shake.js";
        }
        if (effect.equals("SLIDE")) {
            return "${jquery.ui.path}/jquery.ui.effect-slide.js";
        }
        if (effect.equals("TRANSFER")) {
            return "${jquery.ui.path}/jquery.ui.effect-transfer.js";
        }
        return null;
    }
}

