/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.mixins;

import java.text.SimpleDateFormat;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.BindParameter;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.InjectContainer;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.ThreadLocale;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.javascript.InitializationPriority;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.got5.tapestry5.jquery.services.WidgetParams;
import org.got5.tapestry5.jquery.utils.JQueryUtils;

public class CustomDatepicker {
    @Parameter
    private JSONObject params;
    @Parameter
    private String selector;
    @Property
    private JSONObject defaultParamsObject;
    @InjectContainer
    private ClientElement element;
    @Environmental
    private JavaScriptSupport javaScriptSupport;
    @Inject
    private WidgetParams widgetParams;
    @Inject
    private ComponentResources componentResources;
    @Inject
    @Symbol(value="suppress.prototype")
    private Boolean supressPrototype;
    @Inject
    private ThreadLocale locale;
    @BindParameter
    private Object format;
    @Inject
    private AssetSource as;
    @Inject
    private TypeCoercer typeCoercer;

    void afterRender() {
        if (this.supressPrototype.booleanValue()) {
            String theSelector = this.componentResources.isBound("selector") ? this.selector : "#" + this.element.getClientId();
            this.defaultParamsObject = new JSONObject();
            JSONObject temp = this.widgetParams.paramsForWidget(this.getClass().getSimpleName().toLowerCase());
            if (temp != null) {
                this.defaultParamsObject = temp;
            }
            this.defaultParamsObject.put("dateFormat", (Object)this.toJQueryUIDateFormat());
            JQueryUtils.merge(this.defaultParamsObject, this.params);
            this.defaultParamsObject.put("selector", (Object)theSelector);
            JSONObject json = new JSONObject();
            json.put("selector", (Object)theSelector);
            json.put("params", (Object)this.defaultParamsObject);
            this.javaScriptSupport.require("tjq/customdatepicker").priority(InitializationPriority.EARLY).with(new Object[]{json});
        }
    }

    private String getLocale() {
        String prefix = String.format("classpath:/META-INF/modules/tjq/vendor/ui/i18n/jquery.ui.datepicker-%s", this.locale.getLocale().getLanguage());
        Resource withCountryExtension = (Resource)this.typeCoercer.coerce((Object)String.format("%s-%s.js", prefix, this.locale.getLocale().getCountry()), Resource.class);
        if (withCountryExtension.exists()) {
            return String.format("%s-%s", this.locale.getLocale().getLanguage(), this.locale.getLocale().getCountry());
        }
        Resource withLanguageExtension = (Resource)this.typeCoercer.coerce((Object)String.format("%s.js", prefix), Resource.class);
        if (withLanguageExtension.exists()) {
            return this.locale.getLocale().getLanguage();
        }
        return "en-GB";
    }

    private String toJQueryUIDateFormat() {
        if (this.format == null) {
            return null;
        }
        if (this.format instanceof SimpleDateFormat) {
            String pattern = ((SimpleDateFormat)this.format).toPattern();
            pattern = pattern.contains("yyyy") ? pattern.replaceAll("yyyy", "yy") : pattern.replaceAll("yy", "y");
            if (pattern.contains("MMMM")) {
                pattern = pattern.replace("MMMM", "MM");
            } else if (pattern.contains("MMM")) {
                pattern = pattern.replace("MMM", "M");
            } else if (pattern.contains("MM")) {
                pattern = pattern.replace("MM", "mm");
            } else if (pattern.contains("M")) {
                pattern = pattern.replace("M", "m");
            }
            if (pattern.contains("DD")) {
                pattern = pattern.replace("DD", "oo");
            } else if (pattern.contains("D")) {
                pattern = pattern.replace("D", "o");
            }
            if (pattern.contains("EEEE")) {
                pattern = pattern.replace("EEEE", "DD");
            } else if (pattern.contains("EEE")) {
                pattern = pattern.replace("EEE", "D");
            }
            return pattern;
        }
        throw new IllegalArgumentException("Type is " + this.format.getClass().getName());
    }
}

