/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.services.js;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Session;
import org.got5.tapestry5.jquery.services.js.JSLocator;
import org.slf4j.Logger;

public class JSLocatorImpl
implements JSLocator {
    private final Map<String, Content> scripts = new HashMap<String, Content>(1000);
    private final Logger logger;
    private final Request request;

    public JSLocatorImpl(Logger logger, Request request) {
        this.logger = logger;
        this.request = request;
        Session session = request.getSession(true);
    }

    public String store(String script) {
        String key = this.createKey(script);
        Content content = this.scripts.get(key);
        if (content != null) {
            content.reuse();
            return this.keyToUrl(key);
        }
        this.scripts.put(key, new Content(script));
        if (this.scripts.size() > 900) {
            this.flush();
        }
        return this.keyToUrl(key);
    }

    public String find(String path) {
        return this.scripts.get(path).getScript();
    }

    private synchronized void flush() {
        long time = new Date().getTime() - 300000L;
        ArrayList<String> remove = new ArrayList<String>(this.scripts.size());
        for (Map.Entry<String, Content> entry : this.scripts.entrySet()) {
            if (!entry.getValue().isExpired(time)) continue;
            remove.add(entry.getKey());
        }
        this.logger.info("size {} remove {}", (Object)this.scripts.size(), (Object)remove.size());
        for (String key : remove) {
            Content content = this.scripts.get(key);
            if (!content.isExpired(time)) continue;
            this.scripts.remove(key);
        }
    }

    private String createKey(String script) {
        return new String(Hex.encodeHex((byte[])DigestUtils.sha((String)script)));
    }

    public String keyToUrl(String key) {
        return String.format("%s/js/%s", this.request.getContextPath(), key);
    }

    class Content {
        private long date;
        private final String script;
        private boolean reused = false;

        Content(String script) {
            this.script = script;
            this.date = new Date().getTime();
        }

        boolean isExpired(long time) {
            if (this.reused && JSLocatorImpl.this.scripts.size() < 990) {
                return false;
            }
            return this.date < time;
        }

        String getScript() {
            return this.script;
        }

        void reuse() {
            this.date = new Date().getTime();
            this.reused = true;
        }
    }
}

