/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.components;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.ContextValueEncoder;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.javascript.JavaScriptStackSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.util.TextStreamResponse;
import org.got5.tapestry5.jquery.utils.JQueryUtils;

@SupportsInformalParameters
public class InPlaceEditor
implements ClientElement {
    public static final String SAVE_EVENT = "save";
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(required=true, principal=true)
    private String value;
    @Parameter(defaultPrefix="prop")
    private JSONObject options;
    @Parameter(required=false)
    private List<?> context;
    @Inject
    private ComponentResources resources;
    @Inject
    private Messages messages;
    @Environmental
    private JavaScriptSupport javascriptSupport;
    @Inject
    private Request request;
    @Inject
    private JavaScriptStackSource stacks;
    @Inject
    private AssetSource as;
    @Inject
    private ContextValueEncoder valueEncoder;
    private String assignedClientId;
    private Object[] contextArray;

    void setupRender() {
        this.assignedClientId = this.javascriptSupport.allocateClientId(this.clientId);
        this.contextArray = this.context == null ? new Object[]{} : this.context.toArray();
    }

    void beginRender(MarkupWriter writer) {
        writer.element("span", new Object[]{"id", this.getClientId()});
        if (this.value != null && this.value.length() > 0) {
            writer.write(this.value);
        } else {
            writer.writeRaw(this.messages.get("empty"));
        }
    }

    void afterRender(MarkupWriter writer) {
        Link link = this.resources.createEventLink("action", this.contextArray);
        JSONObject spec = new JSONObject();
        writer.end();
        spec.put("clientId", (Object)this.getClientId());
        spec.put("href", (Object)link.toURI());
        JSONObject opts = new JSONObject();
        opts.put("type", (Object)"text");
        opts.put("cancel", (Object)this.messages.get("cancelbutton"));
        opts.put("submit", (Object)this.messages.get("savebutton"));
        opts.put("tooltip", (Object)this.messages.get("tooltip"));
        JQueryUtils.merge(opts, this.options);
        spec.put("options", (Object)opts);
        this.javascriptSupport.require("tjq/inplaceeditor").with(new Object[]{spec});
    }

    StreamResponse onAction(EventContext eventContext) throws UnsupportedEncodingException {
        String valueText = this.request.getParameter("value");
        this.contextArray = Arrays.copyOf(eventContext.toStrings(), eventContext.getCount() + 1);
        this.contextArray[this.contextArray.length - 1] = valueText;
        this.resources.triggerEvent(SAVE_EVENT, this.contextArray, null);
        if (valueText == null || valueText.length() == 0) {
            valueText = this.messages.get("empty");
        }
        return new TextStreamResponse("text/html", valueText);
    }

    public String getClientId() {
        return this.assignedClientId;
    }
}

