/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.components;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.got5.tapestry5.jquery.utils.JQueryUtils;
import org.slf4j.Logger;

@Import(stylesheet={"${jquery.assets.root}/vendor/components/showsource/codemirror.css"})
public class ShowSource {
    @Parameter(defaultPrefix="literal")
    private String path;
    @Parameter(defaultPrefix="prop")
    private JSONObject specs;
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(defaultPrefix="literal")
    private String ext;
    @Parameter(value="0")
    private Integer beginLine;
    @Parameter
    private Integer endLine;
    private JSONObject defaultSpecs;
    @Inject
    private AssetSource assetSource;
    @Inject
    private Logger logger;
    @Inject
    private JavaScriptSupport support;
    @Inject
    @Symbol(value="demo-src-dir")
    private String srcDir;
    @Inject
    private ComponentResources componentResources;
    @Inject
    private Messages message;

    boolean setupRender() {
        if (!this.componentResources.isBound("path")) {
            this.logger.warn("You have to specify a path for the showSource component");
            return false;
        }
        if (this.componentResources.isBound("endLine") && this.endLine < this.beginLine) {
            this.logger.warn("The endLine parameter has to be greater than beginLine");
            return false;
        }
        this.defaultSpecs = new JSONObject();
        if (this.beginLine > 0) {
            this.defaultSpecs.put("firstLineNumber", (Object)this.beginLine);
        }
        this.defaultSpecs.put("readOnly", (Object)true);
        this.defaultSpecs.put("lineNumbers", (Object)true);
        this.defaultSpecs.put("clipboard", (Object)this.assetSource.getUnlocalizedAsset("META-INF/modules/tjq/source.js").toClientURL());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSrcContent() {
        StringBuilder builder = new StringBuilder();
        FileInputStream is = null;
        File file = null;
        String rootSrc = InternalUtils.isBlank((String)this.srcDir) ? String.format("%s%s", System.getProperty("user.dir"), "/src/test/") : this.srcDir;
        String pathFile = String.format("%s%s%s", rootSrc, File.separator, this.path);
        this.logger.info("The ShowSource Component displays the file : {}", (Object)pathFile);
        file = new File(pathFile);
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException fnfEx) {
            this.logger.error("Error file not found.");
        }
        if (is != null) {
            try {
                BufferedReader buffReader = new BufferedReader(new InputStreamReader(is));
                String line = buffReader.readLine();
                int numLine = 1;
                while (line != null) {
                    if (numLine >= this.beginLine) {
                        if (this.componentResources.isBound("endLine") && numLine > this.endLine) break;
                        builder.append(new String(new byte[]{13})).append(line);
                    }
                    ++numLine;
                    line = buffReader.readLine();
                }
                buffReader.close();
            }
            catch (IOException ioEx) {
                builder.append(ioEx.getMessage());
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return builder.toString();
    }

    public void afterRender() {
        JSONObject params = new JSONObject();
        params.put("id", (Object)this.getClientId());
        params.put("lang", (Object)this.getLanguage());
        params.put("beginLine", (Object)this.beginLine);
        JQueryUtils.merge(this.defaultSpecs, this.specs);
        params.put("options", (Object)this.defaultSpecs);
        this.support.require("tjq/source").with(new Object[]{params});
    }

    public String getLanguage() {
        if (this.componentResources.isBound("ext")) {
            return this.ext;
        }
        HashMap<String, String> langs = new HashMap<String, String>();
        langs.put("js", "javascript");
        langs.put("java", "javascript");
        langs.put("tml", "html");
        langs.put("html", "html");
        String extension = this.path.substring(this.path.lastIndexOf(46) + 1);
        return (String)langs.get(extension);
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getFilename() {
        return this.path.substring(this.path.lastIndexOf("/") + 1);
    }
}

