/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.components;

import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Path;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@SupportsInformalParameters
public class Superfish {
    @Parameter(defaultPrefix="literal")
    private String clientId;
    @Parameter
    private JSONObject params;
    @Parameter(defaultPrefix="literal")
    private boolean vertical;
    @Parameter(value="sf-menu", defaultPrefix="literal")
    private String classe;
    @Parameter
    private boolean supersubs;
    @Parameter
    private JSONObject supersubsParams;
    @Inject
    private ComponentResources componentResources;
    @Inject
    private JavaScriptSupport javaScriptSupport;
    @Inject
    @Path(value="${jquery.assets.root}/vendor/components/superfish/css/superfish-vertical.css")
    private Asset verticalAsset;
    @Inject
    @Path(value="${jquery.assets.root}/vendor/components/superfish/css/superfish-navbar.css")
    private Asset navBarAsset;
    @Inject
    @Path(value="${jquery.assets.root}/vendor/components/superfish/css/superfish.css")
    private Asset mainAsset;

    @SetupRender
    public void init(MarkupWriter w) {
        this.clientId = this.javaScriptSupport.allocateClientId(this.componentResources);
        this.javaScriptSupport.importStylesheet(this.mainAsset);
        String css = this.classe;
        if (this.componentResources.isBound("vertical")) {
            css = this.vertical ? css + " sf-vertical" : css + " sf-navbar";
            if (this.vertical) {
                this.javaScriptSupport.importStylesheet(this.verticalAsset);
            } else {
                this.javaScriptSupport.importStylesheet(this.navBarAsset);
            }
        }
        w.element("ul", new Object[]{"id", this.getClientId(), "class", css});
        this.componentResources.renderInformalParameters(w);
    }

    @AfterRender
    public void finish(MarkupWriter w) {
        w.end();
        JSONObject jso = new JSONObject();
        jso.put("id", (Object)this.getClientId());
        jso.put("classe", (Object)this.classe);
        jso.put("params", (Object)this.params);
        jso.put("supersubs", (Object)this.supersubs);
        jso.put("supersubsParams", (Object)this.supersubsParams);
        this.javaScriptSupport.require("tjq/mySuperfish").with(new Object[]{jso});
    }

    public String getClientId() {
        return this.clientId;
    }
}

