/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.components;

import java.util.ArrayList;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.PropertyOverrides;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.got5.tapestry5.jquery.base.AbstractExtendableComponent;
import org.got5.tapestry5.jquery.utils.JQueryTabData;
import org.got5.tapestry5.jquery.utils.JQueryUtils;

@SupportsInformalParameters
public class Tabs
extends AbstractExtendableComponent {
    @Property
    @Parameter
    private ArrayList<JQueryTabData> listTabData;
    @Parameter(required=true)
    @Property
    private int activePanelId;
    @Parameter(defaultPrefix="literal")
    private String tabs;
    @Property
    @Parameter(value="true", defaultPrefix="literal")
    private Boolean ajax;
    @Parameter
    private JSONObject params;
    @Parameter(value="this", allowNull=false)
    @Property(write=false)
    private PropertyOverrides overrides;
    @Inject
    private ComponentResources resources;
    @Inject
    private JavaScriptSupport javaScriptSupport;
    @Inject
    private AssetSource source;
    private String clientZoneId;
    @Property
    private JQueryTabData currentTabData;
    @Property
    private int currentPanelId;
    @Property
    private String tab;

    @SetupRender
    void setJSInit(MarkupWriter writer) {
        this.setDefaultMethod("tabs");
        writer.element("div", new Object[]{"id", this.getClientId()});
    }

    @AfterRender
    void declareTabs(MarkupWriter writer) {
        this.resources.renderInformalParameters(writer);
        writer.end();
        JSONObject data = new JSONObject();
        data.put("id", (Object)this.getClientId());
        if (this.params == null) {
            this.params = new JSONObject();
        }
        JSONObject defaults = new JSONObject();
        defaults.put("cache", (Object)false);
        defaults.put("selected", (Object)this.activePanelId);
        JQueryUtils.merge(defaults, this.params);
        data.put("params", (Object)defaults);
        this.javaScriptSupport.require("tjq/ui").invoke("tabs").with(new Object[]{data});
    }

    public String getClientZoneId() {
        this.clientZoneId = this.getClientId() + "-zone";
        return this.clientZoneId;
    }

    public void setClientZoneId(String id) {
        this.clientZoneId = id;
    }

    public Object[] getTabContext() {
        if (this.getOlderVersion()) {
            return new Object[]{this.currentTabData.getBlockName(), this.currentPanelId};
        }
        return new Object[]{this.tab, this.currentPanelId};
    }

    Object onSelectTab(String blockName, int panelIndex) {
        try {
            if (this.resources.isBound("activePanelId")) {
                this.activePanelId = panelIndex;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getOlderVersion()) {
            return this.resources.getContainer().getComponentResources().getBlock(blockName);
        }
        this.resources.triggerEvent("SelectTab", new Object[]{this.activePanelId}, null);
        return this.overrides.getOverrideBlock(blockName);
    }

    public Block getActiveBlock() {
        if (this.getOlderVersion()) {
            String blockName = this.ajax != false ? this.listTabData.get(this.activePanelId).getBlockName() : this.currentTabData.getBlockName();
            return this.resources.getContainer().getComponentResources().getBlock(blockName);
        }
        if (this.ajax.booleanValue()) {
            return this.overrides.getOverrideBlock(this.getTabs()[this.activePanelId]);
        }
        return this.overrides.getOverrideBlock(this.tab);
    }

    public boolean getOlderVersion() {
        return this.resources.isBound("listTabData");
    }

    public String[] getTabs() {
        return TapestryInternalUtils.splitAtCommas((String)this.tabs);
    }

    public String getTabTitle() {
        if (this.overrides.getOverrideMessages().contains(this.tab)) {
            return this.overrides.getOverrideMessages().get(this.tab);
        }
        return TapestryInternalUtils.toUserPresentable((String)this.tab);
    }
}

