/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.reachability.internal.index.artifacts;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.graalvm.reachability.DirectoryConfiguration;
import org.graalvm.reachability.internal.UncheckedIOException;
import org.graalvm.reachability.internal.index.artifacts.Artifact;
import org.graalvm.reachability.internal.index.artifacts.VersionToConfigDirectoryIndex;

public class SingleModuleJsonVersionToConfigDirectoryIndex
implements VersionToConfigDirectoryIndex {
    private final Path moduleRoot;
    private final Map<String, List<Artifact>> index;

    public SingleModuleJsonVersionToConfigDirectoryIndex(Path moduleRoot) {
        this.moduleRoot = moduleRoot;
        this.index = this.parseIndexFile(moduleRoot);
    }

    private Map<String, List<Artifact>> parseIndexFile(Path rootPath) {
        Path indexFile = rootPath.resolve("index.json");
        try {
            String fileContent = Files.readString(indexFile);
            JSONArray json = new JSONArray(fileContent);
            ArrayList<Artifact> entries = new ArrayList<Artifact>();
            for (int i = 0; i < json.length(); ++i) {
                entries.add(this.fromJson(json.getJSONObject(i)));
            }
            return entries.stream().collect(Collectors.groupingBy(Artifact::getModule));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Optional<DirectoryConfiguration> findConfiguration(String groupId, String artifactId, String version) {
        Optional<DirectoryConfiguration> exactMatch = this.findConfigurationFor(groupId, artifactId, version, artifact -> artifact.getVersions().contains(version));
        return exactMatch.isPresent() ? exactMatch : this.findConfigurationFor(groupId, artifactId, version, artifact -> artifact.isDefaultFor(version));
    }

    @Override
    @Deprecated
    public Optional<DirectoryConfiguration> findLatestConfigurationFor(String groupId, String artifactId) {
        return this.findConfigurationFor(groupId, artifactId, null, Artifact::isLatest);
    }

    @Override
    public Optional<DirectoryConfiguration> findLatestConfigurationFor(String groupId, String artifactId, String version) {
        Optional<DirectoryConfiguration> defaultMatch = this.findConfigurationFor(groupId, artifactId, version, artifact -> artifact.isDefaultFor(version));
        return defaultMatch.isPresent() ? defaultMatch : this.findConfigurationFor(groupId, artifactId, version, Artifact::isLatest);
    }

    private Optional<DirectoryConfiguration> findConfigurationFor(String groupId, String artifactId, String version, Predicate<? super Artifact> predicate) {
        String module = groupId + ":" + artifactId;
        List<Artifact> artifacts = this.index.get(module);
        if (artifacts == null) {
            return Optional.empty();
        }
        return artifacts.stream().filter(artifact -> artifact.getModule().equals(module)).filter(predicate).findFirst().map(artifact -> new DirectoryConfiguration(groupId, artifactId, version, this.moduleRoot.resolve(artifact.getDirectory()), artifact.isOverride()));
    }

    private Artifact fromJson(JSONObject json) {
        String module = json.optString("module", null);
        Set<String> testVersions = this.readTestedVersions(json.optJSONArray("tested-versions"));
        String directory = json.optString("metadata-version", null);
        boolean latest = json.optBoolean("latest");
        boolean override = json.optBoolean("override");
        String defaultFor = json.optString("default-for", null);
        return new Artifact(module, testVersions, directory, latest, override, defaultFor);
    }

    private Set<String> readTestedVersions(JSONArray array) {
        LinkedHashSet<String> testVersions = new LinkedHashSet<String>();
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                testVersions.add(array.getString(i));
            }
        }
        return testVersions;
    }
}

