/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.reachability.internal.index.artifacts;

import java.util.Set;
import java.util.regex.Pattern;

public class Artifact {
    private final String module;
    private final Set<String> versions;
    private final String directory;
    private final boolean latest;
    private final boolean override;
    private final Pattern defaultForPattern;

    public Artifact(String module, Set<String> versions, String directory, boolean latest, boolean override, String defaultFor) {
        this.module = module;
        this.versions = versions;
        this.directory = directory;
        this.latest = latest;
        this.override = override;
        this.defaultForPattern = defaultFor == null ? null : Pattern.compile(defaultFor);
    }

    public String getModule() {
        return this.module;
    }

    public Set<String> getVersions() {
        return this.versions;
    }

    public String getDirectory() {
        return this.directory;
    }

    public boolean isLatest() {
        return this.latest;
    }

    public boolean isOverride() {
        return this.override;
    }

    public boolean isDefaultFor(String version) {
        return this.defaultForPattern != null && this.defaultForPattern.matcher(version).matches();
    }
}

