/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.reachability.internal.index.artifacts;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.graalvm.reachability.DirectoryConfiguration;
import org.graalvm.reachability.internal.UncheckedIOException;
import org.graalvm.reachability.internal.index.artifacts.Artifact;
import org.graalvm.reachability.internal.index.artifacts.VersionToConfigDirectoryIndex;

public class SingleModuleJsonVersionToConfigDirectoryIndex
implements VersionToConfigDirectoryIndex {
    private final Path moduleRoot;
    private final Map<String, List<Artifact>> index;

    public SingleModuleJsonVersionToConfigDirectoryIndex(Path moduleRoot) {
        this.moduleRoot = moduleRoot;
        this.index = this.parseIndexFile(moduleRoot);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, List<Artifact>> parseIndexFile(Path rootPath) {
        Path indexFile = rootPath.resolve("index.json");
        ObjectMapper objectMapper = new ObjectMapper();
        TypeFactory typeFactory = objectMapper.getTypeFactory();
        try (BufferedReader reader = Files.newBufferedReader(indexFile);){
            List entries = (List)objectMapper.readValue((Reader)reader, (JavaType)typeFactory.constructCollectionType(List.class, Artifact.class));
            Map<String, List<Artifact>> map = entries.stream().collect(Collectors.groupingBy(Artifact::getModule));
            return map;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Optional<DirectoryConfiguration> findConfiguration(String groupId, String artifactId, String version) {
        return this.findConfigurationFor(groupId, artifactId, version, artifact -> artifact.getVersions().contains(version));
    }

    @Override
    @Deprecated
    public Optional<DirectoryConfiguration> findLatestConfigurationFor(String groupId, String artifactId) {
        return this.findConfigurationFor(groupId, artifactId, null, Artifact::isLatest);
    }

    @Override
    public Optional<DirectoryConfiguration> findLatestConfigurationFor(String groupId, String artifactId, String version) {
        return this.findConfigurationFor(groupId, artifactId, version, Artifact::isLatest);
    }

    private Optional<DirectoryConfiguration> findConfigurationFor(String groupId, String artifactId, String version, Predicate<? super Artifact> predicate) {
        String module = groupId + ":" + artifactId;
        List<Artifact> artifacts = this.index.get(module);
        if (artifacts == null) {
            return Optional.empty();
        }
        return artifacts.stream().filter(artifact -> artifact.getModule().equals(module)).filter(predicate).findFirst().map(artifact -> new DirectoryConfiguration(groupId, artifactId, version, this.moduleRoot.resolve(artifact.getDirectory()), artifact.isOverride()));
    }
}

