/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.junit.platform;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.junit.platform.NativeImageConfigurationImpl;
import org.graalvm.junit.platform.NativeImageJUnitLauncher;
import org.graalvm.junit.platform.config.core.PluginConfigProvider;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;

public final class JUnitPlatformFeature
implements Feature {
    public final boolean debug = System.getProperty("debug") != null;
    private static final NativeImageConfigurationImpl nativeImageConfigImpl = new NativeImageConfigurationImpl();
    private final ServiceLoader<PluginConfigProvider> extensionConfigProviders = ServiceLoader.load(PluginConfigProvider.class);

    public void duringSetup(Feature.DuringSetupAccess access) {
        this.forEachProvider(p -> p.onLoad(nativeImageConfigImpl));
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{NativeImageJUnitLauncher.class});
        List classpathRoots = access.getApplicationClassPath();
        List<? extends DiscoverySelector> selectors = this.getSelectors(classpathRoots);
        Launcher launcher = LauncherFactory.create();
        TestPlan testplan = this.discoverTestsAndRegisterTestClassesForReflection(launcher, selectors);
        ImageSingletons.add(NativeImageJUnitLauncher.class, (Object)new NativeImageJUnitLauncher(launcher, testplan));
    }

    private List<? extends DiscoverySelector> getSelectors(List<Path> classpathRoots) {
        try {
            Path outputDir = Paths.get(System.getProperty("junit.platform.listeners.uid.tracking.output.dir"), new String[0]);
            String prefix = System.getProperty("junit.platform.listeners.uid.tracking.output.file.prefix", "junit-platform-unique-ids");
            List selectors = this.readAllFiles(outputDir, prefix).map(DiscoverySelectors::selectUniqueId).collect(Collectors.toList());
            if (!selectors.isEmpty()) {
                System.out.printf("[junit-platform-native] Running in 'test listener' mode using files matching pattern [%s*] found in folder [%s] and its subfolders.%n", prefix, outputDir.toAbsolutePath());
                return selectors;
            }
        }
        catch (Exception ex) {
            JUnitPlatformFeature.debug("Failed to read UIDs from UniqueIdTrackingListener output files: " + ex.getMessage(), new Object[0]);
        }
        System.out.println("[junit-platform-native] Running in 'test discovery' mode. Note that this is a fallback mode.");
        if (this.debug) {
            classpathRoots.forEach(entry -> JUnitPlatformFeature.debug("Selecting classpath root: " + entry, new Object[0]));
        }
        return DiscoverySelectors.selectClasspathRoots(new HashSet<Path>(classpathRoots));
    }

    private TestPlan discoverTestsAndRegisterTestClassesForReflection(Launcher launcher, List<? extends DiscoverySelector> selectors) {
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(selectors).build();
        TestPlan testPlan = launcher.discover(request);
        testPlan.getRoots().stream().flatMap(rootIdentifier -> testPlan.getDescendants(rootIdentifier).stream()).map(TestIdentifier::getSource).filter(Optional::isPresent).map(Optional::get).filter(ClassSource.class::isInstance).map(ClassSource.class::cast).map(ClassSource::getJavaClass).forEach(this::registerTestClassForReflection);
        return testPlan;
    }

    private void registerTestClassForReflection(Class<?> clazz) {
        JUnitPlatformFeature.debug("Registering test class for reflection: %s", clazz.getName());
        nativeImageConfigImpl.registerAllClassMembersForReflection(clazz);
        this.forEachProvider(p -> p.onTestClassRegistered(clazz, nativeImageConfigImpl));
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            this.registerTestClassForReflection(superClass);
        }
    }

    private void forEachProvider(Consumer<PluginConfigProvider> consumer) {
        for (PluginConfigProvider provider : this.extensionConfigProviders) {
            consumer.accept(provider);
        }
    }

    public static void debug(String format, Object ... args) {
        if (JUnitPlatformFeature.debug()) {
            System.out.printf("[Debug] " + format + "%n", args);
        }
    }

    public static boolean debug() {
        return ((JUnitPlatformFeature)ImageSingletons.lookup(JUnitPlatformFeature.class)).debug;
    }

    private Stream<String> readAllFiles(Path dir, String prefix) throws IOException {
        return JUnitPlatformFeature.findFiles(dir, prefix).map(outputFile -> {
            try {
                return Files.readAllLines(outputFile);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }).flatMap(Collection::stream);
    }

    private static Stream<Path> findFiles(Path dir, String prefix) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            return Stream.empty();
        }
        return Files.find(dir, Integer.MAX_VALUE, (path, basicFileAttributes) -> basicFileAttributes.isRegularFile() && path.getFileName().toString().startsWith(prefix), new FileVisitOption[0]);
    }
}

