/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.junit.platform.config.vintage;

import java.lang.reflect.Field;
import org.graalvm.junit.platform.JUnitPlatformFeature;
import org.graalvm.junit.platform.config.core.NativeImageConfiguration;
import org.graalvm.junit.platform.config.core.PluginConfigProvider;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.hosted.RuntimeSerialization;

public class VintageConfigProvider
extends PluginConfigProvider {
    @Override
    public void onLoad(NativeImageConfiguration config) {
        try {
            RuntimeSerialization.register((Class[])Class.forName("org.junit.runner.Result").getDeclaredClasses());
            RuntimeReflection.register((Field[])Class.forName("org.junit.runner.Description").getDeclaredFields());
        }
        catch (ClassNotFoundException e) {
            JUnitPlatformFeature.debug("Cannot register declared classes of org.junit.runner.Result for serialization or fields of org.junit.runner.Description for reflection. Vintage JUnit not available.", new Object[0]);
        }
    }

    @Override
    public void onTestClassRegistered(Class<?> testClass, NativeImageConfiguration registry) {
        this.registerAnnotationClassesForReflection(testClass, "org.junit.runner.RunWith", "value");
        this.registerAnnotationClassesForReflection(testClass, "org.junit.runners.Parameterized.UseParametersRunnerFactory", "value");
    }

    private void registerAnnotationClassesForReflection(Class<?> testClass, String annotationName, String annotationElementName) {
        Class annotationArgument = (Class)this.getAnnotationElementValue(testClass, annotationName, annotationElementName);
        if (annotationArgument != null) {
            this.nativeImageConfigImpl.registerAllClassMembersForReflection(annotationArgument);
        }
    }
}

