/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.junit.platform;

import java.io.PrintWriter;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedList;
import org.graalvm.junit.platform.PrintTestExecutionListener;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ImageSingletons;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import org.junit.platform.reporting.legacy.xml.LegacyXmlReportGeneratingListener;

public class NativeImageJUnitLauncher {
    static final String DEFAULT_OUTPUT_FOLDER = Paths.get("test-results-native", new String[0]).resolve("test").toString();
    final Launcher launcher;
    final TestPlan testPlan;

    public NativeImageJUnitLauncher(Launcher launcher, TestPlan testPlan) {
        this.launcher = launcher;
        this.testPlan = testPlan;
    }

    public void registerTestExecutionListeners(TestExecutionListener testExecutionListener) {
        this.launcher.registerTestExecutionListeners(new TestExecutionListener[]{testExecutionListener});
    }

    public void execute() {
        this.launcher.execute(this.testPlan, new TestExecutionListener[0]);
    }

    static String stringPad(String input) {
        return String.format("%1$-20s", input);
    }

    public static void main(String ... args) {
        if (!ImageInfo.inImageCode()) {
            System.err.println("NativeImageJUnitLauncher can only be used for native-image compiled tests.");
            System.exit(1);
        }
        String xmlOutput = DEFAULT_OUTPUT_FOLDER;
        boolean silent = false;
        LinkedList<String> arguments = new LinkedList<String>(Arrays.asList(args));
        block10: while (!arguments.isEmpty()) {
            String arg;
            switch (arg = arguments.poll()) {
                case "--help": {
                    System.out.println("JUnit Platform launcher for GraalVM Native Image");
                    System.out.println("----------------------------------------\n");
                    System.out.println("Flags:");
                    System.out.println(NativeImageJUnitLauncher.stringPad("--xml-output-dir") + "Selects report xml output directory (default: `" + DEFAULT_OUTPUT_FOLDER + "`)");
                    System.out.println(NativeImageJUnitLauncher.stringPad("--silent") + "Only output xml without stdout summary");
                    System.out.println(NativeImageJUnitLauncher.stringPad("--help") + "Displays this help screen");
                    System.exit(0);
                    continue block10;
                }
                case "--xml-output-dir": {
                    xmlOutput = arguments.poll();
                    continue block10;
                }
                case "--silent": {
                    silent = true;
                    continue block10;
                }
            }
            System.err.println("Found unknown command line option: " + arg);
            System.exit(1);
        }
        PrintWriter out = new PrintWriter(System.out);
        NativeImageJUnitLauncher launcher = (NativeImageJUnitLauncher)ImageSingletons.lookup(NativeImageJUnitLauncher.class);
        if (!silent) {
            out.println("JUnit Platform on Native Image - report");
            out.println("----------------------------------------\n");
            out.flush();
            launcher.registerTestExecutionListeners(new PrintTestExecutionListener(out));
        }
        SummaryGeneratingListener summaryListener = new SummaryGeneratingListener();
        launcher.registerTestExecutionListeners((TestExecutionListener)summaryListener);
        launcher.registerTestExecutionListeners((TestExecutionListener)new LegacyXmlReportGeneratingListener(Paths.get(xmlOutput, new String[0]), out));
        launcher.execute();
        TestExecutionSummary summary = summaryListener.getSummary();
        if (!silent) {
            summary.printFailuresTo(out);
            summary.printTo(out);
        }
        long failedCount = summary.getTestsFailedCount() + summary.getTestsAbortedCount();
        System.exit((int)failedCount);
    }
}

