/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.junit.platform;

import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import org.graalvm.junit.platform.JUnitPlatformFeature;
import org.graalvm.junit.platform.config.core.NativeImageConfiguration;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

class NativeImageConfigurationImpl
implements NativeImageConfiguration {
    NativeImageConfigurationImpl() {
    }

    @Override
    public void registerForReflection(Class<?> ... classes) {
        RuntimeReflection.register((Class[])classes);
    }

    @Override
    public void registerForReflection(Executable ... methods) {
        RuntimeReflection.register((Executable[])methods);
    }

    @Override
    public void registerForReflection(Field ... fields) {
        RuntimeReflection.register((Field[])fields);
    }

    @Override
    public void initializeAtBuildTime(String ... classNames) {
        for (String className : classNames) {
            try {
                Class<?> clazz = Class.forName(className);
                this.initializeAtBuildTime(clazz);
            }
            catch (ClassNotFoundException e) {
                JUnitPlatformFeature.debug("[Native Image Configuration] Failed to register class for build time initialization: %s Reason: %s", className, e);
            }
        }
    }

    @Override
    public void initializeAtBuildTime(Class<?> ... classes) {
        RuntimeClassInitialization.initializeAtBuildTime((Class[])classes);
    }
}

