/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.process.CommandLineArgumentProvider;

public abstract class AgentCommandLineProvider
implements CommandLineArgumentProvider {
    @Inject
    public AgentCommandLineProvider() {
    }

    @Input
    public abstract Property<Boolean> getEnabled();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @Input
    @Optional
    public abstract ListProperty<String> getAgentOptions();

    public Iterable<String> asArguments() {
        if (((Boolean)this.getEnabled().get()).booleanValue()) {
            File outputDir = (File)this.getOutputDirectory().getAsFile().get();
            ArrayList<String> agentOptions = new ArrayList<String>((Collection)this.getAgentOptions().getOrElse(Collections.emptyList()));
            if (agentOptions.stream().map(s -> s.split("=")[0]).anyMatch(s -> s.contains("config-output-dir"))) {
                throw new IllegalStateException("config-output-dir cannot be supplied as an agent option");
            }
            agentOptions.add("config-output-dir=" + outputDir.getAbsolutePath() + File.separator + "session-{pid}-{datetime}");
            return Arrays.asList("-agentlib:native-image-agent=" + String.join((CharSequence)",", agentOptions), "-Dorg.graalvm.nativeimage.imagecode=agent");
        }
        return Collections.emptyList();
    }
}

