/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.internal;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.graalvm.buildtools.gradle.NativeImagePlugin;
import org.graalvm.buildtools.gradle.dsl.GraalVMExtension;
import org.graalvm.buildtools.gradle.dsl.NativeImageOptions;
import org.graalvm.buildtools.gradle.internal.DefaultTestBinaryConfig;
import org.graalvm.buildtools.gradle.internal.GradleUtils;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JvmVendorSpec;

public abstract class DefaultGraalVmExtension
implements GraalVMExtension {
    private final NamedDomainObjectContainer<NativeImageOptions> nativeImages;
    private final NativeImagePlugin plugin;
    private final Project project;
    private final Map<String, Provider<Boolean>> agentProperties = new HashMap<String, Provider<Boolean>>();
    private final Property<JavaLauncher> defaultJavaLauncher;

    @Inject
    public DefaultGraalVmExtension(NamedDomainObjectContainer<NativeImageOptions> nativeImages, NativeImagePlugin plugin, Project project) {
        this.nativeImages = nativeImages;
        this.plugin = plugin;
        this.project = project;
        this.defaultJavaLauncher = project.getObjects().property(JavaLauncher.class);
        this.getToolchainDetection().convention((Object)true);
        nativeImages.configureEach(options -> options.getJavaLauncher().convention(this.defaultJavaLauncher));
        this.getTestSupport().convention((Object)true);
        this.configureToolchain();
    }

    private void configureToolchain() {
        this.defaultJavaLauncher.convention(this.getToolchainDetection().flatMap(enabled -> {
            JavaToolchainService toolchainService;
            if (enabled.booleanValue() && (toolchainService = (JavaToolchainService)this.project.getExtensions().findByType(JavaToolchainService.class)) != null) {
                return toolchainService.launcherFor(spec -> {
                    spec.getLanguageVersion().set((Object)JavaLanguageVersion.of((String)JavaVersion.current().getMajorVersion()));
                    if (GradleUtils.isAtLeastGradle7()) {
                        spec.getVendor().set((Object)JvmVendorSpec.matching((String)"GraalVM"));
                    }
                });
            }
            return null;
        }));
    }

    @Override
    public NamedDomainObjectContainer<NativeImageOptions> getBinaries() {
        return this.nativeImages;
    }

    @Override
    public void binaries(Action<? super NamedDomainObjectContainer<NativeImageOptions>> spec) {
        spec.execute(this.nativeImages);
    }

    public Map<String, Provider<Boolean>> getAgentProperties() {
        return this.agentProperties;
    }

    @Override
    public void registerTestBinary(String name, Action<? super GraalVMExtension.TestBinaryConfig> spec) {
        DefaultTestBinaryConfig config = (DefaultTestBinaryConfig)this.project.getObjects().newInstance(DefaultTestBinaryConfig.class, new Object[]{name});
        spec.execute((Object)config);
        this.plugin.registerTestBinary(this.project, this, config);
    }
}

