/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.internal.agent;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.graalvm.buildtools.agent.AgentConfiguration;
import org.graalvm.buildtools.agent.AgentMode;
import org.graalvm.buildtools.agent.ConditionalAgentMode;
import org.graalvm.buildtools.agent.DirectAgentMode;
import org.graalvm.buildtools.agent.DisabledAgentMode;
import org.graalvm.buildtools.agent.StandardAgentMode;
import org.graalvm.buildtools.gradle.dsl.agent.AgentOptions;
import org.graalvm.buildtools.gradle.dsl.agent.ConditionalAgentModeOptions;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.provider.Provider;

public class AgentConfigurationFactory {
    public static Provider<AgentConfiguration> getAgentConfiguration(Provider<String> modeName, AgentOptions options) {
        return modeName.map(name -> {
            StandardAgentMode agentMode;
            ConfigurableFileCollection callerFilterFiles = options.getCallerFilterFiles();
            ConfigurableFileCollection accessFilterFiles = options.getAccessFilterFiles();
            switch (name) {
                case "standard": {
                    agentMode = new StandardAgentMode();
                    break;
                }
                case "disabled": {
                    agentMode = new DisabledAgentMode();
                    break;
                }
                case "conditional": {
                    ConditionalAgentModeOptions opts = options.getModes().getConditional();
                    if (!opts.getUserCodeFilterPath().isPresent()) {
                        throw new GradleException("Missing property userCodeFilterPath in agent conditional configuration");
                    }
                    agentMode = new ConditionalAgentMode((String)opts.getUserCodeFilterPath().get(), (String)opts.getExtraFilterPath().getOrElse((Object)""), ((Boolean)opts.getParallel().get()).booleanValue());
                    break;
                }
                case "direct": {
                    agentMode = new DirectAgentMode((List)options.getModes().getDirect().getOptions().getOrElse(Collections.emptyList()));
                    break;
                }
                default: {
                    throw new GradleException("Unknown agent mode selected: " + name);
                }
            }
            return new AgentConfiguration(AgentConfigurationFactory.getFilePaths(callerFilterFiles), AgentConfigurationFactory.getFilePaths(accessFilterFiles), ((Boolean)options.getBuiltinCallerFilter().get()).booleanValue(), ((Boolean)options.getBuiltinHeuristicFilter().get()).booleanValue(), ((Boolean)options.getEnableExperimentalPredefinedClasses().get()).booleanValue(), ((Boolean)options.getEnableExperimentalUnsafeAllocationTracing().get()).booleanValue(), ((Boolean)options.getTrackReflectionMetadata().get()).booleanValue(), (AgentMode)agentMode);
        });
    }

    private static Collection<String> getFilePaths(ConfigurableFileCollection configurableFileCollection) {
        return configurableFileCollection.getFiles().stream().map(File::getAbsolutePath).collect(Collectors.toList());
    }

    public static Provider<Directory> getAgentOutputDirectoryForTask(ProjectLayout layout, String taskName) {
        return layout.getBuildDirectory().dir("native/agent-output/" + taskName);
    }
}

