/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.tasks;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.graalvm.buildtools.gradle.NativeImagePlugin;
import org.graalvm.buildtools.gradle.dsl.NativeImageOptions;
import org.graalvm.buildtools.gradle.internal.GraalVMLogger;
import org.graalvm.buildtools.gradle.internal.NativeImageCommandLineProvider;
import org.graalvm.buildtools.gradle.internal.NativeImageExecutableLocator;
import org.graalvm.buildtools.utils.SharedConstants;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;

public abstract class BuildNativeImageTask
extends DefaultTask {
    private final Provider<String> graalvmHomeProvider;

    @Nested
    public abstract Property<NativeImageOptions> getOptions();

    @Inject
    protected abstract ExecOperations getExecOperations();

    @Internal
    protected abstract DirectoryProperty getWorkingDirectory();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @InputDirectory
    @Optional
    public abstract DirectoryProperty getTestListDirectory();

    @Optional
    @Input
    protected Provider<String> getGraalVMHome() {
        return this.graalvmHomeProvider;
    }

    @Internal
    public Provider<String> getExecutableShortName() {
        return this.getOptions().flatMap(NativeImageOptions::getImageName);
    }

    @Internal
    public Provider<String> getExecutableName() {
        return this.getOptions().flatMap(options -> options.getImageName().map(name -> name + SharedConstants.EXECUTABLE_EXTENSION));
    }

    @Internal
    public Provider<RegularFile> getOutputFile() {
        return this.getOutputDirectory().map(dir -> (RegularFile)dir.file(this.getExecutableName()).get());
    }

    @Input
    public abstract Property<Boolean> getDisableToolchainDetection();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract ObjectFactory getObjects();

    @InputFile
    @Optional
    public abstract RegularFileProperty getClasspathJar();

    @Input
    @Optional
    public abstract Property<Boolean> getUseArgFile();

    public BuildNativeImageTask() {
        DirectoryProperty buildDir = this.getProject().getLayout().getBuildDirectory();
        Provider outputDir = buildDir.dir("native/" + this.getName());
        this.getWorkingDirectory().set(outputDir);
        this.setDescription("Builds a native image.");
        this.setGroup("verification");
        this.getOutputDirectory().convention(outputDir);
        ProviderFactory providers = this.getProject().getProviders();
        this.graalvmHomeProvider = NativeImageExecutableLocator.graalvmHomeProvider(providers);
        this.getDisableToolchainDetection().convention((Object)false);
    }

    private List<String> buildActualCommandLineArgs() {
        this.getOptions().finalizeValue();
        return new NativeImageCommandLineProvider((Provider<NativeImageOptions>)this.getOptions(), this.getExecutableShortName(), (Provider<String>)this.getProviders().provider(() -> ((File)this.getOutputDirectory().getAsFile().get()).getAbsolutePath()), (Provider<RegularFile>)this.getClasspathJar(), (Provider<Boolean>)this.getUseArgFile()).asArguments();
    }

    @Internal
    public abstract Property<Object> getService();

    @TaskAction
    public void exec() {
        NativeImageOptions options = (NativeImageOptions)this.getOptions().get();
        GraalVMLogger logger = GraalVMLogger.of(this.getLogger());
        String quickBuildEnv = System.getenv("GRAALVM_QUICK_BUILD");
        if (quickBuildEnv != null) {
            logger.warn("Quick build environment variable is set.");
            options.getQuickBuild().set((Object)(quickBuildEnv.isEmpty() || Boolean.parseBoolean(quickBuildEnv) ? 1 : 0));
        }
        List<String> args = this.buildActualCommandLineArgs();
        if (((Boolean)options.getVerbose().get()).booleanValue()) {
            logger.lifecycle("Args are: " + args);
        }
        File executablePath = NativeImageExecutableLocator.findNativeImageExecutable(options.getJavaLauncher(), this.getDisableToolchainDetection(), this.getGraalVMHome(), this.getExecOperations(), logger);
        logger.lifecycle("Using executable path: " + executablePath);
        String executable = executablePath.getAbsolutePath();
        File outputDir = (File)this.getOutputDirectory().getAsFile().get();
        if (outputDir.isDirectory() || outputDir.mkdirs()) {
            this.getExecOperations().exec(spec -> {
                spec.setWorkingDir((Object)this.getWorkingDirectory());
                if (this.getTestListDirectory().isPresent()) {
                    NativeImagePlugin.TrackingDirectorySystemPropertyProvider directoryProvider = (NativeImagePlugin.TrackingDirectorySystemPropertyProvider)this.getObjects().newInstance(NativeImagePlugin.TrackingDirectorySystemPropertyProvider.class, new Object[0]);
                    directoryProvider.getDirectory().set((Provider)this.getTestListDirectory());
                    spec.getArgumentProviders().add(directoryProvider);
                }
                spec.args((Iterable)args);
                this.getService().get();
                spec.setExecutable(executable);
            });
            logger.lifecycle("Native Image written to: " + outputDir);
        }
    }
}

