/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.tasks.actions;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.graalvm.buildtools.agent.AgentMode;
import org.graalvm.buildtools.gradle.internal.GraalVMLogger;
import org.graalvm.buildtools.gradle.internal.NativeImageExecutableLocator;
import org.graalvm.buildtools.utils.NativeImageUtils;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;

public class MergeAgentFilesAction
implements Action<Task> {
    private final Provider<Boolean> isMergingEnabled;
    private final Provider<AgentMode> agentMode;
    private final Provider<Boolean> mergeWithOutputs;
    private final Provider<String> graalvmHomeProvider;
    private final Supplier<List<String>> inputDirs;
    private final Supplier<List<String>> outputDirs;
    private final Provider<Boolean> disableToolchainDetection;
    private final Property<JavaLauncher> noLauncherProperty;
    private final ExecOperations execOperations;

    public MergeAgentFilesAction(Provider<Boolean> isMergingEnabled, Provider<AgentMode> agentMode, Provider<Boolean> mergeWithOutputs, ObjectFactory objectFactory, Provider<String> graalvmHomeProvider, Supplier<List<String>> inputDirs, Supplier<List<String>> outputDirs, Provider<Boolean> disableToolchainDetection, ExecOperations execOperations) {
        this.isMergingEnabled = isMergingEnabled;
        this.agentMode = agentMode;
        this.mergeWithOutputs = mergeWithOutputs;
        this.graalvmHomeProvider = graalvmHomeProvider;
        this.inputDirs = inputDirs;
        this.outputDirs = outputDirs;
        this.disableToolchainDetection = disableToolchainDetection;
        this.execOperations = execOperations;
        this.noLauncherProperty = objectFactory.property(JavaLauncher.class);
    }

    private static boolean isConfigDir(String dir) {
        return Arrays.stream(new File(dir).listFiles()).anyMatch(file -> file.getName().equals("reflect-config.json"));
    }

    public void execute(Task task) {
        if (((Boolean)this.isMergingEnabled.get()).booleanValue()) {
            File nativeImage = NativeImageExecutableLocator.findNativeImageExecutable(this.noLauncherProperty, this.disableToolchainDetection, this.graalvmHomeProvider, this.execOperations, GraalVMLogger.of(task.getLogger()));
            File workingDir = nativeImage.getParentFile();
            File launcher = new File(workingDir, NativeImageUtils.nativeImageConfigureFileName());
            if (!launcher.exists()) {
                task.getLogger().info("Installing native-image-configure");
                this.execOperations.exec(spec -> {
                    spec.executable((Object)nativeImage);
                    spec.args(new Object[]{"--macro:native-image-configure-launcher"});
                });
                NativeImageUtils.maybeCreateConfigureUtilSymlink((File)launcher, (Path)nativeImage.toPath());
            }
            if (launcher.exists()) {
                if (((Boolean)this.mergeWithOutputs.get()).booleanValue()) {
                    List<String> inputs = this.inputDirs.get();
                    ArrayList<String> leftoverOutputDirs = new ArrayList<String>();
                    for (String outputDir : this.outputDirs.get()) {
                        if (MergeAgentFilesAction.isConfigDir(outputDir)) {
                            ArrayList<String> newInputs = new ArrayList<String>(inputs.size() + 1);
                            newInputs.addAll(inputs);
                            newInputs.add(outputDir);
                            this.mergeAgentFiles(launcher, newInputs, Collections.singletonList(outputDir));
                            continue;
                        }
                        leftoverOutputDirs.add(outputDir);
                    }
                    if (leftoverOutputDirs.size() > 0) {
                        this.mergeAgentFiles(launcher, inputs, leftoverOutputDirs);
                    }
                } else {
                    this.mergeAgentFiles(launcher, this.inputDirs.get(), this.outputDirs.get());
                }
            } else {
                task.getLogger().warn("Cannot merge agent files because native-image-configure is not installed. Please upgrade to a newer version of GraalVM.");
            }
        }
    }

    private void mergeAgentFiles(File launcher, List<String> inputDirs, List<String> outputDirs) {
        ExecResult exec;
        List nicCommandLine = ((AgentMode)this.agentMode.get()).getNativeImageConfigureOptions(inputDirs, outputDirs);
        if (nicCommandLine.size() > 0 && (exec = this.execOperations.exec(spec -> {
            spec.executable((Object)launcher);
            spec.args((Iterable)nicCommandLine);
            spec.setStandardOutput((OutputStream)System.out);
            spec.setErrorOutput((OutputStream)System.err);
        })).getExitValue() != 0) {
            exec.rethrowFailure();
        }
    }
}

