/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.tasks;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.graalvm.buildtools.gradle.NativeImagePlugin;
import org.graalvm.buildtools.gradle.dsl.NativeImageOptions;
import org.graalvm.buildtools.gradle.internal.GraalVMLogger;
import org.graalvm.buildtools.gradle.internal.NativeImageCommandLineProvider;
import org.graalvm.buildtools.gradle.internal.NativeImageExecutableLocator;
import org.graalvm.buildtools.utils.NativeImageUtils;
import org.graalvm.buildtools.utils.SharedConstants;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;

public abstract class BuildNativeImageTask
extends DefaultTask {
    private final Provider<String> graalvmHomeProvider;
    private final NativeImageExecutableLocator.Diagnostics diagnostics;

    @Nested
    public abstract Property<NativeImageOptions> getOptions();

    @Option(option="quick-build-native", description="Enables quick build mode")
    public void overrideQuickBuild() {
        ((NativeImageOptions)this.getOptions().get()).getQuickBuild().set((Object)true);
    }

    @Option(option="debug-native", description="Enables debug mode")
    public void overrideDebugBuild() {
        ((NativeImageOptions)this.getOptions().get()).getDebug().set((Object)true);
    }

    @Inject
    protected abstract ExecOperations getExecOperations();

    @Internal
    protected abstract DirectoryProperty getWorkingDirectory();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @InputDirectory
    @Optional
    public abstract DirectoryProperty getTestListDirectory();

    @Optional
    @Input
    protected Provider<String> getGraalVMHome() {
        return this.graalvmHomeProvider;
    }

    @Internal
    public Provider<String> getExecutableShortName() {
        return this.getOptions().flatMap(NativeImageOptions::getImageName);
    }

    @Internal
    public Provider<String> getExecutableName() {
        return this.getOptions().flatMap(options -> options.getImageName().map(name -> name + SharedConstants.EXECUTABLE_EXTENSION));
    }

    @Internal
    public Provider<RegularFile> getOutputFile() {
        return this.getOutputDirectory().map(dir -> (RegularFile)dir.file(this.getExecutableName()).get());
    }

    @Input
    public abstract Property<Boolean> getDisableToolchainDetection();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract ObjectFactory getObjects();

    @InputFile
    @Optional
    public abstract RegularFileProperty getClasspathJar();

    @Input
    @Optional
    public abstract Property<Boolean> getUseArgFile();

    public BuildNativeImageTask() {
        DirectoryProperty buildDir = this.getProject().getLayout().getBuildDirectory();
        Provider outputDir = buildDir.dir("native/" + this.getName());
        this.getWorkingDirectory().set(outputDir);
        this.setDescription("Builds a native image.");
        this.setGroup("verification");
        this.getOutputDirectory().convention(outputDir);
        ProviderFactory providers = this.getProject().getProviders();
        this.diagnostics = new NativeImageExecutableLocator.Diagnostics();
        this.graalvmHomeProvider = NativeImageExecutableLocator.graalvmHomeProvider(providers, this.diagnostics);
        this.getDisableToolchainDetection().convention((Object)false);
    }

    private List<String> buildActualCommandLineArgs() {
        this.getOptions().finalizeValue();
        return new NativeImageCommandLineProvider((Provider<NativeImageOptions>)this.getOptions(), this.getExecutableShortName(), (Provider<String>)this.getProviders().provider(() -> ((Directory)this.getWorkingDirectory().get()).getAsFile().getAbsolutePath()), (Provider<String>)this.getProviders().provider(() -> ((File)this.getOutputDirectory().getAsFile().get()).getAbsolutePath()), (Provider<RegularFile>)this.getClasspathJar(), (Provider<Boolean>)this.getUseArgFile()).asArguments();
    }

    @Internal
    public abstract Property<Object> getService();

    @TaskAction
    public void exec() {
        NativeImageOptions options = (NativeImageOptions)this.getOptions().get();
        GraalVMLogger logger = GraalVMLogger.of(this.getLogger());
        List<String> args = this.buildActualCommandLineArgs();
        if (((Boolean)options.getVerbose().get()).booleanValue()) {
            logger.lifecycle("Args are: " + args);
        }
        File executablePath = NativeImageExecutableLocator.findNativeImageExecutable(options.getJavaLauncher(), this.getDisableToolchainDetection(), this.getGraalVMHome(), this.getExecOperations(), logger, this.diagnostics);
        this.checkRequiredVersionIfNeeded(executablePath, options);
        for (String diagnostic : this.diagnostics.getDiagnostics()) {
            logger.lifecycle(diagnostic);
        }
        String executable = executablePath.getAbsolutePath();
        File outputDir = (File)this.getOutputDirectory().getAsFile().get();
        if (outputDir.isDirectory() || outputDir.mkdirs()) {
            this.getExecOperations().exec(spec -> {
                MapProperty<String, Object> environmentVariables = options.getEnvironmentVariables();
                if (environmentVariables.isPresent() && !((Map)environmentVariables.get()).isEmpty()) {
                    spec.environment((Map)environmentVariables.get());
                }
                spec.setWorkingDir((Object)this.getWorkingDirectory());
                if (this.getTestListDirectory().isPresent()) {
                    NativeImagePlugin.TrackingDirectorySystemPropertyProvider directoryProvider = (NativeImagePlugin.TrackingDirectorySystemPropertyProvider)this.getObjects().newInstance(NativeImagePlugin.TrackingDirectorySystemPropertyProvider.class, new Object[0]);
                    directoryProvider.getDirectory().set((Provider)this.getTestListDirectory());
                    spec.getArgumentProviders().add(directoryProvider);
                }
                spec.args((Iterable)args);
                this.getService().get();
                spec.setExecutable(executable);
            });
            logger.lifecycle("Native Image written to: " + outputDir);
        }
    }

    private void checkRequiredVersionIfNeeded(File executablePath, NativeImageOptions options) {
        if (!options.getRequiredVersion().isPresent()) {
            return;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ExecResult execResult = this.getExecOperations().exec(spec -> {
            spec.setStandardOutput((OutputStream)outputStream);
            spec.args(new Object[]{"--version"});
            spec.setExecutable(executablePath.getAbsolutePath());
        });
        execResult.assertNormalExitValue();
        String versionToCheck = new String(outputStream.toByteArray(), StandardCharsets.UTF_8).replace("\n", "");
        NativeImageUtils.checkVersion((String)((String)options.getRequiredVersion().get()), (String)versionToCheck);
    }
}

