/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.internal;

import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.util.GradleVersion;

public class GradleUtils {
    private static final GradleVersion GRADLE_68 = GradleVersion.version((String)"6.8");
    private static final GradleVersion GRADLE_7 = GradleVersion.version((String)"7.0");
    private static final GradleVersion GRADLE_71 = GradleVersion.version((String)"7.1");

    public static SourceSet findSourceSet(Project project, String sourceSetName) {
        SourceSetContainer sourceSetContainer = GradleUtils.getJavaPluginConvention(project).getSourceSets();
        return (SourceSet)sourceSetContainer.findByName(sourceSetName);
    }

    public static JavaPluginConvention getJavaPluginConvention(Project project) {
        return (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
    }

    public static boolean isAtLeastGradle7() {
        return GradleVersion.current().compareTo(GRADLE_7) >= 0;
    }

    public static boolean isAtLeastGradle6dot8() {
        return GradleVersion.current().compareTo(GRADLE_68) >= 0;
    }

    public static boolean isAtLeastGradle7dot1() {
        return GradleVersion.current().compareTo(GRADLE_71) >= 0;
    }

    public static Configuration findConfiguration(Project project, String name) {
        return project.getConfigurations().getByName(name);
    }

    public static FileCollection transitiveProjectArtifacts(Project project, String name) {
        ConfigurableFileCollection transitiveProjectArtifacts = project.getObjects().fileCollection();
        transitiveProjectArtifacts.from(new Object[]{GradleUtils.findMainArtifacts(project)});
        transitiveProjectArtifacts.from(new Object[]{GradleUtils.findConfiguration(project, name).getIncoming().artifactView(view -> view.componentFilter(ProjectComponentIdentifier.class::isInstance)).getFiles()});
        return transitiveProjectArtifacts;
    }

    public static FileCollection findMainArtifacts(Project project) {
        return GradleUtils.findConfiguration(project, "runtimeElements").getOutgoing().getArtifacts().getFiles();
    }
}

