/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.graalvm.buildtools.agent.AgentConfiguration;
import org.graalvm.buildtools.agent.AgentMode;
import org.graalvm.buildtools.gradle.NativeImageService;
import org.graalvm.buildtools.gradle.dsl.GraalVMExtension;
import org.graalvm.buildtools.gradle.dsl.GraalVMReachabilityMetadataRepositoryExtension;
import org.graalvm.buildtools.gradle.dsl.NativeImageOptions;
import org.graalvm.buildtools.gradle.dsl.agent.AgentOptions;
import org.graalvm.buildtools.gradle.internal.AgentCommandLineProvider;
import org.graalvm.buildtools.gradle.internal.BaseNativeImageOptions;
import org.graalvm.buildtools.gradle.internal.ConfigurationCacheSupport;
import org.graalvm.buildtools.gradle.internal.DefaultGraalVmExtension;
import org.graalvm.buildtools.gradle.internal.DefaultTestBinaryConfig;
import org.graalvm.buildtools.gradle.internal.DeprecatedNativeImageOptions;
import org.graalvm.buildtools.gradle.internal.GraalVMLogger;
import org.graalvm.buildtools.gradle.internal.GraalVMReachabilityMetadataService;
import org.graalvm.buildtools.gradle.internal.GradleUtils;
import org.graalvm.buildtools.gradle.internal.NativeConfigurations;
import org.graalvm.buildtools.gradle.internal.NativeImageExecutableLocator;
import org.graalvm.buildtools.gradle.internal.agent.AgentConfigurationFactory;
import org.graalvm.buildtools.gradle.tasks.BuildNativeImageTask;
import org.graalvm.buildtools.gradle.tasks.CollectReachabilityMetadata;
import org.graalvm.buildtools.gradle.tasks.GenerateResourcesConfigFile;
import org.graalvm.buildtools.gradle.tasks.MetadataCopyTask;
import org.graalvm.buildtools.gradle.tasks.NativeRunTask;
import org.graalvm.buildtools.gradle.tasks.actions.CleanupAgentFilesAction;
import org.graalvm.buildtools.gradle.tasks.actions.MergeAgentFilesAction;
import org.graalvm.buildtools.gradle.tasks.actions.ProcessGeneratedGraalResourceFilesAction;
import org.graalvm.buildtools.utils.SharedConstants;
import org.graalvm.reachability.DirectoryConfiguration;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaApplication;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.testing.Test;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.ExecOperations;
import org.gradle.process.JavaForkOptions;
import org.gradle.util.GFileUtils;

public class NativeImagePlugin
implements Plugin<Project> {
    public static final String NATIVE_COMPILE_TASK_NAME = "nativeCompile";
    public static final String NATIVE_TEST_COMPILE_TASK_NAME = "nativeTestCompile";
    public static final String NATIVE_TEST_TASK_NAME = "nativeTest";
    public static final String NATIVE_MAIN_EXTENSION = "main";
    public static final String NATIVE_TEST_EXTENSION = "test";
    public static final String DEPRECATED_NATIVE_BUILD_EXTENSION = "nativeBuild";
    public static final String DEPRECATED_NATIVE_TEST_EXTENSION = "nativeTest";
    public static final String DEPRECATED_NATIVE_BUILD_TASK = "nativeBuild";
    public static final String DEPRECATED_NATIVE_TEST_BUILD_TASK = "nativeTestBuild";
    public static final String CONFIG_REPO_LOGLEVEL = "org.graalvm.internal.gradle.configrepo.logging";
    private static final String JUNIT_PLATFORM_LISTENERS_UID_TRACKING_ENABLED = "junit.platform.listeners.uid.tracking.enabled";
    private static final String JUNIT_PLATFORM_LISTENERS_UID_TRACKING_OUTPUT_DIR = "junit.platform.listeners.uid.tracking.output.dir";
    private static final String REPOSITORY_COORDINATES = "org.graalvm.buildtools:graalvm-reachability-metadata:0.9.20:repository@zip";
    private GraalVMLogger logger;

    @Inject
    public ArchiveOperations getArchiveOperations() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public ExecOperations getExecOperations() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public FileSystemOperations getFileOperations() {
        throw new UnsupportedOperationException();
    }

    public void apply(@Nonnull Project project) {
        Provider<NativeImageService> nativeImageServiceProvider = NativeImageService.registerOn(project);
        this.logger = GraalVMLogger.of(project.getLogger());
        DefaultGraalVmExtension graalExtension = (DefaultGraalVmExtension)this.registerGraalVMExtension(project);
        graalExtension.getUseArgFile().convention((Object)SharedConstants.IS_WINDOWS);
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> this.configureJavaProject(project, nativeImageServiceProvider, graalExtension));
        project.getPlugins().withType(JavaLibraryPlugin.class, javaLibraryPlugin -> graalExtension.getAgent().getDefaultMode().convention((Object)"conditional"));
        project.afterEvaluate(p -> {
            this.instrumentTasksWithAgent(project, graalExtension);
            for (NativeImageOptions options : graalExtension.getBinaries()) {
                if (((List)options.getAgent().getOptions().get()).size() <= 0 && !options.getAgent().getEnabled().isPresent()) continue;
                this.logger.warn("The agent block in binary configuration '" + options.getName() + "' is deprecated.");
                this.logger.warn("Such agent configuration has no effect and will become an error in the future.");
            }
        });
    }

    private void instrumentTasksWithAgent(Project project, DefaultGraalVmExtension graalExtension) {
        Provider<String> agentMode = NativeImagePlugin.agentProperty(project, graalExtension.getAgent());
        Predicate taskPredicate = (Predicate)graalExtension.getAgent().getTasksToInstrumentPredicate().getOrElse(ConfigurationCacheSupport.serializablePredicateOf(t -> true));
        project.getTasks().configureEach(t -> {
            if (NativeImagePlugin.isTaskInstrumentableByAgent(t) && taskPredicate.test(t)) {
                this.configureAgent(project, agentMode, graalExtension, this.getExecOperations(), this.getFileOperations(), (Task)t, (JavaForkOptions)t);
            } else {
                String reason = NativeImagePlugin.isTaskInstrumentableByAgent(t) ? "Not instrumentable by agent as it does not extend JavaForkOptions." : "Task does not match user predicate";
                this.logger.log("Not instrumenting task with native-image-agent: " + t.getName() + ". Reason: " + reason);
            }
        });
    }

    private static boolean isTaskInstrumentableByAgent(Task task) {
        return task instanceof JavaForkOptions;
    }

    private static String deriveTaskName(String name, String prefix, String suffix) {
        if (NATIVE_MAIN_EXTENSION.equals(name)) {
            return prefix + suffix;
        }
        return prefix + NativeImagePlugin.capitalize(name) + suffix;
    }

    private void configureJavaProject(Project project, Provider<NativeImageService> nativeImageServiceProvider, DefaultGraalVmExtension graalExtension) {
        this.logger.log("====================");
        this.logger.log("Initializing project: " + project.getName());
        this.logger.log("====================");
        NativeImageOptions mainOptions = NativeImagePlugin.createMainOptions(graalExtension, project);
        this.deprecateExtension(project, mainOptions, "nativeBuild", NATIVE_MAIN_EXTENSION);
        project.getPlugins().withId("application", p -> mainOptions.getMainClass().convention((Provider)((JavaApplication)Objects.requireNonNull(project.getExtensions().findByType(JavaApplication.class))).getMainClass()));
        project.getPlugins().withId("java-library", p -> mainOptions.getSharedLibrary().convention((Object)true));
        NativeImagePlugin.registerServiceProvider(project, nativeImageServiceProvider);
        TaskContainer tasks = project.getTasks();
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        this.configureAutomaticTaskCreation(project, graalExtension, tasks, javaConvention.getSourceSets());
        TaskProvider imageBuilder = tasks.named(NATIVE_COMPILE_TASK_NAME, BuildNativeImageTask.class);
        tasks.register("nativeBuild", t -> {
            t.dependsOn(new Object[]{imageBuilder});
            t.doFirst("Warn about deprecation", task -> task.getLogger().warn("Task nativeBuild is deprecated. Use nativeCompile instead."));
        });
        graalExtension.registerTestBinary(NATIVE_TEST_EXTENSION, (Action<? super GraalVMExtension.TestBinaryConfig>)((Action)config -> {
            config.forTestTask((TaskProvider<Test>)tasks.named(NATIVE_TEST_EXTENSION, Test.class));
            config.usingSourceSet(GradleUtils.findSourceSet(project, NATIVE_TEST_EXTENSION));
        }));
        project.getTasks().register("metadataCopy", MetadataCopyTask.class, task -> {
            task.setGroup("build");
            task.setDescription("Copies metadata collected from tasks instrumented with the agent into target directories.");
            task.getInputTaskNames().set(graalExtension.getAgent().getMetadataCopy().getInputTaskNames());
            task.getOutputDirectories().set(graalExtension.getAgent().getMetadataCopy().getOutputDirectories());
            task.getMergeWithExisting().set(graalExtension.getAgent().getMetadataCopy().getMergeWithExisting());
            task.getToolchainDetection().set(graalExtension.getToolchainDetection());
        });
        project.getTasks().register("collectReachabilityMetadata", CollectReachabilityMetadata.class, task -> {
            task.setGroup("build");
            task.setDescription("Obtains native reachability metdata for the runtime classpath configuration");
        });
        GraalVMReachabilityMetadataRepositoryExtension metadataRepositoryExtension = NativeImagePlugin.reachabilityExtensionOn(graalExtension);
        TaskCollection reachabilityMetadataCopyTasks = project.getTasks().withType(CollectReachabilityMetadata.class);
        reachabilityMetadataCopyTasks.configureEach(task -> {
            Provider<GraalVMReachabilityMetadataService> reachabilityMetadataService = this.graalVMReachabilityMetadataService(project, metadataRepositoryExtension);
            task.getMetadataService().set(reachabilityMetadataService);
            task.usesService(reachabilityMetadataService);
            task.getUri().convention(task.getVersion().map(this::getReachabilityMetadataRepositoryUrlForVersion).orElse(metadataRepositoryExtension.getUri()));
            task.getExcludedModules().convention(metadataRepositoryExtension.getExcludedModules());
            task.getModuleToConfigVersion().convention(metadataRepositoryExtension.getModuleToConfigVersion());
            task.getInto().convention(project.getLayout().getBuildDirectory().dir("native-reachability-metadata"));
        });
    }

    private void configureAutomaticTaskCreation(Project project, GraalVMExtension graalExtension, TaskContainer tasks, SourceSetContainer sourceSets) {
        graalExtension.getBinaries().configureEach(options -> {
            String binaryName = options.getName();
            String compileTaskName = NativeImagePlugin.deriveTaskName(binaryName, "native", "Compile");
            if (NATIVE_MAIN_EXTENSION.equals(binaryName)) {
                compileTaskName = NATIVE_COMPILE_TASK_NAME;
            }
            TaskProvider imageBuilder = tasks.register(compileTaskName, BuildNativeImageTask.class, builder -> {
                builder.setDescription("Compiles a native image for the " + options.getName() + " binary");
                builder.setGroup("build");
                builder.getOptions().convention(options);
                builder.getUseArgFile().convention(graalExtension.getUseArgFile());
            });
            String runTaskName = NativeImagePlugin.deriveTaskName(binaryName, "native", "Run");
            if (NATIVE_MAIN_EXTENSION.equals(binaryName)) {
                runTaskName = "nativeRun";
            } else if (binaryName.toLowerCase(Locale.US).endsWith(NATIVE_TEST_EXTENSION)) {
                runTaskName = "native" + NativeImagePlugin.capitalize(binaryName);
            }
            tasks.register(runTaskName, NativeRunTask.class, task -> {
                task.setGroup("build");
                task.setDescription("Executes the " + options.getName() + " native binary");
                task.getImage().convention(imageBuilder.map(t -> (RegularFile)t.getOutputFile().get()));
                task.getRuntimeArgs().convention((Provider)options.getRuntimeArgs());
            });
            this.configureClasspathJarFor(tasks, (NativeImageOptions)options, (TaskProvider<BuildNativeImageTask>)imageBuilder);
            SourceSet sourceSet = NATIVE_TEST_EXTENSION.equals(binaryName) ? (SourceSet)sourceSets.getByName(NATIVE_TEST_EXTENSION) : (SourceSet)sourceSets.getByName(NATIVE_MAIN_EXTENSION);
            TaskProvider<GenerateResourcesConfigFile> generateResourcesConfig = this.registerResourcesConfigTask((Provider<Directory>)graalExtension.getGeneratedResourcesDirectory(), (NativeImageOptions)options, tasks, GradleUtils.transitiveProjectArtifacts(project, sourceSet.getRuntimeClasspathConfigurationName()), NativeImagePlugin.deriveTaskName(binaryName, "generate", "ResourcesConfigFile"));
            options.getConfigurationFileDirectories().from(new Object[]{generateResourcesConfig.map(t -> t.getOutputFile().map(f -> f.getAsFile().getParentFile()))});
            this.configureJvmReachabilityConfigurationDirectories(project, graalExtension, (NativeImageOptions)options, sourceSet);
            this.configureJvmReachabilityExcludeConfigArgs(project, graalExtension, (NativeImageOptions)options, sourceSet);
        });
    }

    private void configureJvmReachabilityConfigurationDirectories(Project project, GraalVMExtension graalExtension, NativeImageOptions options, SourceSet sourceSet) {
        options.getConfigurationFileDirectories().from(new Object[]{this.graalVMReachabilityQuery(project, graalExtension, sourceSet, configuration -> true, this::getConfigurationDirectory, Collectors.toList())});
    }

    private File getConfigurationDirectory(ModuleVersionIdentifier moduleVersion, DirectoryConfiguration configuration) {
        return configuration.getDirectory().toAbsolutePath().toFile();
    }

    private <T, A, R> Provider<R> graalVMReachabilityQuery(Project project, GraalVMExtension graalExtension, SourceSet sourceSet, Predicate<DirectoryConfiguration> filter, BiFunction<ModuleVersionIdentifier, DirectoryConfiguration, T> mapper, Collector<T, A, R> collector) {
        GraalVMReachabilityMetadataRepositoryExtension extension = NativeImagePlugin.reachabilityExtensionOn(graalExtension);
        return extension.getEnabled().flatMap(enabled -> {
            if (enabled.booleanValue() && extension.getUri().isPresent()) {
                Configuration classpath = project.getConfigurations().getByName(sourceSet.getRuntimeClasspathConfigurationName());
                Set excludedModules = (Set)extension.getExcludedModules().getOrElse(Collections.emptySet());
                Map forcedVersions = (Map)extension.getModuleToConfigVersion().getOrElse(Collections.emptyMap());
                return this.graalVMReachabilityMetadataService(project, extension).map(service -> {
                    Set components = classpath.getIncoming().getResolutionResult().getAllComponents();
                    Stream mapped = components.stream().flatMap(component -> {
                        ModuleVersionIdentifier moduleVersion = component.getModuleVersion();
                        Set<DirectoryConfiguration> configurations = service.findConfigurationsFor(excludedModules, forcedVersions, moduleVersion);
                        return configurations.stream().filter(filter).map(configuration -> mapper.apply(moduleVersion, (DirectoryConfiguration)configuration));
                    });
                    return mapped.collect(collector);
                });
            }
            return project.getProviders().provider(() -> Stream.empty().collect(collector));
        });
    }

    private Provider<GraalVMReachabilityMetadataService> graalVMReachabilityMetadataService(Project project, GraalVMReachabilityMetadataRepositoryExtension repositoryExtension) {
        return project.getGradle().getSharedServices().registerIfAbsent("nativeConfigurationService", GraalVMReachabilityMetadataService.class, spec -> {
            LogLevel logLevel = NativeImagePlugin.determineLogLevel();
            spec.getMaxParallelUsages().set((Object)1);
            ((GraalVMReachabilityMetadataService.Params)spec.getParameters()).getLogLevel().set((Object)logLevel);
            ((GraalVMReachabilityMetadataService.Params)spec.getParameters()).getUri().set(repositoryExtension.getUri().map(configuredUri -> NativeImagePlugin.computeMetadataRepositoryUri(project, repositoryExtension, configuredUri, GraalVMLogger.of(project.getLogger()))));
            ((GraalVMReachabilityMetadataService.Params)spec.getParameters()).getCacheDir().set(new File(project.getGradle().getGradleUserHomeDir(), "native-build-tools/repositories"));
        });
    }

    private static URI computeMetadataRepositoryUri(Project project, GraalVMReachabilityMetadataRepositoryExtension repositoryExtension, URI configuredUri, GraalVMLogger logger) {
        URI defaultUri;
        try {
            defaultUri = new URI(String.format("https://github.com/oracle/graalvm-reachability-metadata/releases/download/%1$s/graalvm-reachability-metadata-%1$s.zip", repositoryExtension.getVersion().get()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to convert repository path to URI", e);
        }
        if (defaultUri.equals(configuredUri)) {
            Configuration configuration = project.getConfigurations().detachedConfiguration(new Dependency[0]);
            Dependency e = project.getDependencies().create((Object)REPOSITORY_COORDINATES);
            configuration.getDependencies().add((Object)e);
            Set files = configuration.getIncoming().artifactView(view -> view.setLenient(true)).getFiles().getFiles();
            if (files.size() == 1) {
                return ((File)files.iterator().next()).toURI();
            }
            logger.warn("Unable to find the GraalVM reachability metadata repository in Maven repository. Falling back to the default repository at " + defaultUri);
        }
        return configuredUri;
    }

    private void configureJvmReachabilityExcludeConfigArgs(Project project, GraalVMExtension graalExtension, NativeImageOptions options, SourceSet sourceSet) {
        options.getExcludeConfig().putAll(this.graalVMReachabilityQuery(project, graalExtension, sourceSet, DirectoryConfiguration::isOverride, this::getExclusionConfig, Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        GraalVMReachabilityMetadataRepositoryExtension repositoryExtension = NativeImagePlugin.reachabilityExtensionOn(graalExtension);
        this.graalVMReachabilityMetadataService(project, repositoryExtension);
    }

    private Map.Entry<String, List<String>> getExclusionConfig(ModuleVersionIdentifier moduleVersion, DirectoryConfiguration configuration) {
        String gav = moduleVersion.getGroup() + ":" + moduleVersion.getName() + ":" + moduleVersion.getVersion();
        return new AbstractMap.SimpleEntry<String, List<String>>(gav, Arrays.asList("^/META-INF/native-image/.*"));
    }

    private static LogLevel determineLogLevel() {
        LogLevel logLevel = LogLevel.DEBUG;
        String loggingProperty = System.getProperty(CONFIG_REPO_LOGLEVEL);
        if (loggingProperty != null) {
            logLevel = LogLevel.valueOf((String)loggingProperty.toUpperCase(Locale.US));
        }
        return logLevel;
    }

    private static GraalVMReachabilityMetadataRepositoryExtension reachabilityExtensionOn(GraalVMExtension graalExtension) {
        return (GraalVMReachabilityMetadataRepositoryExtension)((ExtensionAware)graalExtension).getExtensions().getByType(GraalVMReachabilityMetadataRepositoryExtension.class);
    }

    private void deprecateExtension(Project project, NativeImageOptions delegate, String name, String substitute) {
        ObjectFactory objects = project.getObjects();
        project.getExtensions().add(name, objects.newInstance(DeprecatedNativeImageOptions.class, new Object[]{name, delegate, substitute, project.getLogger()}));
    }

    private void configureClasspathJarFor(TaskContainer tasks, NativeImageOptions options, TaskProvider<BuildNativeImageTask> imageBuilder) {
        String baseName = imageBuilder.getName();
        TaskProvider classpathJar = tasks.register(baseName + "ClasspathJar", Jar.class, jar -> {
            jar.setDescription("Builds a pathing jar for the " + options.getName() + " native binary");
            jar.from(new Object[]{options.getClasspath().getElements().map(elems -> elems.stream().map(e -> {
                if (NativeImagePlugin.isJar(e)) {
                    return this.getArchiveOperations().zipTree(e);
                }
                return e;
            }).collect(Collectors.toList()))});
            jar.setDuplicatesStrategy(DuplicatesStrategy.WARN);
            jar.getArchiveBaseName().set((Object)(baseName.toLowerCase(Locale.ENGLISH) + "-classpath"));
        });
        imageBuilder.configure(nit -> {
            if (((Boolean)options.getUseFatJar().get()).booleanValue()) {
                nit.getClasspathJar().set(classpathJar.flatMap(AbstractArchiveTask::getArchiveFile));
            }
        });
    }

    private static boolean isJar(FileSystemLocation location) {
        return location.getAsFile().getName().toLowerCase(Locale.US).endsWith(".jar");
    }

    private GraalVMExtension registerGraalVMExtension(Project project) {
        NamedDomainObjectContainer nativeImages = project.getObjects().domainObjectContainer(NativeImageOptions.class, name -> (BaseNativeImageOptions)project.getObjects().newInstance(BaseNativeImageOptions.class, new Object[]{name, project.getObjects(), project.getProviders(), project.getExtensions().findByType(JavaToolchainService.class), project.getName()}));
        GraalVMExtension graalvmNative = (GraalVMExtension)project.getExtensions().create(GraalVMExtension.class, "graalvmNative", DefaultGraalVmExtension.class, new Object[]{nativeImages, this, project});
        graalvmNative.getGeneratedResourcesDirectory().set(project.getLayout().getBuildDirectory().dir("native/generated/"));
        this.configureNativeConfigurationRepo((ExtensionAware)graalvmNative);
        return graalvmNative;
    }

    private void configureNativeConfigurationRepo(ExtensionAware graalvmNative) {
        GraalVMReachabilityMetadataRepositoryExtension configurationRepository = (GraalVMReachabilityMetadataRepositoryExtension)graalvmNative.getExtensions().create("metadataRepository", GraalVMReachabilityMetadataRepositoryExtension.class, new Object[0]);
        configurationRepository.getEnabled().convention((Object)false);
        configurationRepository.getVersion().convention((Object)"0.2.6");
        configurationRepository.getUri().convention(configurationRepository.getVersion().map(this::getReachabilityMetadataRepositoryUrlForVersion));
        configurationRepository.getExcludedModules().convention(Collections.emptySet());
        configurationRepository.getModuleToConfigVersion().convention(Collections.emptyMap());
    }

    private URI getReachabilityMetadataRepositoryUrlForVersion(String version) {
        try {
            return new URI(String.format("https://github.com/oracle/graalvm-reachability-metadata/releases/download/%1$s/graalvm-reachability-metadata-%1$s.zip", version));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private TaskProvider<GenerateResourcesConfigFile> registerResourcesConfigTask(Provider<Directory> generatedDir, NativeImageOptions options, TaskContainer tasks, FileCollection transitiveProjectArtifacts, String name) {
        return tasks.register(name, GenerateResourcesConfigFile.class, task -> {
            task.setDescription("Generates a GraalVM resource-config.json file");
            task.getOptions().convention((Object)options.getResources());
            task.getClasspath().from(new Object[]{options.getClasspath()});
            task.getTransitiveProjectArtifacts().from(new Object[]{transitiveProjectArtifacts});
            task.getOutputFile().convention(generatedDir.map(d -> d.file(name + "/resource-config.json")));
        });
    }

    public void registerTestBinary(Project project, DefaultGraalVmExtension graalExtension, DefaultTestBinaryConfig config) {
        NativeImageOptions mainOptions = (NativeImageOptions)graalExtension.getBinaries().getByName(NATIVE_MAIN_EXTENSION);
        String name = config.getName();
        boolean isPrimaryTest = NATIVE_TEST_EXTENSION.equals(name);
        TaskContainer tasks = project.getTasks();
        File testResultsDir = GradleUtils.getJavaPluginConvention(project).getTestResultsDir();
        DirectoryProperty testListDirectory = project.getObjects().directoryProperty();
        NativeImageOptions testOptions = NativeImagePlugin.createTestOptions(graalExtension, name, project, mainOptions, config.getSourceSet());
        if (isPrimaryTest) {
            this.deprecateExtension(project, testOptions, "nativeTest", NATIVE_TEST_EXTENSION);
        }
        TaskProvider<Test> testTask = config.validate().getTestTask();
        testTask.configure(test -> {
            File testList = new File(testResultsDir, test.getName() + "/testlist");
            testListDirectory.set(testList);
            test.getOutputs().dir((Object)testList);
            test.systemProperty(JUNIT_PLATFORM_LISTENERS_UID_TRACKING_ENABLED, (Object)true);
            TrackingDirectorySystemPropertyProvider directoryProvider = (TrackingDirectorySystemPropertyProvider)project.getObjects().newInstance(TrackingDirectorySystemPropertyProvider.class, new Object[0]);
            directoryProvider.getDirectory().set((Provider)testListDirectory);
            test.getJvmArgumentProviders().add(directoryProvider);
            test.doFirst("cleanup test ids", (Action)new CleanupTestIdsDirectory(testListDirectory));
        });
        NativeImagePlugin.injectTestPluginDependencies(project, graalExtension.getTestSupport());
        TaskProvider testImageBuilder = tasks.named(NativeImagePlugin.deriveTaskName(name, "native", "Compile"), BuildNativeImageTask.class, task -> {
            task.setOnlyIf(t -> (Boolean)graalExtension.getTestSupport().get() != false && ((File)testListDirectory.getAsFile().get()).exists());
            task.getTestListDirectory().set((Provider)testListDirectory);
            testTask.get();
            if (!((String)NativeImagePlugin.agentProperty(project, graalExtension.getAgent()).get()).equals("disabled")) {
                testOptions.getConfigurationFileDirectories().from(new Object[]{AgentConfigurationFactory.getAgentOutputDirectoryForTask(project.getLayout(), testTask.getName())});
            }
            ConfigurableFileCollection testList = project.getObjects().fileCollection();
            testList.from(new Object[]{testListDirectory}).builtBy(new Object[]{testTask});
            testOptions.getClasspath().from(new Object[]{testList});
        });
        if (isPrimaryTest) {
            tasks.register(DEPRECATED_NATIVE_TEST_BUILD_TASK, t -> {
                t.dependsOn(new Object[]{testImageBuilder});
                t.doFirst("Warn about deprecation", task -> task.getLogger().warn("Task nativeTestBuild is deprecated. Use nativeTestCompile instead."));
            });
        }
        tasks.named(isPrimaryTest ? "nativeTest" : "native" + NativeImagePlugin.capitalize(name), NativeRunTask.class, task -> {
            task.setGroup("verification");
            task.setOnlyIf(t -> (Boolean)graalExtension.getTestSupport().get() != false && ((File)testListDirectory.getAsFile().get()).exists());
        });
    }

    private static Provider<String> agentProperty(Project project, AgentOptions options) {
        return project.getProviders().gradleProperty("agent").forUseAtConfigurationTime().map(ConfigurationCacheSupport.serializableTransformerOf(v -> {
            if (!v.isEmpty()) {
                return v;
            }
            return (String)options.getDefaultMode().get();
        })).orElse(options.getEnabled().map(ConfigurationCacheSupport.serializableTransformerOf(enabled -> enabled != false ? (String)options.getDefaultMode().get() : "disabled")));
    }

    private static void registerServiceProvider(Project project, Provider<NativeImageService> nativeImageServiceProvider) {
        project.getTasks().withType(BuildNativeImageTask.class).configureEach(task -> {
            task.usesService(nativeImageServiceProvider);
            task.getService().set(nativeImageServiceProvider);
        });
    }

    private static String capitalize(String name) {
        if (name.length() > 0) {
            return name.substring(0, 1).toUpperCase(Locale.US) + name.substring(1);
        }
        return name;
    }

    private static NativeConfigurations createNativeConfigurations(Project project, String binaryName, String baseClasspathConfigurationName) {
        ConfigurationContainer configurations = project.getConfigurations();
        String prefix = NATIVE_MAIN_EXTENSION.equals(binaryName) ? "" : NativeImagePlugin.capitalize(binaryName);
        Configuration baseClasspath = configurations.getByName(baseClasspathConfigurationName);
        Configuration compileOnly = (Configuration)configurations.create("nativeImage" + prefix + "CompileOnly", c -> {
            c.setCanBeResolved(false);
            c.setCanBeConsumed(false);
        });
        Configuration classpath = (Configuration)configurations.create("nativeImage" + prefix + "Classpath", c -> {
            c.setCanBeConsumed(false);
            c.setCanBeResolved(true);
            c.extendsFrom(new Configuration[]{compileOnly});
            baseClasspath.getExtendsFrom().forEach(xva$0 -> c.extendsFrom(new Configuration[]{xva$0}));
            c.attributes(attrs -> {
                AttributeContainer baseAttributes = baseClasspath.getAttributes();
                Iterator iterator = baseAttributes.keySet().iterator();
                while (iterator.hasNext()) {
                    Attribute attribute;
                    Attribute attr = attribute = (Attribute)iterator.next();
                    Object value = baseAttributes.getAttribute(attr);
                    attrs.attribute(attr, Objects.requireNonNull(value));
                }
            });
        });
        compileOnly.getDependencies().add((Object)project.getDependencies().create((Object)project));
        return new NativeConfigurations(compileOnly, classpath);
    }

    private static NativeImageOptions createMainOptions(GraalVMExtension graalExtension, Project project) {
        NativeImageOptions buildExtension = (NativeImageOptions)graalExtension.getBinaries().create(NATIVE_MAIN_EXTENSION);
        NativeConfigurations configs = NativeImagePlugin.createNativeConfigurations(project, NATIVE_MAIN_EXTENSION, "runtimeClasspath");
        NativeImagePlugin.setupExtensionConfigExcludes(buildExtension, configs);
        buildExtension.getClasspath().from(new Object[]{configs.getImageClasspathConfiguration()});
        return buildExtension;
    }

    private static NativeImageOptions createTestOptions(GraalVMExtension graalExtension, String binaryName, Project project, NativeImageOptions mainExtension, SourceSet sourceSet) {
        NativeImageOptions testExtension = (NativeImageOptions)graalExtension.getBinaries().create(binaryName);
        NativeConfigurations configs = NativeImagePlugin.createNativeConfigurations(project, binaryName, "testRuntimeClasspath");
        NativeImagePlugin.setupExtensionConfigExcludes(testExtension, configs);
        testExtension.getMainClass().set((Object)"org.graalvm.junit.platform.NativeImageJUnitLauncher");
        testExtension.getMainClass().finalizeValue();
        testExtension.getImageName().convention(mainExtension.getImageName().map(name -> name + "-tests"));
        ListProperty runtimeArgs = testExtension.getRuntimeArgs();
        runtimeArgs.add((Object)"--xml-output-dir");
        runtimeArgs.add(project.getLayout().getBuildDirectory().dir("test-results/" + binaryName + "-native").map(d -> d.getAsFile().getAbsolutePath()));
        testExtension.buildArgs("--features=org.graalvm.junit.platform.JUnitPlatformFeature");
        ConfigurableFileCollection classpath = testExtension.getClasspath();
        classpath.from(new Object[]{configs.getImageClasspathConfiguration()});
        classpath.from(new Object[]{sourceSet.getOutput().getClassesDirs()});
        classpath.from(new Object[]{sourceSet.getOutput().getResourcesDir()});
        return testExtension;
    }

    private static void addExcludeConfigArg(List<String> args, Path jarPath, List<String> listOfResourcePatterns) {
        listOfResourcePatterns.forEach(resourcePattern -> {
            args.add("--exclude-config");
            args.add(Pattern.quote(jarPath.toAbsolutePath().toString()));
            args.add(String.format("%s", resourcePattern));
        });
    }

    private static void setupExtensionConfigExcludes(NativeImageOptions options, NativeConfigurations configs) {
        options.getExcludeConfigArgs().set(options.getExcludeConfig().map(excludedConfig -> {
            ArrayList args = new ArrayList();
            excludedConfig.forEach((entry, listOfResourcePatterns) -> {
                if (entry instanceof File) {
                    NativeImagePlugin.addExcludeConfigArg(args, ((File)entry).toPath(), listOfResourcePatterns);
                } else if (entry instanceof String) {
                    String dependency = (String)entry;
                    configs.getImageClasspathConfiguration().getIncoming().artifactView(view -> {
                        view.setLenient(true);
                        view.componentFilter(id -> {
                            if (id instanceof ModuleComponentIdentifier) {
                                ModuleComponentIdentifier mid = (ModuleComponentIdentifier)id;
                                String gav = String.format("%s:%s:%s", mid.getGroup(), mid.getModule(), mid.getVersion());
                                return gav.startsWith(dependency);
                            }
                            return false;
                        });
                    }).getFiles().getFiles().stream().map(File::toPath).forEach(jarPath -> NativeImagePlugin.addExcludeConfigArg(args, jarPath, listOfResourcePatterns));
                } else {
                    throw new UnsupportedOperationException("Expected File or GAV coordinate for excludeConfig option, got " + entry.getClass());
                }
            });
            return args;
        }));
    }

    private static List<String> agentSessionDirectories(Directory outputDirectory) {
        return Arrays.stream((Object[])Objects.requireNonNull(outputDirectory.getAsFile().listFiles(file -> file.isDirectory() && file.getName().startsWith("session-")))).map(File::getAbsolutePath).collect(Collectors.toList());
    }

    private void configureAgent(Project project, Provider<String> agentMode, GraalVMExtension graalExtension, ExecOperations execOperations, FileSystemOperations fileOperations, Task taskToInstrument, JavaForkOptions javaForkOptions) {
        final Provider<AgentConfiguration> agentConfiguration = AgentConfigurationFactory.getAgentConfiguration(agentMode, graalExtension.getAgent());
        taskToInstrument.doFirst((Action)new Action<Task>(){

            public void execute(@Nonnull Task task) {
                if (((AgentConfiguration)agentConfiguration.get()).isEnabled()) {
                    NativeImagePlugin.this.logger.logOnce("Instrumenting task with the native-image-agent: " + task.getName());
                }
            }
        });
        AgentCommandLineProvider cliProvider = (AgentCommandLineProvider)project.getObjects().newInstance(AgentCommandLineProvider.class, new Object[0]);
        cliProvider.getInputFiles().from(new Object[]{agentConfiguration.map(ConfigurationCacheSupport.serializableTransformerOf(AgentConfiguration::getAgentFiles))});
        cliProvider.getEnabled().set(agentConfiguration.map(ConfigurationCacheSupport.serializableTransformerOf(AgentConfiguration::isEnabled)));
        cliProvider.getFilterableEntries().set(graalExtension.getAgent().getFilterableEntries());
        cliProvider.getAgentMode().set(agentMode);
        Provider<Directory> outputDir = AgentConfigurationFactory.getAgentOutputDirectoryForTask(project.getLayout(), taskToInstrument.getName());
        Provider isMergingEnabled = agentConfiguration.map(ConfigurationCacheSupport.serializableTransformerOf(AgentConfiguration::isEnabled));
        Provider agentModeProvider = agentConfiguration.map(ConfigurationCacheSupport.serializableTransformerOf(AgentConfiguration::getAgentMode));
        Supplier<List<String>> mergeInputDirs = ConfigurationCacheSupport.serializableSupplierOf(() -> (List)outputDir.map(ConfigurationCacheSupport.serializableTransformerOf(NativeImagePlugin::agentSessionDirectories)).get());
        Supplier<List<String>> mergeOutputDirs = ConfigurationCacheSupport.serializableSupplierOf(() -> (List)outputDir.map(ConfigurationCacheSupport.serializableTransformerOf(dir -> Collections.singletonList(dir.getAsFile().getAbsolutePath()))).get());
        cliProvider.getOutputDirectory().set(outputDir);
        cliProvider.getAgentOptions().set(agentConfiguration.map(ConfigurationCacheSupport.serializableTransformerOf(AgentConfiguration::getAgentCommandLine)));
        javaForkOptions.getJvmArgumentProviders().add(cliProvider);
        taskToInstrument.doLast((Action)new MergeAgentFilesAction((Provider<Boolean>)isMergingEnabled, (Provider<AgentMode>)agentModeProvider, (Provider<Boolean>)project.provider(() -> false), project.getObjects(), NativeImageExecutableLocator.graalvmHomeProvider(project.getProviders()), mergeInputDirs, mergeOutputDirs, (Provider<Boolean>)graalExtension.getToolchainDetection(), execOperations));
        taskToInstrument.doLast((Action)new CleanupAgentFilesAction(mergeInputDirs, fileOperations));
        taskToInstrument.doLast((Action)new ProcessGeneratedGraalResourceFilesAction(outputDir, graalExtension.getAgent().getFilterableEntries()));
    }

    private static void injectTestPluginDependencies(Project project, Property<Boolean> testSupportEnabled) {
        project.afterEvaluate(p -> {
            if (((Boolean)testSupportEnabled.get()).booleanValue()) {
                project.getDependencies().add("testImplementation", (Object)"org.graalvm.buildtools:junit-platform-native:0.9.20");
            }
        });
    }

    public static abstract class TrackingDirectorySystemPropertyProvider
    implements CommandLineArgumentProvider {
        @OutputDirectory
        public abstract DirectoryProperty getDirectory();

        public Iterable<String> asArguments() {
            return Collections.singleton("-Djunit.platform.listeners.uid.tracking.output.dir=" + ((File)this.getDirectory().getAsFile().get()).getAbsolutePath());
        }
    }

    private static final class CleanupTestIdsDirectory
    implements Action<Task> {
        private final DirectoryProperty directory;

        private CleanupTestIdsDirectory(DirectoryProperty directory) {
            this.directory = directory;
        }

        public void execute(@Nonnull Task task) {
            File dir = (File)this.directory.getAsFile().get();
            if (dir.exists()) {
                GFileUtils.deleteDirectory((File)dir);
            }
        }
    }
}

