/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.dsl;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.graalvm.buildtools.gradle.dsl.NativeResourcesOptions;
import org.graalvm.buildtools.gradle.internal.GradleUtils;
import org.graalvm.buildtools.utils.SharedConstants;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JvmVendorSpec;

public abstract class NativeImageOptions {
    @Input
    public abstract Property<String> getImageName();

    @Input
    @Optional
    public abstract Property<String> getMainClass();

    @Input
    public abstract ListProperty<String> getBuildArgs();

    @Input
    public abstract MapProperty<String, Object> getSystemProperties();

    @InputFiles
    @Classpath
    public abstract ConfigurableFileCollection getClasspath();

    @Input
    public abstract ListProperty<String> getJvmArgs();

    @Input
    public abstract ListProperty<String> getRuntimeArgs();

    @Input
    public abstract Property<Boolean> getDebug();

    @Input
    public abstract Property<Boolean> getFallback();

    @Input
    public abstract Property<Boolean> getVerbose();

    @Input
    public abstract Property<Boolean> getAgent();

    @Input
    public abstract Property<Boolean> getSharedLibrary();

    @Nested
    public abstract Property<JavaLauncher> getJavaLauncher();

    @InputFiles
    public abstract ConfigurableFileCollection getConfigurationFileDirectories();

    @Nested
    public abstract NativeResourcesOptions getResources();

    public void resources(Action<? super NativeResourcesOptions> spec) {
        spec.execute((Object)this.getResources());
    }

    @Inject
    public NativeImageOptions(ObjectFactory objectFactory, ProviderFactory providers, JavaToolchainService toolchains, String defaultImageName) {
        this.getDebug().convention((Object)false);
        this.getFallback().convention((Object)false);
        this.getVerbose().convention((Object)false);
        this.getAgent().convention((Object)false);
        this.getSharedLibrary().convention((Object)false);
        this.getImageName().convention((Object)defaultImageName);
        this.getUseFatJar().convention((Object)SharedConstants.IS_WINDOWS);
        this.getJavaLauncher().convention(toolchains.launcherFor(spec -> {
            spec.getLanguageVersion().set((Object)JavaLanguageVersion.of((String)JavaVersion.current().getMajorVersion()));
            if (GradleUtils.isAtLeastGradle7()) {
                spec.getVendor().set((Object)JvmVendorSpec.matching((String)"GraalVM"));
            }
        }));
    }

    private static Provider<Boolean> property(ProviderFactory providers, String name) {
        return providers.gradleProperty(name).forUseAtConfigurationTime().map(Boolean::valueOf).orElse((Object)false);
    }

    public static NativeImageOptions register(Project project, String extensionName) {
        return (NativeImageOptions)project.getExtensions().create(extensionName, NativeImageOptions.class, new Object[]{project.getObjects(), project.getProviders(), project.getExtensions().findByType(JavaToolchainService.class), project.getName()});
    }

    public NativeImageOptions buildArgs(Object ... buildArgs) {
        this.getBuildArgs().addAll((Iterable)Arrays.stream(buildArgs).map(String::valueOf).collect(Collectors.toList()));
        return this;
    }

    public NativeImageOptions buildArgs(Iterable<?> buildArgs) {
        this.getBuildArgs().addAll((Iterable)StreamSupport.stream(buildArgs.spliterator(), false).map(String::valueOf).collect(Collectors.toList()));
        return this;
    }

    public NativeImageOptions systemProperties(Map<String, ?> properties) {
        MapProperty<String, Object> map = this.getSystemProperties();
        properties.forEach((key, value) -> map.put(key, (Object)(value == null ? null : String.valueOf(value))));
        return this;
    }

    public NativeImageOptions systemProperty(String name, Object value) {
        this.getSystemProperties().put((Object)name, (Object)(value == null ? null : String.valueOf(value)));
        return this;
    }

    public NativeImageOptions classpath(Object ... paths) {
        this.getClasspath().from(paths);
        return this;
    }

    public NativeImageOptions jvmArgs(Object ... arguments) {
        this.getJvmArgs().addAll((Iterable)Arrays.stream(arguments).map(String::valueOf).collect(Collectors.toList()));
        return this;
    }

    public NativeImageOptions jvmArgs(Iterable<?> arguments) {
        this.getJvmArgs().addAll((Iterable)StreamSupport.stream(arguments.spliterator(), false).map(String::valueOf).collect(Collectors.toList()));
        return this;
    }

    public NativeImageOptions runtimeArgs(Object ... arguments) {
        this.getRuntimeArgs().addAll((Iterable)Arrays.stream(arguments).map(String::valueOf).collect(Collectors.toList()));
        return this;
    }

    public NativeImageOptions runtimeArgs(Iterable<?> arguments) {
        this.getRuntimeArgs().addAll((Iterable)StreamSupport.stream(arguments.spliterator(), false).map(String::valueOf).collect(Collectors.toList()));
        return this;
    }

    @Input
    public abstract Property<Boolean> getUseFatJar();
}

