/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.tasks;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.graalvm.buildtools.gradle.dsl.NativeResourcesOptions;
import org.graalvm.buildtools.gradle.dsl.ResourceDetectionOptions;
import org.graalvm.buildtools.gradle.internal.GraalVMLogger;
import org.graalvm.buildtools.model.resources.ClassPathEntryAnalyzer;
import org.graalvm.buildtools.model.resources.Helper;
import org.graalvm.buildtools.model.resources.PatternValue;
import org.graalvm.buildtools.model.resources.ResourceFilter;
import org.graalvm.buildtools.model.resources.ResourcesConfigModel;
import org.graalvm.buildtools.model.resources.ResourcesConfigModelSerializer;
import org.graalvm.buildtools.model.resources.ResourcesModel;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class GenerateResourcesConfigFile
extends DefaultTask {
    @Nested
    public abstract Property<NativeResourcesOptions> getOptions();

    @InputFiles
    @Classpath
    public abstract ConfigurableFileCollection getClasspath();

    @InputFiles
    @Classpath
    public abstract ConfigurableFileCollection getTransitiveProjectArtifacts();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @TaskAction
    public void generate() throws IOException {
        NativeResourcesOptions nativeResourcesOptions = (NativeResourcesOptions)this.getOptions().get();
        ResourceDetectionOptions detectionOptions = nativeResourcesOptions.getDetectionOptions();
        Set bundles = Helper.asNamedValues((List)((List)nativeResourcesOptions.getBundles().get()));
        Set includes = Helper.asPatternValues((List)((List)nativeResourcesOptions.getIncludedPatterns().get()));
        Set excludes = Helper.asPatternValues((List)((List)nativeResourcesOptions.getExcludedPatterns().get()));
        if (((Boolean)detectionOptions.getEnabled().get()).booleanValue()) {
            this.detectResourcesFromClasspath(detectionOptions, includes);
        }
        ResourcesConfigModel model = new ResourcesConfigModel(new ResourcesModel(includes, excludes), bundles);
        this.serializeModel(model, (File)this.getOutputFile().getAsFile().get());
    }

    private void detectResourcesFromClasspath(ResourceDetectionOptions detectionOptions, Set<PatternValue> output) throws IOException {
        Set classpath = this.getClasspath().getFiles();
        ResourceFilter filter = new ResourceFilter((Set)detectionOptions.getDetectionExclusionPatterns().get());
        LinkedHashSet<String> detectedResources = new LinkedHashSet<String>();
        boolean projectLocalOnly = (Boolean)detectionOptions.getRestrictToProjectDependencies().get();
        Set projectsArtifacts = this.getTransitiveProjectArtifacts().getFiles();
        for (File file : classpath) {
            if (projectLocalOnly && file.getName().endsWith(".jar") && !projectsArtifacts.contains(file)) continue;
            this.detectResourcesFromClasspathEntry(filter, detectedResources, file);
        }
        if (!detectedResources.isEmpty()) {
            output.addAll(detectedResources.stream().map(Pattern::quote).map(PatternValue::new).collect(Collectors.toList()));
        }
    }

    private void detectResourcesFromClasspathEntry(ResourceFilter filter, Set<String> detectedResources, File file) throws IOException {
        ClassPathEntryAnalyzer analyzer = ClassPathEntryAnalyzer.of((File)file, arg_0 -> ((ResourceFilter)filter).shouldIncludeResource(arg_0));
        List resources = analyzer.getResources();
        GraalVMLogger.of(this.getLogger()).log("Detected resources for {} are {}", file, resources);
        detectedResources.addAll(resources);
    }

    private void serializeModel(ResourcesConfigModel model, File outputFile) throws IOException {
        ResourcesConfigModelSerializer.serialize((ResourcesConfigModel)model, (File)outputFile);
        GraalVMLogger.of(this.getLogger()).lifecycle("Resources configuration written into " + outputFile);
    }
}

