/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven.sbom;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;

final class ArtifactAdapter {
    final String groupId;
    final String artifactId;
    final String version;
    URI jarPath;
    Set<String> packageNames;
    boolean prunable = true;

    ArtifactAdapter(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.packageNames = new HashSet<String>();
    }

    static ArtifactAdapter fromMavenArtifact(org.apache.maven.artifact.Artifact artifact) {
        return new ArtifactAdapter(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
    }

    static ArtifactAdapter fromEclipseArtifact(Artifact artifact) {
        return new ArtifactAdapter(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
    }

    void setJarPath(URI jarPath) {
        this.jarPath = jarPath;
    }

    void setPackageNames(Set<String> packageNames) {
        this.packageNames = packageNames;
    }

    boolean equals(org.apache.maven.artifact.Artifact otherArtifact) {
        return otherArtifact.getGroupId().equals(this.groupId) && otherArtifact.getArtifactId().equals(this.artifactId) && otherArtifact.getVersion().equals(this.version);
    }
}

