/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.graalvm.buildtools.Utils;
import org.graalvm.buildtools.maven.AbstractNativeMojo;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST, requiresDependencyCollection=ResolutionScope.TEST)
public class NativeTestMojo
extends AbstractNativeMojo {
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipTests) {
            this.logger.info("Tests are skipped.");
            return;
        }
        String classpath = this.getClassPath();
        Path targetFolder = new File(this.project.getBuild().getDirectory()).toPath();
        targetFolder.toFile().mkdirs();
        this.logger.info("====================");
        this.logger.info("Initializing project: " + this.project.getName());
        this.logger.info("====================");
        if (!this.hasTestIds()) {
            this.logger.warn("Test configuration file wasn't found. Build will now fallback to test discovery mode.");
            this.logger.warn("Add following dependency to use the test listener mode:");
            this.logger.warn("<dependency>");
            this.logger.warn("    <groupId>org.graalvm.buildtools</groupId>");
            this.logger.warn("    <artifactId>junit-platform-native</artifactId>");
            this.logger.warn("    <version>0.9.1</version>");
            this.logger.warn("    <scope>test</scope>");
            this.logger.warn("</dependency>");
        }
        this.logger.debug("Classpath: " + classpath);
        this.buildImage(classpath, targetFolder);
        this.runTests(targetFolder);
    }

    private void buildImage(String classpath, Path targetFolder) throws MojoExecutionException {
        Path nativeImageExecutable = Utils.getNativeImage();
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(nativeImageExecutable.toString(), "-cp", classpath, "--features=org.graalvm.junit.platform.JUnitPlatformFeature", "-H:Path=" + targetFolder.toAbsolutePath(), "-H:Name=" + Utils.NATIVE_TESTS_EXE));
        if (this.buildArgs != null) {
            command.addAll(this.buildArgs);
        }
        command.add("org.graalvm.junit.platform.NativeImageJUnitLauncher");
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.directory(new File(this.project.getBuild().getDirectory()));
            processBuilder.inheritIO();
            String commandString = String.join((CharSequence)" ", processBuilder.command());
            this.getLog().info((CharSequence)("Executing: " + commandString));
            Process imageBuildProcess = processBuilder.start();
            if (imageBuildProcess.waitFor() != 0) {
                throw new MojoExecutionException("Execution of " + commandString + " returned non-zero result");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("Building image with " + nativeImageExecutable + " failed", e);
        }
    }

    private void runTests(Path targetFolder) throws MojoExecutionException {
        Path xmlLocation = targetFolder.resolve("native-test-reports");
        xmlLocation.toFile().mkdirs();
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(targetFolder.resolve(Utils.NATIVE_TESTS_EXE).toAbsolutePath().toString(), "--xml-output-dir", xmlLocation.toString());
            processBuilder.inheritIO();
            String commandString = String.join((CharSequence)" ", processBuilder.command());
            this.getLog().info((CharSequence)("Executing: " + commandString));
            Process imageBuildProcess = processBuilder.start();
            if (imageBuildProcess.waitFor() != 0) {
                throw new MojoExecutionException("Execution of " + commandString + " returned non-zero result");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("native-image test run failed");
        }
    }

    private String getClassPath() throws MojoFailureException {
        try {
            List pluginDependencies = this.pluginArtifacts.stream().filter(it -> it.getGroupId().startsWith("org.graalvm.buildtools") || it.getGroupId().startsWith("org.junit")).collect(Collectors.toList());
            ArrayList projectClassPath = new ArrayList(this.project.getTestClasspathElements());
            return Stream.concat(projectClassPath.stream(), pluginDependencies.stream().map(it -> it.getFile().toString())).collect(Collectors.joining(File.pathSeparator));
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean hasTestIds() {
        File testIds = this.getTestIdsFile();
        return testIds.exists() && testIds.length() > 0L;
    }

    private File getTestIdsFile() {
        return new File(this.project.getBuild().getDirectory(), "test_ids.txt");
    }
}

